/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.ResultLblsKey;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.EventFlag;
import de.sep.sesam.model.type.StateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class ResultLbls
extends AbstractModelEntity<ResultLblsKey>
implements MtimeEntity<ResultLblsKey>,
IDisplayLabelProvider {
    private static final long serialVersionUID = 1287975647064536057L;
    @JsonIgnore
    private final ResultLblsKey pk = new ResultLblsKey();
    @JsonIgnore
    private static final Comparator<ResultLbls> eolComparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getEol() == null && o2 != null && o2.getEol() == null) {
            return 0;
        }
        if (o1 == null || o1.getEol() == null) {
            return -1;
        }
        if (o2 == null || o2.getEol() == null) {
            return 1;
        }
        return o1.getEol().compareTo(o2.getEol()) * -1;
    };
    @Schema(description="The unique ID of the backup.", example="20200509104046634")
    @Length(max=64)
    private @Length(max=64) String backupId;
    @Schema(description="The label of the media where the backup is stored.", example="azure-blob-pool00001")
    @NotNull
    @Length(max=30)
    private @NotNull @Length(max=30) String label;
    @Schema(description="The name of the pool where the backup is stored.", example="azure-blob-pool")
    @Length(max=32)
    private @Length(max=32) String pool;
    @Schema(description="The unique ID of the result.", example="1")
    private Long id;
    @Schema(description="The segment number", example="1")
    @NotNull
    @Length(max=20)
    private @NotNull @Length(max=20) String segment;
    @Schema(description="The zero based consecutive number of the save set. ", example="1")
    private Long savesetCount;
    @Schema(description="The name of the location.", example="Munich")
    @Length(max=32)
    private @Length(max=32) String location;
    @Schema(description="The type of the backup type.", example="I")
    @Length(max=8)
    private @Length(max=8) String cfdiType;
    @Schema(description="The checksum of the backup.", example="adler32:3738051594")
    @Length(max=128)
    private @Length(max=128) String checksum;
    @Schema(description="The timestamp of the creation of the result.", example="1614499200000")
    private Date creationTime;
    @Schema(description="The backup end-of-life date and time", example="1614499200000")
    private Date eol;
    @Schema(description="The object or action which changed the backup end-of-life date last.", example="SD20250702091304163@ZNYY5KwxUis|")
    @Length(max=64)
    private @Length(max=64) String eolChangedBy;
    @Schema(description="The user which changed the backup end-of-life date last.", example="SEPsesam")
    @Length(max=255)
    private @Length(max=255) String eolChangedByUser;
    @Schema(description="The message set when the backup end-of-life date changed last.", example="EOL adapted for 3 savesets")
    @Length(max=254)
    private @Length(max=254) String eolChangedByMsg;
    @Schema(description="The flags of the result.")
    @Length(max=32)
    private @Length(max=32) String flags;
    @Schema(description="The save set state. The most common values are \u20180\u2019 (OK) and \u2018X\u2019 or \u20182\u2019 (Error).")
    private StateType savesetState;
    @Schema(description="The sesam date when the backup executed.", example="1614499200000")
    private Date sesamDate;
    @Schema(description="The consecutive backup number.", example="1")
    private Long cnt;
    @Schema(description="The timestamp of the last modification of the record.", example="1614499200000")
    private Date mtime;
    @Schema(description="The unique id.")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @Schema(description="The flag of the backup type.")
    private EventFlag fdiType;
    @Schema(description="The total size of the backup.", example="1024")
    private Double totalSize;
    @Schema(description="The name of the datastore where the backup is stored.", example="Test-Store")
    private String datastore;

    @JsonIgnore
    public static Comparator<ResultLbls> eolSorter() {
        return eolComparator;
    }

    public final String getName() {
        return this.pk.getName();
    }

    public final void setName(String name) {
        this.pk.setName(name);
    }

    public final Long getNum() {
        return this.pk.getNum();
    }

    public final void setNum(Long num) {
        this.pk.setNum(num);
    }

    public final Long getCount() {
        return this.pk.getCount();
    }

    public final void setCount(Long count) {
        this.pk.setCount(count);
    }

    @Override
    @JsonIgnore
    public ResultLblsKey getPK() {
        return this.pk;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.getNum() + "-" + this.getName();
    }

    @Generated
    public String getBackupId() {
        return this.backupId;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getPool() {
        return this.pool;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getSegment() {
        return this.segment;
    }

    @Generated
    public Long getSavesetCount() {
        return this.savesetCount;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getCfdiType() {
        return this.cfdiType;
    }

    @Generated
    public String getChecksum() {
        return this.checksum;
    }

    @Generated
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public String getEolChangedBy() {
        return this.eolChangedBy;
    }

    @Generated
    public String getEolChangedByUser() {
        return this.eolChangedByUser;
    }

    @Generated
    public String getEolChangedByMsg() {
        return this.eolChangedByMsg;
    }

    @Generated
    public String getFlags() {
        return this.flags;
    }

    @Generated
    public StateType getSavesetState() {
        return this.savesetState;
    }

    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public Long getCnt() {
        return this.cnt;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public EventFlag getFdiType() {
        return this.fdiType;
    }

    @Generated
    public Double getTotalSize() {
        return this.totalSize;
    }

    @Generated
    public String getDatastore() {
        return this.datastore;
    }

    @Generated
    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setPool(String pool) {
        this.pool = pool;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSegment(String segment) {
        this.segment = segment;
    }

    @Generated
    public void setSavesetCount(Long savesetCount) {
        this.savesetCount = savesetCount;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setCfdiType(String cfdiType) {
        this.cfdiType = cfdiType;
    }

    @Generated
    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @Generated
    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setEolChangedBy(String eolChangedBy) {
        this.eolChangedBy = eolChangedBy;
    }

    @Generated
    public void setEolChangedByUser(String eolChangedByUser) {
        this.eolChangedByUser = eolChangedByUser;
    }

    @Generated
    public void setEolChangedByMsg(String eolChangedByMsg) {
        this.eolChangedByMsg = eolChangedByMsg;
    }

    @Generated
    public void setFlags(String flags) {
        this.flags = flags;
    }

    @Generated
    public void setSavesetState(StateType savesetState) {
        this.savesetState = savesetState;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setCnt(Long cnt) {
        this.cnt = cnt;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setFdiType(EventFlag fdiType) {
        this.fdiType = fdiType;
    }

    @Generated
    public void setTotalSize(Double totalSize) {
        this.totalSize = totalSize;
    }

    @Generated
    public void setDatastore(String datastore) {
        this.datastore = datastore;
    }

    @Generated
    public ResultLbls() {
    }
}

