/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import de.sep.sesam.model.Clients;
import de.sep.sesam.model.Results;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.browser.LisInfo;
import de.sep.sesam.model.core.interfaces.ICredentialsProvider;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.type.CryptFlagType;
import de.sep.sesam.model.type.PrePost;
import de.sep.sesam.model.type.RestoreMode;
import de.sep.sesam.model.type.RestoreOptions;
import de.sep.sesam.model.type.RestoreOverwriteMode;
import de.sep.sesam.model.type.RestoreTreeType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;

public class RestoreTasks
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity,
ICredentialsProvider {
    @JsonIgnore
    private static final long serialVersionUID = 7524843308053116456L;
    @JsonIgnore
    private static final Comparator<RestoreTasks> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=128)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    @Schema(description="The unique name of the restore task.", example="launches-20111102_165448-1")
    private @NotNull @Length(max=128) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @Schema(description="The result of the restore task.", example="new result")
    private Results result = new Results();
    @NotNull
    @Schema(description="The restore options. When set, the corresponding fields are populated accordingly", example="selective")
    private RestoreOptions type;
    @Schema(description="Flag to control if a generation restore is performed.", example="true")
    private Boolean genmode;
    @Length(max=32)
    @Schema(description="The list mode.", example="NULL")
    private @Length(max=32) String listmode;
    @Schema(description="The map mode.", example="NULL")
    @Length(max=1)
    private @Length(max=1) String mapMode;
    @NotNull
    @Schema(description="The restore tree type. The maximum length of the restore tree type is 2 characters.\nValid values are \u2018f\u2019 (FLAT) or \u2018d\u2019 (DEEP)", example="deep", defaultValue="d")
    private RestoreTreeType treeType = RestoreTreeType.DEEP;
    @Schema(description="The restore mode (v = create new version, o = overwrite existing items, N = overwrite\nitems with newer items from backup, O = overwrite items with older items from\nbackup, n = do not overwrite existing items).", example="m")
    private RestoreMode mode;
    @Schema(description="The restore overwrite mode. Valid values are \u2018NO_OVERWRITE\u2019, \u2018OVERWRITE\u2019,\n\u2018OVERWRITE_NEWER\u2019 and \u2018OVERWRITE_OLDER\u2019.", example="1")
    private RestoreOverwriteMode overwrite;
    @Schema(description="Flag to control the rename mode. When set to true, the restore will create a new\nversion of the item to restore, if the item already exist.", example="true")
    private Boolean rename;
    @Schema(description="Flag to control if the items are restored to the original location or not", example="true")
    private Boolean original;
    @Length(max=255)
    @Schema(description="Flag to control the recovery mode. Used mainly for database recovery.", example="NULL")
    private @Length(max=255) String recover;
    @Schema(description="Flag to control the online mode.", example="NULL")
    @Length(max=64)
    private @Length(max=64) String onlinemode;
    @Schema(description="Flag to control the start mode.", example="NULL")
    @Length(max=64)
    private @Length(max=64) String startmode;
    @Schema(description="The name of the client to attach or mount virtual disks to.", example="client1")
    @Length(max=255)
    private @Length(max=255) String attachClient;
    @Schema(description="The name of the client to restore the items to.")
    @NotNull
    @JsonIncludeProperties(value={"id", "name", "location", "operSystem", "permit"})
    private Clients client;
    @Schema(description="The host name or IP address of the data mover to use", example="client2")
    private String dataMover;
    @Schema(description="The id of the data mover to use for the restore.", example="1")
    private Long dataMoverId;
    @Schema(description="Flag to control if the restore task template is read only. Has effect only if the \u2018template\u2019\nproperty is set.", example="true")
    private Boolean immutableFlags;
    @Schema(description="The mount path to use for the restore.", example="/mnt/restore")
    @Length(max=2048)
    private @Length(max=2048) String mountPath;
    @Schema(description="The path on the selected client to restore the items to", example="/")
    @NotNull
    @Length(max=2048)
    private @NotNull @Length(max=2048) String targetPath;
    @Schema(description="The virtualization host to restore the items to. Only used when restoring virtual backup\nitems. PURPOSE only used for VMWare.", example="esxix.srv.com")
    @Length(max=64)
    private @Length(max=64) String targetServer;
    @Schema(description="The virtualization data store to restore the items to. Only used when restoring virtual\nbackup items. PURPOSE only used for VMWare", example="esxi6test_local")
    private String targetStore;
    @Schema(description="The virtualization folder to restore the items to. Only used when restoring virtual\nbackup items.", example="esxi6test_local")
    @Length(max=2048)
    private @Length(max=2048) String targetFolder;
    @Schema(description="The virtualization network to use for the items to restore. Only used when restoring\nvirtual backup items.", example="network-1=isolated-VMs")
    @Length(max=2048)
    private @Length(max=2048) String targetNetwork;
    @Schema(description="The virtualization resource to use for the items to restore. Only used when restoring\nvirtual backup items.", example="resourcepool=ui-vadp-tests")
    @Length(max=2048)
    private @Length(max=2048) String targetResource;
    @Schema(description="Flag to control if the restore task is a template.", example="true")
    private Boolean template;
    @Schema(description="Flag to mark if the restored data is written into a dump file.", example="true")
    private Boolean dumpFlag;
    @Schema(description="Flag to mark if the path backup type is forced. Used for some backup types, like\nVMware vSphere.", example="true")
    private Boolean pathFlag;
    @Schema(description="Flag to mark this restore task to be a sub task of another restore task. This property is\nset by the Sesam kernel.", example="true")
    private Boolean subtaskFlag;
    @Schema(description="Verify the restored data. Valid values are \u2018VERIFY\u2019 (check for data validity errors).", example="NULL")
    @Length(max=32)
    private @Length(max=32) String verify;
    @Schema(description="The name of the parent restore tasks. This property is set by the Sesam kernel.", example="TEST_BACKUP-20250627145253")
    private String parentTask;
    @Schema(description="The ID of the drive to use.", example="1")
    private Long driveNum;
    @Schema(description="The name of the drive to use.", example="DS@Test-Store_1")
    private String driveName;
    @Schema(description="The name of the interface to use.", example="http://client1.de:11000")
    private String ifaceName;
    @Schema(description="The name of media pools to use.", example="Test-Store_1")
    @Length(max=255)
    private @Length(max=255) String mediaPool;
    @Schema(description="A filter to be matched by the data elements to restore. The filter can be either an\ninclusion or an exclusion filter. More details about the format to use can be found in\nthe Restore Assistant.", example="NULL")
    @Length(max=2048)
    private @Length(max=2048) String filter;
    @Schema(description="The backup source relocation rules.", example="NULL")
    @Length(max=4096)
    private @Length(max=4096) String relocSource;
    @Schema(description="The comma separated list of restore source exclude pattern.")
    @Length(max=1024)
    private @Length(max=1024) String exclude;
    @Schema(description="character are \u2018y\u2019 (yes) or \u2018n\u2019 (no). The meaning of the characters are:\n1. activate pre interface\n2. execute restore despite pre error\n3. activate post interface\n4. execute post despite restore error", example="nnnn")
    private PrePost rPrepost;
    @Schema(description="The creation time stamp of the restore task.", example="20111102_170606")
    private Date makeStamp;
    @Schema(description="The life time of the restore task in days. \u20180\u2019 means that the default life time from the\n\u2018DB:params_fix\u2019 table is used. \u2018-1\u2019 means that the restore task is deleted immediately\nafter completion.", example="0")
    private Long eol;
    @Schema(description="The restore command. This property is set by the Sesam kernel.", example="NULL")
    @Length(max=64)
    private @Length(max=64) String restoreCmd;
    @Schema(description="The list of options to add to the restore command.", example="-a trans=hotadd:san:nbd:nbdssl -a \"vapp=ui-vadp-tests\"")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="The list of server options to add to the restore command on server side.")
    @Length(max=512)
    private @Length(max=512) String srvOptions;
    @Schema(description="Flag to mark if the backup data is encrypted. Valid values are \u2018a\u2019 (AES256) or \u2018b\u2019\n(Blowfish64)", example="b")
    private CryptFlagType cryptFlag;
    @Schema(description="The encrypted encryption key to decrypt the backup data with.")
    @Length(max=128)
    private @Length(max=128) String cryptKey;
    @Schema(description="The name of the user who created the restore task.", example="admin")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String userName = System.getProperty("user.name");
    @Deprecated
    @Schema(description="The user name to use for authentication with the remote service, if necessary. Use the \u2018credentialId\u2019 field instead.", example="admin")
    @Length(max=255)
    private @Length(max=255) String username;
    @Deprecated
    @Schema(description="The user name to use for authentication with the remote service, if necessary. Use the \u2018credentialId\u2019 field instead.", example="<PASSWORD>")
    @Length(max=512)
    private @Length(max=512) String password;
    @Schema(description="The credential ID to use for authentication with the remote service, if necessary.", example="1234567890")
    private Long credentialId;
    @Schema(description="The UUID of the credentials set to use for the authentication with the remote service,\nif necessary. Reserved for future use.", example="1234567890")
    @Length(max=40)
    private @Length(max=40) String credentialUuid;
    @Schema(description="The comment or note from Sesam", example="Created by user Administrator with Web Restore Assistant (Mode advanced - Version server,5.1.0.57,20241105180832)")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="The comment or note from the user.", example="WebUI Restore from backup Nov 4, 2024 1:23:12 PM vcenter7fix.sep.de/ui-vadp-test-2disks-small to vcenter7fix.sep.de/ui-vadp-test-2disks-small-Guifix-Restore")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The backup type of the restore task.", example="VMWARE_VSPHERE")
    private BackupType backupType;
    @Schema(description="Last modification timestamp", example="2025-06-30T10:00:00Z")
    private Date mtime;
    @Schema(description="The absolute file name of a file containing a list of items to restore. Used for Single\nItem Restore (SIR) restore tasks")
    @Length(max=1024)
    private @Length(max=1024) String selFile;
    @Schema(description="The ID of the backup to restore the data from. When set, the \u2018result\u2019 property will be\npopulated with the matching data from the DB.", example="20250702080004323@NZrHUEHP29T")
    private String savesetId;
    @Schema(description="The list of items to restore. When set, the list of items is written to a selection file and\nthe \u2018selFile\u2019 property is populated accordingly.")
    private List<LisInfo> selectedFiles;
    @Schema(description="The restore options. When set, the corresponding fields are populated accordingly.\n")
    private de.sep.sesam.model.v2.RestoreOptions restoreOptions;
    @Schema(description="Update", example="true")
    private Boolean update;

    @JsonIgnore
    public static Comparator<RestoreTasks> sorter() {
        return comparator;
    }

    public RestoreTasks(String name) {
        this.name = name;
    }

    public RestoreMode getMode() {
        return this.mode != null ? this.mode : RestoreMode.NONE;
    }

    public PrePost getrPrepost() {
        return this.rPrepost;
    }

    public void setrPrepost(PrePost rPrepost) {
        this.rPrepost = rPrepost;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setClientId(Long clientId) {
        if (clientId == null || this.client != null) {
            return;
        }
        this.client = new Clients(clientId);
    }

    public Long getClientId() {
        return this.client != null ? this.client.getId() : null;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Results getResult() {
        return this.result;
    }

    @Generated
    public RestoreOptions getType() {
        return this.type;
    }

    @Generated
    public Boolean getGenmode() {
        return this.genmode;
    }

    @Generated
    public String getListmode() {
        return this.listmode;
    }

    @Generated
    public String getMapMode() {
        return this.mapMode;
    }

    @Generated
    public RestoreTreeType getTreeType() {
        return this.treeType;
    }

    @Generated
    public RestoreOverwriteMode getOverwrite() {
        return this.overwrite;
    }

    @Generated
    public Boolean getRename() {
        return this.rename;
    }

    @Generated
    public Boolean getOriginal() {
        return this.original;
    }

    @Generated
    public String getRecover() {
        return this.recover;
    }

    @Generated
    public String getOnlinemode() {
        return this.onlinemode;
    }

    @Generated
    public String getStartmode() {
        return this.startmode;
    }

    @Generated
    public String getAttachClient() {
        return this.attachClient;
    }

    @Generated
    public Clients getClient() {
        return this.client;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public Long getDataMoverId() {
        return this.dataMoverId;
    }

    @Generated
    public Boolean getImmutableFlags() {
        return this.immutableFlags;
    }

    @Generated
    public String getMountPath() {
        return this.mountPath;
    }

    @Generated
    public String getTargetPath() {
        return this.targetPath;
    }

    @Generated
    public String getTargetServer() {
        return this.targetServer;
    }

    @Generated
    public String getTargetStore() {
        return this.targetStore;
    }

    @Generated
    public String getTargetFolder() {
        return this.targetFolder;
    }

    @Generated
    public String getTargetNetwork() {
        return this.targetNetwork;
    }

    @Generated
    public String getTargetResource() {
        return this.targetResource;
    }

    @Generated
    public Boolean getTemplate() {
        return this.template;
    }

    @Generated
    public Boolean getDumpFlag() {
        return this.dumpFlag;
    }

    @Generated
    public Boolean getPathFlag() {
        return this.pathFlag;
    }

    @Generated
    public Boolean getSubtaskFlag() {
        return this.subtaskFlag;
    }

    @Generated
    public String getVerify() {
        return this.verify;
    }

    @Generated
    public String getParentTask() {
        return this.parentTask;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getDriveName() {
        return this.driveName;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getMediaPool() {
        return this.mediaPool;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public String getRelocSource() {
        return this.relocSource;
    }

    @Generated
    public String getExclude() {
        return this.exclude;
    }

    @Generated
    public Date getMakeStamp() {
        return this.makeStamp;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Generated
    public String getRestoreCmd() {
        return this.restoreCmd;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getSrvOptions() {
        return this.srvOptions;
    }

    @Generated
    public CryptFlagType getCryptFlag() {
        return this.cryptFlag;
    }

    @Generated
    public String getCryptKey() {
        return this.cryptKey;
    }

    @Deprecated
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Long getCredentialId() {
        return this.credentialId;
    }

    @Override
    @Generated
    public String getCredentialUuid() {
        return this.credentialUuid;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public BackupType getBackupType() {
        return this.backupType;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getSelFile() {
        return this.selFile;
    }

    @Generated
    public String getSavesetId() {
        return this.savesetId;
    }

    @Generated
    public List<LisInfo> getSelectedFiles() {
        return this.selectedFiles;
    }

    @Generated
    public de.sep.sesam.model.v2.RestoreOptions getRestoreOptions() {
        return this.restoreOptions;
    }

    @Generated
    public Boolean getUpdate() {
        return this.update;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setResult(Results result) {
        this.result = result;
    }

    @Generated
    public void setType(RestoreOptions type) {
        this.type = type;
    }

    @Generated
    public void setGenmode(Boolean genmode) {
        this.genmode = genmode;
    }

    @Generated
    public void setListmode(String listmode) {
        this.listmode = listmode;
    }

    @Generated
    public void setMapMode(String mapMode) {
        this.mapMode = mapMode;
    }

    @Generated
    public void setTreeType(RestoreTreeType treeType) {
        this.treeType = treeType;
    }

    @Generated
    public void setMode(RestoreMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setOverwrite(RestoreOverwriteMode overwrite) {
        this.overwrite = overwrite;
    }

    @Generated
    public void setRename(Boolean rename) {
        this.rename = rename;
    }

    @Generated
    public void setOriginal(Boolean original) {
        this.original = original;
    }

    @Generated
    public void setRecover(String recover) {
        this.recover = recover;
    }

    @Generated
    public void setOnlinemode(String onlinemode) {
        this.onlinemode = onlinemode;
    }

    @Generated
    public void setStartmode(String startmode) {
        this.startmode = startmode;
    }

    @Generated
    public void setAttachClient(String attachClient) {
        this.attachClient = attachClient;
    }

    @Generated
    public void setClient(Clients client) {
        this.client = client;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setDataMoverId(Long dataMoverId) {
        this.dataMoverId = dataMoverId;
    }

    @Generated
    public void setImmutableFlags(Boolean immutableFlags) {
        this.immutableFlags = immutableFlags;
    }

    @Generated
    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    @Generated
    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    @Generated
    public void setTargetServer(String targetServer) {
        this.targetServer = targetServer;
    }

    @Generated
    public void setTargetStore(String targetStore) {
        this.targetStore = targetStore;
    }

    @Generated
    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    @Generated
    public void setTargetNetwork(String targetNetwork) {
        this.targetNetwork = targetNetwork;
    }

    @Generated
    public void setTargetResource(String targetResource) {
        this.targetResource = targetResource;
    }

    @Generated
    public void setTemplate(Boolean template) {
        this.template = template;
    }

    @Generated
    public void setDumpFlag(Boolean dumpFlag) {
        this.dumpFlag = dumpFlag;
    }

    @Generated
    public void setPathFlag(Boolean pathFlag) {
        this.pathFlag = pathFlag;
    }

    @Generated
    public void setSubtaskFlag(Boolean subtaskFlag) {
        this.subtaskFlag = subtaskFlag;
    }

    @Generated
    public void setVerify(String verify) {
        this.verify = verify;
    }

    @Generated
    public void setParentTask(String parentTask) {
        this.parentTask = parentTask;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setMediaPool(String mediaPool) {
        this.mediaPool = mediaPool;
    }

    @Generated
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Generated
    public void setRelocSource(String relocSource) {
        this.relocSource = relocSource;
    }

    @Generated
    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    @Generated
    public void setMakeStamp(Date makeStamp) {
        this.makeStamp = makeStamp;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Generated
    public void setRestoreCmd(String restoreCmd) {
        this.restoreCmd = restoreCmd;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setSrvOptions(String srvOptions) {
        this.srvOptions = srvOptions;
    }

    @Generated
    public void setCryptFlag(CryptFlagType cryptFlag) {
        this.cryptFlag = cryptFlag;
    }

    @Generated
    public void setCryptKey(String cryptKey) {
        this.cryptKey = cryptKey;
    }

    @Deprecated
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Generated
    public void setCredentialId(Long credentialId) {
        this.credentialId = credentialId;
    }

    @Override
    @Generated
    public void setCredentialUuid(String credentialUuid) {
        this.credentialUuid = credentialUuid;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setSelFile(String selFile) {
        this.selFile = selFile;
    }

    @Generated
    public void setSavesetId(String savesetId) {
        this.savesetId = savesetId;
    }

    @Generated
    public void setSelectedFiles(List<LisInfo> selectedFiles) {
        this.selectedFiles = selectedFiles;
    }

    @Generated
    public void setRestoreOptions(de.sep.sesam.model.v2.RestoreOptions restoreOptions) {
        this.restoreOptions = restoreOptions;
    }

    @Generated
    public void setUpdate(Boolean update) {
        this.update = update;
    }

    @Generated
    public RestoreTasks() {
    }
}

