/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.runtime.interfaces.IResultsModel;
import de.sep.sesam.model.type.RestoreMode;
import de.sep.sesam.model.type.RestoreOptions;
import de.sep.sesam.model.type.RestoreOverwriteMode;
import de.sep.sesam.model.type.RestoreTreeType;
import de.sep.sesam.model.type.StateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class RestoreResults
extends AbstractModelEntity<String>
implements IResultsModel<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -7468115335487456169L;
    @JsonIgnore
    private static final Comparator<RestoreResults> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=64)
    @Schema(description="The unique name of the restore.", example="restore_session_20250701_12345")
    private @NotNull @Length(max=64) String name;
    @NotNull
    @Schema(description="The date and time when the restore started.", example="2025-07-01T10:30:00Z")
    private Date startTime;
    @Schema(description="The restore state.", example="SUCCESS")
    private StateType state;
    @NotNull
    @Length(max=128)
    @Schema(description="The name of the restore task.", example="daily_vm_restore_task")
    private @NotNull @Length(max=128) String restoreTask;
    @Length(max=255)
    @Schema(description="The name of the client, where to restore the data to.", example="target_client_server")
    private @Length(max=255) String client;
    @Schema(description="The unique ID of the client, where to restore the data to.", example="101")
    private Long clientId;
    @Schema(description="The unique ID of the drive used for the restore.", example="1")
    private Long driveNum;
    @Schema(description="The name of the drive used for the restore.", example="TapeDrive01")
    private String driveName;
    @Schema(description="The duration of the restore in seconds.", example="3600")
    private Long duration;
    @Schema(description="The end of life date and time of the restore.", example="2025-08-01T10:30:00Z")
    private Date eol;
    @Length(max=255)
    @Schema(description="The name of the interface used for the restore.", example="eth0")
    private @Length(max=255) String ifaceName;
    @Length(max=1024)
    @Schema(description="The comment or note from Sesam.", example="Restore completed successfully by Sesam.")
    private @Length(max=1024) String sepcomment;
    @Schema(description="The restore process ID, if the restore is still running.", example="12345")
    private Long pid;
    @Schema(description="The priority the restore has been executed with.", example="5")
    private Long priority;
    @Length(max=64)
    @Schema(description="The name of the backup to restore from.", example="full_backup_20250630")
    private @Length(max=64) String saveset;
    @Schema(description="Flag to indicate if the backup to restore from, exists.", example="true", defaultValue="false")
    private Boolean savesetExist;
    @Length(max=30)
    @Schema(description="The schedule name.", example="Daily_VM_Restore")
    private @Length(max=30) String schedule;
    @Schema(description="The Sesam date when the restore executed.", example="2025-07-01T10:30:00Z")
    private Date sesamDate;
    @Length(max=64)
    @Schema(description="The version ID of the Sesam server used for the restore.", example="Sesam 5.0.0")
    private @Length(max=64) String sesamVersion;
    @Length(max=64)
    @Schema(description="The session ID and unique ID of the parent restore.", example="sess_1234567890abcdef")
    private @Length(max=64) String sessionId;
    @Schema(description="The size of the original data in bytes.", example="1073741824.0")
    private Double size;
    @Schema(description="The date and time when the restore finished.", example="2025-07-01T11:30:00Z")
    private Date stopTime;
    @Schema(description="The throughput of the restore in B/s.", example="104857600.0")
    private Double throughput;
    @Length(max=1024)
    @Schema(description="The comment or note from the user.", example="This restore was performed for testing purposes.")
    private @Length(max=1024) String usercomment;
    @Length(max=64)
    @Schema(description="The resolved name of the backup to restore from.", example="resolved_backup_name_123")
    private @Length(max=64) String savesetUsed;
    @Length(max=50)
    @Schema(description="The name of the backup task.", example="daily_full_backup")
    private @Length(max=50) String task;
    @Schema(description="The backup task type.", example="FULL")
    private BackupType backupType;
    @Length(max=32)
    @Schema(description="The backup task sub type.", example="VMware")
    private @Length(max=32) String backupSubType;
    @Schema(description="The date and time when the backup got created.", example="2025-06-30T23:00:00Z")
    private Date savesetDate;
    @Schema(description="The consecutive backup number.", example="5")
    private Long cnt;
    @Schema(description="The restore type.", example="FULL")
    private RestoreOptions restoreType;
    @Schema(description="Flag to indicate if the backup is restored in \u2018generation mode\u2019.", example="true", defaultValue="false")
    private Boolean genmode;
    @Schema(description="Flag to indicate if the existing data will be overwritten.", example="OVERWRITE_ALL")
    private RestoreOverwriteMode overwrite;
    @Length(max=32)
    @Schema(description="The list mode. The maximum length is 32 characters.", example="full_list")
    private @Length(max=32) String listmode;
    @Length(max=1)
    @Schema(description="The map mode.", example="M")
    private @Length(max=1) String mapMode;
    @Schema(description="The restore tree type. Valid values are \u2018DEEP\u2019 and \u2018FLAT\u2019.", example="DEEP")
    private RestoreTreeType treeType;
    @Schema(description="The restore mount mode. Valid values are \u2018ATTACH\u2019, \u2018MOUNT\u2019 and \u2018MOUNT_SAVESET\u2019.", example="MOUNT")
    private RestoreMode mode;
    @Length(max=64)
    @Schema(description="The rename field.", example="renamed_file.txt")
    private @Length(max=64) String rename;
    @Schema(description="Flag to indicate if the data is restored to the original location.", example="true")
    private Boolean original;
    @Length(max=64)
    @Schema(description="The recover options.", example="--skip-errors")
    private @Length(max=64) String recover;
    @Length(max=64)
    @Schema(description="The online mode.", example="online_fast")
    private @Length(max=64) String onlinemode;
    @Length(max=64)
    @Schema(description="The start mode.", example="immediate")
    private @Length(max=64) String startmode;
    @Schema(description="The name of the data mover.", example="data_mover_server_01")
    private String dataMover;
    @Length(max=255)
    @Schema(description="The name of the client, where the backup is attached.", example="attach_client_01")
    private @Length(max=255) String attachClient;
    @Length(max=1024)
    @Schema(description="The target path where to restore the data to.", example="/mnt/restore_data")
    private @Length(max=1024) String target;
    @Length(max=255)
    @Schema(description="The target server where to restore the data to.", example="target_server_hostname")
    private @Length(max=255) String targetServer;
    @Length(max=1024)
    @Schema(description="The target store where to restore the data to.", example="datastore_01")
    private @Length(max=1024) String targetStore;
    @Length(max=2048)
    @Schema(description="The target folder where to restore the data to.", example="/path/to/restore/folder")
    private @Length(max=2048) String targetFolder;
    @Length(max=2048)
    @Schema(description="The target network.", example="192.168.1.0/24")
    private @Length(max=2048) String targetNetwork;
    @Length(max=2048)
    @Schema(description="The target resource where to restore the data to.", example="resource_pool_prod")
    private @Length(max=2048) String targetResource;
    @Schema(description="Flag to indicate if the data is restored to a dump file.", example="true")
    private Boolean dumpFlag;
    @Schema(description="Flag to indicate if the data is restored to the file system.", example="true")
    private Boolean pathFlag;
    @Schema(description="Flag to indicate if the restore is created by a sub restore task.", example="true")
    private Boolean subtaskFlag;
    @Length(max=255)
    @Schema(description="The verification options for the restore.", example="checksum_verify")
    private @Length(max=255) String verify;
    @Length(max=255)
    @Schema(description="The name of the user who restored the data.", example="admin_user")
    private @Length(max=255) String userName;
    @Length(max=64)
    @Schema(description="The name of the parent restore task.", example="parent_restore_task_main")
    private @Length(max=64) String parent;
    @Schema(description="The unique ID of the location the client belongs to.", example="1")
    private Long locationId;
    @Length(max=2048)
    @Schema(description="The filter string.", example="*.log")
    private @Length(max=2048) String filter;
    @Length(max=1024)
    @Schema(description="The source relocation.", example="/old/path/to/data")
    private @Length(max=1024) String relocSource;
    @Length(max=255)
    @Schema(description="The name of the media pool used for the restore.", example="MediaPool_A")
    private @Length(max=255) String mediaPool;
    @Length(max=2)
    @Schema(description="The mount state.", example="MO")
    private @Length(max=2) String mountState;
    @Length(max=2048)
    @Schema(description="The mount path.", example="/mnt/restore_mount")
    private @Length(max=2048) String mountPath;
    @Schema(description="The data size in bytes.", example="1073741824.0")
    private Double dataSize;
    @Schema(description="The size of the restored data in bytes.", example="987654321.0")
    private Double restoreSize;
    @Length(max=255)
    @Schema(description="The restore options.", example="--dry-run")
    private @Length(max=255) String options;
    @Length(max=40)
    @Schema(description="The unique identifier (UUID) of the restore result.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    private @Length(max=40) String uuid;
    @Schema(description="Last modification timestamp", example="2025-07-01T10:30:00Z")
    private Date mtime;
    @Schema(description="Flag indicating SSDD status.", example="false", defaultValue="false")
    private Boolean ssddFlag;
    @Schema(description="The progress of the restore in percent.", example="75.5")
    private Double progress;
    @Schema(description="The start time of the SBC process.", example="2025-07-01T10:29:00Z")
    private Date sbcStart;
    @Schema(description="The date and time when the restore process was terminated.", example="2025-07-01T11:29:00Z")
    private Date terminationTime;
    @JsonIgnore
    private String originServer;

    @JsonIgnore
    public static Comparator<RestoreResults> sorter() {
        return comparator;
    }

    public RestoreResults(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public StateType getState() {
        return this.state;
    }

    @Generated
    public String getRestoreTask() {
        return this.restoreTask;
    }

    @Override
    @Generated
    public String getClient() {
        return this.client;
    }

    @Override
    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getDriveName() {
        return this.driveName;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public Long getPid() {
        return this.pid;
    }

    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public String getSaveset() {
        return this.saveset;
    }

    @Generated
    public Boolean getSavesetExist() {
        return this.savesetExist;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public String getSesamVersion() {
        return this.sesamVersion;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Double getSize() {
        return this.size;
    }

    @Generated
    public Date getStopTime() {
        return this.stopTime;
    }

    @Generated
    public Double getThroughput() {
        return this.throughput;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String getSavesetUsed() {
        return this.savesetUsed;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Generated
    public BackupType getBackupType() {
        return this.backupType;
    }

    @Generated
    public String getBackupSubType() {
        return this.backupSubType;
    }

    @Generated
    public Date getSavesetDate() {
        return this.savesetDate;
    }

    @Generated
    public Long getCnt() {
        return this.cnt;
    }

    @Generated
    public RestoreOptions getRestoreType() {
        return this.restoreType;
    }

    @Generated
    public Boolean getGenmode() {
        return this.genmode;
    }

    @Generated
    public RestoreOverwriteMode getOverwrite() {
        return this.overwrite;
    }

    @Generated
    public String getListmode() {
        return this.listmode;
    }

    @Generated
    public String getMapMode() {
        return this.mapMode;
    }

    @Generated
    public RestoreTreeType getTreeType() {
        return this.treeType;
    }

    @Generated
    public RestoreMode getMode() {
        return this.mode;
    }

    @Generated
    public String getRename() {
        return this.rename;
    }

    @Generated
    public Boolean getOriginal() {
        return this.original;
    }

    @Generated
    public String getRecover() {
        return this.recover;
    }

    @Generated
    public String getOnlinemode() {
        return this.onlinemode;
    }

    @Generated
    public String getStartmode() {
        return this.startmode;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public String getAttachClient() {
        return this.attachClient;
    }

    @Generated
    public String getTarget() {
        return this.target;
    }

    @Generated
    public String getTargetServer() {
        return this.targetServer;
    }

    @Generated
    public String getTargetStore() {
        return this.targetStore;
    }

    @Generated
    public String getTargetFolder() {
        return this.targetFolder;
    }

    @Generated
    public String getTargetNetwork() {
        return this.targetNetwork;
    }

    @Generated
    public String getTargetResource() {
        return this.targetResource;
    }

    @Generated
    public Boolean getDumpFlag() {
        return this.dumpFlag;
    }

    @Generated
    public Boolean getPathFlag() {
        return this.pathFlag;
    }

    @Generated
    public Boolean getSubtaskFlag() {
        return this.subtaskFlag;
    }

    @Generated
    public String getVerify() {
        return this.verify;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getParent() {
        return this.parent;
    }

    @Generated
    public Long getLocationId() {
        return this.locationId;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public String getRelocSource() {
        return this.relocSource;
    }

    @Generated
    public String getMediaPool() {
        return this.mediaPool;
    }

    @Generated
    public String getMountState() {
        return this.mountState;
    }

    @Generated
    public String getMountPath() {
        return this.mountPath;
    }

    @Generated
    public Double getDataSize() {
        return this.dataSize;
    }

    @Generated
    public Double getRestoreSize() {
        return this.restoreSize;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public Boolean getSsddFlag() {
        return this.ssddFlag;
    }

    @Generated
    public Double getProgress() {
        return this.progress;
    }

    @Generated
    public Date getSbcStart() {
        return this.sbcStart;
    }

    @Generated
    public Date getTerminationTime() {
        return this.terminationTime;
    }

    @Override
    @Generated
    public String getOriginServer() {
        return this.originServer;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setState(StateType state) {
        this.state = state;
    }

    @Generated
    public void setRestoreTask(String restoreTask) {
        this.restoreTask = restoreTask;
    }

    @Override
    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Override
    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSaveset(String saveset) {
        this.saveset = saveset;
    }

    @Generated
    public void setSavesetExist(Boolean savesetExist) {
        this.savesetExist = savesetExist;
    }

    @Generated
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setSesamVersion(String sesamVersion) {
        this.sesamVersion = sesamVersion;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setSize(Double size) {
        this.size = size;
    }

    @Generated
    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    @Generated
    public void setThroughput(Double throughput) {
        this.throughput = throughput;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setSavesetUsed(String savesetUsed) {
        this.savesetUsed = savesetUsed;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setBackupType(BackupType backupType) {
        this.backupType = backupType;
    }

    @Generated
    public void setBackupSubType(String backupSubType) {
        this.backupSubType = backupSubType;
    }

    @Generated
    public void setSavesetDate(Date savesetDate) {
        this.savesetDate = savesetDate;
    }

    @Generated
    public void setCnt(Long cnt) {
        this.cnt = cnt;
    }

    @Generated
    public void setRestoreType(RestoreOptions restoreType) {
        this.restoreType = restoreType;
    }

    @Generated
    public void setGenmode(Boolean genmode) {
        this.genmode = genmode;
    }

    @Generated
    public void setOverwrite(RestoreOverwriteMode overwrite) {
        this.overwrite = overwrite;
    }

    @Generated
    public void setListmode(String listmode) {
        this.listmode = listmode;
    }

    @Generated
    public void setMapMode(String mapMode) {
        this.mapMode = mapMode;
    }

    @Generated
    public void setTreeType(RestoreTreeType treeType) {
        this.treeType = treeType;
    }

    @Generated
    public void setMode(RestoreMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setRename(String rename) {
        this.rename = rename;
    }

    @Generated
    public void setOriginal(Boolean original) {
        this.original = original;
    }

    @Generated
    public void setRecover(String recover) {
        this.recover = recover;
    }

    @Generated
    public void setOnlinemode(String onlinemode) {
        this.onlinemode = onlinemode;
    }

    @Generated
    public void setStartmode(String startmode) {
        this.startmode = startmode;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setAttachClient(String attachClient) {
        this.attachClient = attachClient;
    }

    @Generated
    public void setTarget(String target) {
        this.target = target;
    }

    @Generated
    public void setTargetServer(String targetServer) {
        this.targetServer = targetServer;
    }

    @Generated
    public void setTargetStore(String targetStore) {
        this.targetStore = targetStore;
    }

    @Generated
    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    @Generated
    public void setTargetNetwork(String targetNetwork) {
        this.targetNetwork = targetNetwork;
    }

    @Generated
    public void setTargetResource(String targetResource) {
        this.targetResource = targetResource;
    }

    @Generated
    public void setDumpFlag(Boolean dumpFlag) {
        this.dumpFlag = dumpFlag;
    }

    @Generated
    public void setPathFlag(Boolean pathFlag) {
        this.pathFlag = pathFlag;
    }

    @Generated
    public void setSubtaskFlag(Boolean subtaskFlag) {
        this.subtaskFlag = subtaskFlag;
    }

    @Generated
    public void setVerify(String verify) {
        this.verify = verify;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Generated
    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    @Generated
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Generated
    public void setRelocSource(String relocSource) {
        this.relocSource = relocSource;
    }

    @Generated
    public void setMediaPool(String mediaPool) {
        this.mediaPool = mediaPool;
    }

    @Generated
    public void setMountState(String mountState) {
        this.mountState = mountState;
    }

    @Generated
    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    @Generated
    public void setDataSize(Double dataSize) {
        this.dataSize = dataSize;
    }

    @Generated
    public void setRestoreSize(Double restoreSize) {
        this.restoreSize = restoreSize;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setSsddFlag(Boolean ssddFlag) {
        this.ssddFlag = ssddFlag;
    }

    @Generated
    public void setProgress(Double progress) {
        this.progress = progress;
    }

    @Generated
    public void setSbcStart(Date sbcStart) {
        this.sbcStart = sbcStart;
    }

    @Generated
    public void setTerminationTime(Date terminationTime) {
        this.terminationTime = terminationTime;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }

    @Generated
    public RestoreResults() {
    }
}

