/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.sep.sesam.model.AllEvents;
import de.sep.sesam.model.core.AbstractEventsEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.runtime.interfaces.IAllEventsAdaptable;
import de.sep.sesam.model.type.AllEventFlag;
import de.sep.sesam.model.type.AllEventType;
import de.sep.sesam.model.type.MigrationCfdiType;
import de.sep.sesam.model.type.MinMax;
import de.sep.sesam.model.type.ReferenceType;
import de.sep.sesam.model.type.RelativeDate;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class RestoreEvents
extends AbstractEventsEntity
implements IDisplayLabelProvider,
IAllEventsAdaptable,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 8233685727637982677L;
    @JsonIgnore
    private static final Comparator<RestoreEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(as=Long.class)
    @Schema(description="The id of the restore event", example="1")
    private Long id;
    @Length(max=255)
    @Schema(description="The name of the restore event. It can contain only letters, digits, '-', and '_' characters.", example="esxi6test_ha-datacenter_VM-with-verylongname_kjasf-auto-restore-do-not-delete-20241105120037063")
    private @Length(max=255) String name;
    @NotNull
    @Length(max=128)
    @Schema(description="The name of the associated restore task.", example="esxi6test_ha-datacenter_VM-with-verylongname_kjasf-auto-restore-do-not-delete")
    private @NotNull @Length(max=128) String restoreTask;
    @Schema(description="Flag to indicate if the restore event is enabled for execution.", example="true")
    private Boolean exec;
    @Schema(description="The retention time in days.", example="30")
    private Long eol;
    @Length(max=30)
    @Schema(description="The name of the schedule the restore event is associated with.", example="Restore_Weekly_DoSo_0545")
    private @Length(max=30) String scheduleName;
    @Schema(description="The priority of the restore event.", example="1")
    private Long priority;
    @Schema(description="Flag to indicate if the restore event is a blocking event.", example="true")
    private Boolean suppress;
    @Schema(description="The follow up actions to execute when the restore event finished successfully.", example="run_script.sh --success")
    @Length(max=1024)
    private @Length(max=1024) String followUp;
    @Schema(description="The restore event owner.", example="Administrator", defaultValue="System.getProperty(\"user.name\")")
    @NotNull
    @Length(max=30)
    private @NotNull @Length(max=30) String owner = System.getProperty("user.name");
    @Schema(description="The unique ID of the drive to use.", example="1")
    private Long driveNum;
    @Schema(description="The name of the client interface to use.", example="https://localhost:1234")
    @Length(max=255)
    private @Length(max=255) String ifaceName;
    @Schema(description="The name of the server interface to use. ", example="server-interface-01")
    @Length(max=255)
    private @Length(max=255) String srvIfaceName;
    @Schema(description="The list mode.", example="full_list")
    @Length(max=32)
    private @Length(max=32) String listmode;
    @Schema(description="Flag to indicate if the date range selection is based on calendar days (false) or Sesam days (true).", example="true")
    private Boolean absoluteFlag;
    @Schema(description="The saveset start timestamp.", example="1678886400000")
    private Long savesetStart;
    @Schema(description="The saveset end timestamp.", example="1678972800000")
    private Long savesetEnd;
    @Schema(description="The min/max indicator. Valid values are 'MIN' and 'MAX'.", example="MIN")
    private MinMax minMax;
    @Schema(description="The date and time when the backup selection starts. Can be an absolute timestamp or a relative difference from the current time in milliseconds.", example="-7")
    private RelativeDate dateStart;
    @Schema(description="The date and time when the backup selection ends. Can be an absolute timestamp or a relative difference from the current time in milliseconds.", example="0")
    private RelativeDate dateEnd;
    @Schema(description="The maximum amount of time in minutes the event can run.", example="7")
    @JsonIgnore
    private Long lifeTime;
    @Schema(description="The maximum amount of time in minutes the event can wait for execution in the queue.", example="1")
    @JsonIgnore
    private Long duration;
    @Schema(description="The backup state to match. Common values are '0' (OK), 'X' or '2' (Error).", example="0")
    @Length(max=12)
    private @Length(max=12) String state;
    @Schema(description="The CFDI type to match.", example="full")
    private MigrationCfdiType cfdiType;
    @Schema(description="The name of the media pool to use. The maximum length is 255 characters.", example="MP-Blubber")
    @Length(max=255)
    private @Length(max=255) String mediaPool;
    @Schema(description="The media tolerance. The maximum length is 21 characters.", example="strict")
    @Length(max=21)
    private @Length(max=21) String mediaTolerance;
    @Schema(description="The media preference. The maximum length is 21 characters.", example="prefer_tape")
    @Length(max=21)
    private @Length(max=21) String mediaPreference;
    @Schema(description="The name of the data mover to use. The maximum length is 255 characters.", example="test-client")
    @Length(max=255)
    private @Length(max=255) String dataMover;
    @Schema(description="The unique ID of the data mover to use.", example="1")
    private Long dataMoverId;
    @Schema(description="The ID of the backup to use. The maximum length is 64 characters.", example="backup_id_12345")
    @Length(max=64)
    private @Length(max=64) String useSaveset;
    @Schema(description="The restore command. The maximum length is 64 characters.", example="restore_data --verbose")
    @Length(max=64)
    private @Length(max=64) String restoreCmd;
    @Schema(description="The execution options. The maximum length is 255 characters.", example="--force-overwrite")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="The reference type. Valid values are 'START' and 'RESTART'.", example="START")
    private ReferenceType referenceType;
    @Schema(description="The reference ID. The maximum length is 80 characters.", example="1")
    @Length(max=80)
    private @Length(max=80) String referenceId;
    @Schema(description="The comment or note from Sesam. The maximum length is 1024 characters.", example="Automatically generated restore event.")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="The comment or note from the user. The maximum length is 1024 characters.", example="This is a user-added note for the restore.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Flag to indicate if the restore event is visible to the user or not.", example="true")
    private Boolean visible;
    @Schema(description="Flag to indicate if the event has to be started immediately.", example="true")
    private Boolean immediateFlag;
    @Schema(description="Last modification timestamp", example="2025-06-30T10:00:00Z")
    private Date mtime;

    @JsonIgnore
    public static Comparator<RestoreEvents> sorter() {
        return comparator;
    }

    public RestoreEvents(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getObjectLabel() {
        return StringUtils.isNotBlank(this.restoreTask) ? this.restoreTask : "";
    }

    @Override
    @JsonIgnore
    public void fill(AllEvents event) {
        assert (event != null);
        event.setExec(this.getExec());
        event.setEol(this.getEol());
        event.setFollowUp(this.getFollowUp());
        event.setId(this.getId());
        event.setImmediateFlag(this.getImmediateFlag());
        event.setName(this.getName());
        event.setOwner(this.getOwner());
        event.setPriority(this.getPriority());
        event.setSuppress(this.getSuppress());
        event.setDriveNum(this.getDriveNum());
        event.setPoolName(this.getMediaPool());
        event.setIfaceName(this.getIfaceName());
        event.setDataMover(this.getDataMover());
        event.setType(new AllEventFlag(AllEventType.RESTORE));
        event.setObject(this.restoreTask);
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRestoreTask() {
        return this.restoreTask;
    }

    @Override
    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Override
    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Override
    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getSrvIfaceName() {
        return this.srvIfaceName;
    }

    @Generated
    public String getListmode() {
        return this.listmode;
    }

    @Generated
    public Boolean getAbsoluteFlag() {
        return this.absoluteFlag;
    }

    @Generated
    public Long getSavesetStart() {
        return this.savesetStart;
    }

    @Generated
    public Long getSavesetEnd() {
        return this.savesetEnd;
    }

    @Generated
    public MinMax getMinMax() {
        return this.minMax;
    }

    @Generated
    public RelativeDate getDateStart() {
        return this.dateStart;
    }

    @Generated
    public RelativeDate getDateEnd() {
        return this.dateEnd;
    }

    @Generated
    public Long getLifeTime() {
        return this.lifeTime;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public MigrationCfdiType getCfdiType() {
        return this.cfdiType;
    }

    @Generated
    public String getMediaPool() {
        return this.mediaPool;
    }

    @Generated
    public String getMediaTolerance() {
        return this.mediaTolerance;
    }

    @Generated
    public String getMediaPreference() {
        return this.mediaPreference;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public Long getDataMoverId() {
        return this.dataMoverId;
    }

    @Generated
    public String getUseSaveset() {
        return this.useSaveset;
    }

    @Generated
    public String getRestoreCmd() {
        return this.restoreCmd;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Override
    @Generated
    public Boolean getImmediateFlag() {
        return this.immediateFlag;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonDeserialize(as=Long.class)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRestoreTask(String restoreTask) {
        this.restoreTask = restoreTask;
    }

    @Override
    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Override
    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSrvIfaceName(String srvIfaceName) {
        this.srvIfaceName = srvIfaceName;
    }

    @Generated
    public void setListmode(String listmode) {
        this.listmode = listmode;
    }

    @Generated
    public void setAbsoluteFlag(Boolean absoluteFlag) {
        this.absoluteFlag = absoluteFlag;
    }

    @Generated
    public void setSavesetStart(Long savesetStart) {
        this.savesetStart = savesetStart;
    }

    @Generated
    public void setSavesetEnd(Long savesetEnd) {
        this.savesetEnd = savesetEnd;
    }

    @Generated
    public void setMinMax(MinMax minMax) {
        this.minMax = minMax;
    }

    @Generated
    public void setDateStart(RelativeDate dateStart) {
        this.dateStart = dateStart;
    }

    @Generated
    public void setDateEnd(RelativeDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    @JsonIgnore
    @Generated
    public void setLifeTime(Long lifeTime) {
        this.lifeTime = lifeTime;
    }

    @JsonIgnore
    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setCfdiType(MigrationCfdiType cfdiType) {
        this.cfdiType = cfdiType;
    }

    @Generated
    public void setMediaPool(String mediaPool) {
        this.mediaPool = mediaPool;
    }

    @Generated
    public void setMediaTolerance(String mediaTolerance) {
        this.mediaTolerance = mediaTolerance;
    }

    @Generated
    public void setMediaPreference(String mediaPreference) {
        this.mediaPreference = mediaPreference;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setDataMoverId(Long dataMoverId) {
        this.dataMoverId = dataMoverId;
    }

    @Generated
    public void setUseSaveset(String useSaveset) {
        this.useSaveset = useSaveset;
    }

    @Generated
    public void setRestoreCmd(String restoreCmd) {
        this.restoreCmd = restoreCmd;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Override
    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    @Generated
    public void setImmediateFlag(Boolean immediateFlag) {
        this.immediateFlag = immediateFlag;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public RestoreEvents() {
    }
}

