/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.annotations.SesamParameter;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.ReplicationGenericType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class ReplicationTypes
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
INamedEntity,
IDisplayLabelProvider {
    private static final long serialVersionUID = 4102718082127234426L;
    @JsonIgnore
    public static final String SEP_MIGRATION = "SEP Migration";
    @JsonIgnore
    public static final String SEP_SI3_REPLICATION = "SEP Si3 Replication";
    @JsonIgnore
    public static final String CATALYST_REPLICATION = "Catalyst Replication";
    @JsonIgnore
    public static final String NONE_SELECTED = "none_selected";
    @JsonIgnore
    private static final Comparator<ReplicationTypes> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=64)
    @Schema(description="The name of the replication type.", example="MyReplication")
    private @NotNull @Length(max=64) String name;
    @NotNull
    @Schema(description="The generic type of the replication.", example="STANDARD")
    private ReplicationGenericType genericType;
    @Length(max=64)
    @Schema(description="The vendor type of the replication.", example="VendorA")
    private @Length(max=64) String vendorType;
    @Length(max=1024)
    @SesamParameter(shortFields={"i"})
    @Schema(description="A description of the replication type.", example="Detailed description here")
    private @Length(max=1024) String description;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<ReplicationTypes> sorter() {
        return comparator;
    }

    public ReplicationTypes(String name) {
        this.name = name;
    }

    public final boolean isSepSI3Replication() {
        return StringUtils.startsWith(this.name, SEP_SI3_REPLICATION);
    }

    public final boolean isCatalystReplication() {
        return StringUtils.startsWith(this.name, CATALYST_REPLICATION);
    }

    public final boolean isAnyReplication() {
        return this.isSepSI3Replication() || this.isCatalystReplication();
    }

    public static final boolean isAnyReplication(String type) {
        return StringUtils.startsWith(type, SEP_SI3_REPLICATION) || StringUtils.startsWith(type, CATALYST_REPLICATION);
    }

    @Override
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ReplicationGenericType getGenericType() {
        return this.genericType;
    }

    @Generated
    public String getVendorType() {
        return this.vendorType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setGenericType(ReplicationGenericType genericType) {
        this.genericType = genericType;
    }

    @Generated
    public void setVendorType(String vendorType) {
        this.vendorType = vendorType;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public ReplicationTypes() {
    }
}

