/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class ProfilesKey
extends AbstractSerializableObject
implements INamedEntity {
    private static final long serialVersionUID = -8276309374650321310L;
    @JsonIgnore
    private static final Comparator<ProfilesKey> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="Name of the key for the profile", example="bbe")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String name;
    @Schema(description="State of the key", example="MigrationByStatus")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String node;
    @Schema(description="User name", example="bbe")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String userName;
    @Schema(description="This key is used to identify a specific action or setting.", example="show_toolbar_labels")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String key;

    @JsonIgnore
    public static Comparator<ProfilesKey> sorter() {
        return comparator;
    }

    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getNode() {
        return this.node;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNode(String node) {
        this.node = node;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public ProfilesKey() {
    }
}

