/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class PreferencesKey
extends AbstractSerializableObject {
    private static final long serialVersionUID = -5910931327640810690L;
    @JsonIgnore
    private static final Comparator<PreferencesKey> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getPrefKey() == null && o2 != null && o2.getPrefKey() == null) {
            return 0;
        }
        if (o1 == null || o1.getPrefKey() == null) {
            return -1;
        }
        if (o2 == null || o2.getPrefKey() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getPrefKey().compareToIgnoreCase(o2.getPrefKey()) : o1.getPrefKey().compareTo(o2.getPrefKey());
    };
    @Schema(description="The preferenc state", example="docking")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String prefNode;
    @Schema(description="The prefered user", example="root")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String prefUser;
    @Schema(description="The preference key", example="key123")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String prefKey;

    @JsonIgnore
    public static Comparator<PreferencesKey> sorter() {
        return comparator;
    }

    public String getDisplayLabel() {
        return this.prefKey;
    }

    @Generated
    public String getPrefNode() {
        return this.prefNode;
    }

    @Generated
    public String getPrefUser() {
        return this.prefUser;
    }

    @Generated
    public String getPrefKey() {
        return this.prefKey;
    }

    @Generated
    public void setPrefNode(String prefNode) {
        this.prefNode = prefNode;
    }

    @Generated
    public void setPrefUser(String prefUser) {
        this.prefUser = prefUser;
    }

    @Generated
    public void setPrefKey(String prefKey) {
        this.prefKey = prefKey;
    }

    @Generated
    public PreferencesKey() {
    }
}

