/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class PermissionRelations
extends AbstractModelEntity<Long>
implements ILongEntity,
MtimeEntity<Long> {
    @JsonIgnore
    private static final long serialVersionUID = 2616225933727362285L;
    @JsonIgnore
    private static final Comparator<PermissionRelations> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getPermissionId() == null && o2 != null && o2.getPermissionId() == null) {
            return 0;
        }
        if (o1 == null || o1.getPermissionId() == null) {
            return -1;
        }
        if (o2 == null || o2.getPermissionId() == null) {
            return 1;
        }
        return o1.getPermissionId().compareTo(o2.getPermissionId());
    };
    @Schema(description="The unique ID of the permission relation.", example="1")
    @NotNull
    private Long id;
    @Schema(description="The ID of the UI role.", example="101")
    @NotNull
    private Long roleId;
    @Schema(description="The ID of the UI permission.", example="102")
    @NotNull
    private Long permissionId;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;
    @Schema(description="The unique identifier (UUID) for the permission relation.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    @Length(max=40)
    private @Length(max=40) String uuid;

    @JsonIgnore
    public static Comparator<PermissionRelations> sorter() {
        return comparator;
    }

    public PermissionRelations(Long permissionID) {
        this.permissionId = permissionID;
    }

    @Override
    public Long getPK() {
        return this.id;
    }

    public String getDisplayLabel() {
        return this.uuid;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getRoleId() {
        return this.roleId;
    }

    @Generated
    public Long getPermissionId() {
        return this.permissionId;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    @Generated
    public void setPermissionId(Long permissionId) {
        this.permissionId = permissionId;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public PermissionRelations() {
    }
}

