/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Performance
extends AbstractModelEntity<Long>
implements IDisplayLabelProvider,
MtimeEntity<Long> {
    @JsonIgnore
    private static final long serialVersionUID = 2622263457782283583L;
    @JsonIgnore
    private static final Comparator<Performance> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @Schema(description="The unique ID of the performance.", example="1")
    @NotNull
    private Long id;
    @Schema(description="The timestamp of the performance.", example="2025-06-27T10:00:00Z")
    private Date time;
    @Schema(description="The ID of the performance object.", example="1")
    private Long perfObjectId;
    @Schema(description="The name of the performance object.", example="LTO-8")
    @Length(max=64)
    private @Length(max=64) String perfObject;
    @Schema(description="The type of the performance.", example="LTO-8")
    @Length(max=32)
    private @Length(max=32) String perfType;
    @Schema(description="The state of the performance.", example="RUNNING")
    @Length(max=32)
    private @Length(max=32) String state;
    @Schema(description="The throughput of the performance.", example="1000.0")
    private Double throughput;
    @Schema(description="The number of performed operations.", example="1000")
    private Long done;
    @Schema(description="The number of running operations.", example="100")
    private Long running;
    @Schema(description="The number of waiting operations.", example="10")
    private Long waiting;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<Performance> sorter() {
        return comparator;
    }

    public Performance(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.id == null ? "" : String.valueOf(this.id);
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Date getTime() {
        return this.time;
    }

    @Generated
    public Long getPerfObjectId() {
        return this.perfObjectId;
    }

    @Generated
    public String getPerfObject() {
        return this.perfObject;
    }

    @Generated
    public String getPerfType() {
        return this.perfType;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public Double getThroughput() {
        return this.throughput;
    }

    @Generated
    public Long getDone() {
        return this.done;
    }

    @Generated
    public Long getRunning() {
        return this.running;
    }

    @Generated
    public Long getWaiting() {
        return this.waiting;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTime(Date time) {
        this.time = time;
    }

    @Generated
    public void setPerfObjectId(Long perfObjectId) {
        this.perfObjectId = perfObjectId;
    }

    @Generated
    public void setPerfObject(String perfObject) {
        this.perfObject = perfObject;
    }

    @Generated
    public void setPerfType(String perfType) {
        this.perfType = perfType;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setThroughput(Double throughput) {
        this.throughput = throughput;
    }

    @Generated
    public void setDone(Long done) {
        this.done = done;
    }

    @Generated
    public void setRunning(Long running) {
        this.running = running;
    }

    @Generated
    public void setWaiting(Long waiting) {
        this.waiting = waiting;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Performance() {
    }
}

