/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.IListParameterHelpProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.OperatingSystemType;
import de.sep.sesam.model.type.LoginType;
import de.sep.sesam.model.type.ProxyType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class OperSystems
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
IDisplayLabelProvider,
IListParameterHelpProvider,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 7271240924176494177L;
    @JsonIgnore
    public static final String PLATFORM_HYPERVISOR = "HYPERVISOR";
    @JsonIgnore
    public static final String PLATFORM_LINUX = "LINUX";
    @JsonIgnore
    public static final String PLATFORM_NDMP = "NDMP";
    @JsonIgnore
    public static final String PLATFORM_NETWARE = "NETWARE";
    @JsonIgnore
    public static final String PLATFORM_STORAGE = "STORAGE";
    @JsonIgnore
    public static final String PLATFORM_UNIX = "UNIX";
    @JsonIgnore
    public static final String PLATFORM_VMS = "VMS";
    @JsonIgnore
    public static final String PLATFORM_WINDOWS = "WINDOWS";
    @JsonIgnore
    private static final Comparator<OperSystems> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=32)
    @Schema(description="The name of the operating system.", example="Windows")
    private @NotNull @Length(max=32) String name;
    @JsonIgnore
    private OperatingSystemType type;
    @NotNull
    @Length(max=20)
    @Schema(description="The platform identifier for the operating system.", example="WINDOWS")
    private @NotNull @Length(max=20) String platform;
    @Schema(description="The login type used for the operating system.", example="PASSWORD")
    private LoginType loginType;
    @Schema(description="The proxy type used for the operating system.", example="NONE")
    private ProxyType proxy;
    @Schema(description="The modification time of the operating system record from the database.", example="1720077461")
    private Date mtime;

    @JsonIgnore
    public static Comparator<OperSystems> sorter() {
        return comparator;
    }

    public OperSystems(String name) {
        this.name = name;
    }

    @JsonIgnore
    public static boolean canHostVirtualizationServer(String platform) {
        assert (StringUtils.isNotBlank(platform));
        return StringUtils.equals(platform, PLATFORM_LINUX) || StringUtils.equals(platform, PLATFORM_UNIX) || StringUtils.equals(platform, "VIRTUALIZATION") || StringUtils.equals(platform, PLATFORM_WINDOWS);
    }

    @JsonIgnore
    public static String getPreferredOS(String platform) {
        assert (StringUtils.isNotBlank(platform));
        String preferred = null;
        if (StringUtils.equals(platform, PLATFORM_NETWARE)) {
            preferred = "NetWare";
        } else if (StringUtils.equals(platform, PLATFORM_UNIX)) {
            preferred = PLATFORM_LINUX;
        } else if (StringUtils.equals(platform, PLATFORM_VMS)) {
            preferred = "VAX";
        } else if (StringUtils.equals(platform, PLATFORM_WINDOWS)) {
            preferred = "Windows Server 2022";
        } else if (StringUtils.equals(platform, PLATFORM_NDMP)) {
            preferred = "NETAPP";
        } else if (StringUtils.equals(platform, PLATFORM_LINUX)) {
            preferred = PLATFORM_LINUX;
        }
        return preferred;
    }

    @JsonIgnore
    public static OperSystems fromOsName(String os) {
        OperSystems operSystem = null;
        if (StringUtils.containsIgnoreCase(os, "AIX")) {
            operSystem = new OperSystems("AIX");
        } else if (StringUtils.containsIgnoreCase(os, "ALPHA")) {
            operSystem = new OperSystems("ALPHA");
        } else if (StringUtils.containsIgnoreCase(os, "BSD") && !StringUtils.equalsIgnoreCase(os, "FREEBSD")) {
            operSystem = new OperSystems("BSD");
        } else if (StringUtils.containsIgnoreCase(os, "Citrix")) {
            operSystem = new OperSystems("Citrix XenServer");
        } else if (StringUtils.containsIgnoreCase(os, "DEC")) {
            operSystem = new OperSystems("DEC-Unix");
        } else if (StringUtils.containsIgnoreCase(os, "Dell")) {
            operSystem = new OperSystems("Dell EMC Unity");
        } else if (StringUtils.containsIgnoreCase(os, "VNX")) {
            operSystem = new OperSystems("EMC VNX");
        } else if (StringUtils.containsIgnoreCase(os, "ESX")) {
            operSystem = new OperSystems("ESX-Server");
        } else if (StringUtils.containsIgnoreCase(os, "FREEBSD")) {
            operSystem = new OperSystems("FREEBSD");
        } else if (StringUtils.containsAnyIgnoreCase(os, "HPE", "Nimble")) {
            operSystem = new OperSystems("HPE Nimble Storage");
        } else if (StringUtils.containsIgnoreCase(os, "HPUX")) {
            operSystem = new OperSystems("HPUX");
        } else if (StringUtils.containsIgnoreCase(os, "HOME")) {
            operSystem = new OperSystems("Home Server");
        } else if (StringUtils.containsIgnoreCase(os, "IRIX")) {
            operSystem = new OperSystems("IRIX");
        } else if (StringUtils.containsAnyIgnoreCase(os, "Linux", "CentOS", "SUSE")) {
            operSystem = new OperSystems(PLATFORM_LINUX);
        } else if (StringUtils.containsIgnoreCase(os, "MAC")) {
            operSystem = new OperSystems("Mac OS X");
        } else if (StringUtils.containsIgnoreCase(os, "Marathon")) {
            operSystem = new OperSystems("Marathon everRun");
        } else if (StringUtils.equals(os, "NETAPP")) {
            operSystem = new OperSystems("NETAPP");
        } else if (StringUtils.equals(os, "NetApp")) {
            operSystem = new OperSystems("NetApp");
        } else if (StringUtils.containsIgnoreCase(os, "NetWare")) {
            operSystem = new OperSystems("NetWare");
        } else if (StringUtils.containsIgnoreCase(os, "OES")) {
            operSystem = new OperSystems("OES-Linux");
        } else if (StringUtils.containsIgnoreCase(os, "Oracle")) {
            operSystem = new OperSystems("Oracle ZFS");
        } else if (StringUtils.containsIgnoreCase(os, "SCO")) {
            operSystem = new OperSystems("SCO-UX");
        } else if (StringUtils.containsIgnoreCase(os, "SINIX")) {
            operSystem = new OperSystems("SINIX");
        } else if (StringUtils.containsIgnoreCase(os, "SOLARIS")) {
            operSystem = new OperSystems("SOLARIS");
        } else if (StringUtils.containsIgnoreCase(os, "SUN")) {
            operSystem = new OperSystems("SUN-UX");
        } else if (StringUtils.containsIgnoreCase(os, "Storage")) {
            operSystem = new OperSystems("Storage Server 2003");
        } else if (StringUtils.containsIgnoreCase(os, "Windows 10")) {
            operSystem = new OperSystems("Windows 10");
        } else if (StringUtils.containsIgnoreCase(os, "Windows 11")) {
            operSystem = new OperSystems("Windows 11");
        } else if (StringUtils.containsIgnoreCase(os, "Windows 2000")) {
            operSystem = new OperSystems("Windows 2000");
        } else if (StringUtils.containsIgnoreCase(os, "Windows 7")) {
            operSystem = new OperSystems("Windows 7");
        } else if (StringUtils.containsIgnoreCase(os, "Windows 8")) {
            operSystem = new OperSystems("Windows 8");
        } else if (StringUtils.containsIgnoreCase(os, "Windows 8.1")) {
            operSystem = new OperSystems("Windows 8.1");
        } else if (StringUtils.containsIgnoreCase(os, "Windows NT")) {
            operSystem = new OperSystems("Windows NT");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2003")) {
            operSystem = new OperSystems("Windows Server 2003");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2003 R2")) {
            operSystem = new OperSystems("Windows Server 2003 R2");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2008")) {
            operSystem = new OperSystems("Windows Server 2008");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2008 R2")) {
            operSystem = new OperSystems("Windows Server 2008 R2");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2012")) {
            operSystem = new OperSystems("Windows Server 2012");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2012 R2")) {
            operSystem = new OperSystems("Windows Server 2012 R2");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2016")) {
            operSystem = new OperSystems("Windows Server 2016");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2019")) {
            operSystem = new OperSystems("Windows Server 2019");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Server 2022")) {
            operSystem = new OperSystems("Windows Server 2022");
        } else if (StringUtils.containsIgnoreCase(os, "Windows Vista")) {
            operSystem = new OperSystems("Windows Vista");
        } else if (StringUtils.containsIgnoreCase(os, "Windows XP")) {
            operSystem = new OperSystems("Windows XP");
        }
        return operSystem;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @JsonIgnore
    public OperatingSystemType getType() {
        if (this.type == null) {
            this.type = OperatingSystemType.fromString(this.name);
        }
        return this.type;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    public String listHelpParam() {
        return "Valid values: [AIX|ALPHA|BSD|Citrix XenServer|DEC-Unix|Dell EMC Unity|EMC VNX|ESX-Server|FREEBSD|HPE Alletra Storage|HPE Nimble Storage|HPUX|Home Server|Huawei OceanStor|IRIX|LINUX|Mac OS X|Mac OS X Server|Marathon everRun|Microsoft Azure|NETAPP|NetApp|NetWare|Nutanix-AHV|OES-Linux|OceanStore OS|Oracle ZFS|PureStorage Array|SCO-UX|SINIX|SOLARIS|SUN-UX|Storage Server 2003|VMware vSphere|Windows 10|Windows 11|Windows 2000|Windows 7|Windows 8|Windows 8.1|Windows NT|Windows Server 2003|Windows Server 2003 R2|Windows Server 2008|Windows Server 2008 R2|Windows Server 2012|Windows Server 2012 R2|Windows Server 2016|Windows Server 2019|Windows Server 2022|Windows Server 2025|Windows Vista|Windows XP]";
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public LoginType getLoginType() {
        return this.loginType;
    }

    @Generated
    public ProxyType getProxy() {
        return this.proxy;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    @Generated
    public void setType(OperatingSystemType type) {
        this.type = type;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setLoginType(LoginType loginType) {
        this.loginType = loginType;
    }

    @Generated
    public void setProxy(ProxyType proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public OperSystems() {
    }
}

