/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.date.HumanDate;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.NotificationSeverity;
import de.sep.sesam.model.type.NotificationsAcknowledged;
import de.sep.sesam.model.type.NotificationsAction;
import de.sep.sesam.model.type.NotificationsModule;
import de.sep.sesam.model.type.NotificationsObjectType;
import de.sep.sesam.model.type.NotificationsType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Notifications
extends AbstractModelEntity<String>
implements IStringEntity,
MtimeEntity<String> {
    @JsonIgnore
    private static final long serialVersionUID = 6181865758153121999L;
    @JsonIgnore
    private static final Comparator<Notifications> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @JsonIgnore
    private static final Comparator<Notifications> comparatorTimestampDescending = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getTimestamp() == null && o2 != null && o2.getTimestamp() == null) {
            return 0;
        }
        if (o1 == null || o1.getTimestamp() == null) {
            return -1;
        }
        if (o2 == null || o2.getTimestamp() == null) {
            return 1;
        }
        return o1.getTimestamp().compareTo(o2.getTimestamp()) * -1;
    };
    @Schema(description="Unique identifier for the notification", example="not_123")
    private String id;
    @Schema(description="Module that generated the notification", example="BACKUP")
    @NotNull
    private NotificationsModule module;
    @Schema(description="SEP sesam date for the notification", example="2025-06-30", defaultValue="Start of current day")
    @NotNull
    private Date sesamDate = HumanDate.getStartOfDay(new Date());
    @Schema(description="Version constraint for the notification", example=">=4.4.3")
    private String versionConstraint;
    @Schema(description="SEP sesam version", example="5.0.0")
    private String sesamVersion;
    @Schema(description="Version number", example="5000")
    private Long versionNumber;
    @Schema(description="Timestamp when notification was created", example="2025-06-30T10:00:00Z", defaultValue="Current timestamp")
    @NotNull
    private Date timestamp = new Date();
    @Schema(description="Severity level of the notification", example="INFO", defaultValue="INFO")
    private NotificationSeverity severity = NotificationSeverity.INFO;
    @Schema(description="Type of object associated with notification", example="BACKUP_TASK")
    private NotificationsObjectType objectType;
    @Schema(description="Type of notification", example="WARNING")
    private NotificationsType type;
    @Schema(description="Associated object identifier", example="disaster_restore")
    @Length(max=64)
    private @Length(max=64) String object;
    @Schema(description="Hostname where notification was generated", example="backup-server-01")
    private String host;
    @Schema(description="Action associated with the notification", example="UNDEFINED", defaultValue="undefined")
    private NotificationsAction action = NotificationsAction.UNDEFINED;
    @Schema(description="Current state of the notification", example="A")
    @Length(max=1)
    private @Length(max=1) String state;
    @Schema(description="Acknowledgment status", example="ACKNOWLEDGED")
    private NotificationsAcknowledged acknowledged;
    @Schema(description="User who acknowledged the notification", example="admin")
    @Length(max=64)
    private @Length(max=64) String ackBy;
    @Schema(description="Date when notification was acknowledged", example="2025-06-30T10:00:00Z")
    private Date ackDate;
    @Schema(description="Comment added during acknowledgment", example="Issue resolved")
    @Length(max=4096)
    private @Length(max=4096) String ackUsercomment;
    @Schema(description="Date when the notification was resolved", example="2025-06-30T11:00:00Z")
    private Date resolvedDate;
    @Schema(description="User who resolved the notification", example="admin")
    @Length(max=64)
    private @Length(max=64) String resolvedBy;
    @Schema(description="Date for notification resubmission", example="2025-07-01T10:00:00Z")
    private Date resubmissionDate;
    @Schema(description="Process ID associated with the notification", example="12345")
    private Long pid;
    @Schema(description="Subject or message identifier", example="Backup Failed - Server 1")
    @Length(max=255)
    private @Length(max=255) String subject;
    @Schema(description="Detailed message content", example="Backup operation failed due to insufficient disk space")
    private String message;
    @Schema(description="User provided comment", example="Additional disk space requested")
    @Length(max=4096)
    private @Length(max=4096) String usercomment;
    @Schema(description="Last modification timestamp", example="2025-06-30T10:00:00Z")
    private Date mtime;

    @JsonIgnore
    public static Comparator<Notifications> sorter() {
        return comparator;
    }

    @JsonIgnore
    public static Comparator<Notifications> sorterTimestampDescending() {
        return comparatorTimestampDescending;
    }

    public Notifications(String id) {
        this.id = id;
    }

    public void setAction(NotificationsAction action) {
        this.action = action == null ? NotificationsAction.UNDEFINED : action;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.id;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public NotificationsModule getModule() {
        return this.module;
    }

    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public String getVersionConstraint() {
        return this.versionConstraint;
    }

    @Generated
    public String getSesamVersion() {
        return this.sesamVersion;
    }

    @Generated
    public Long getVersionNumber() {
        return this.versionNumber;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public NotificationSeverity getSeverity() {
        return this.severity;
    }

    @Generated
    public NotificationsObjectType getObjectType() {
        return this.objectType;
    }

    @Generated
    public NotificationsType getType() {
        return this.type;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public NotificationsAction getAction() {
        return this.action;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public NotificationsAcknowledged getAcknowledged() {
        return this.acknowledged;
    }

    @Generated
    public String getAckBy() {
        return this.ackBy;
    }

    @Generated
    public Date getAckDate() {
        return this.ackDate;
    }

    @Generated
    public String getAckUsercomment() {
        return this.ackUsercomment;
    }

    @Generated
    public Date getResolvedDate() {
        return this.resolvedDate;
    }

    @Generated
    public String getResolvedBy() {
        return this.resolvedBy;
    }

    @Generated
    public Date getResubmissionDate() {
        return this.resubmissionDate;
    }

    @Generated
    public Long getPid() {
        return this.pid;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setModule(NotificationsModule module) {
        this.module = module;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setVersionConstraint(String versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    @Generated
    public void setSesamVersion(String sesamVersion) {
        this.sesamVersion = sesamVersion;
    }

    @Generated
    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    @Generated
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setSeverity(NotificationSeverity severity) {
        this.severity = severity;
    }

    @Generated
    public void setObjectType(NotificationsObjectType objectType) {
        this.objectType = objectType;
    }

    @Generated
    public void setType(NotificationsType type) {
        this.type = type;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setAcknowledged(NotificationsAcknowledged acknowledged) {
        this.acknowledged = acknowledged;
    }

    @Generated
    public void setAckBy(String ackBy) {
        this.ackBy = ackBy;
    }

    @Generated
    public void setAckDate(Date ackDate) {
        this.ackDate = ackDate;
    }

    @Generated
    public void setAckUsercomment(String ackUsercomment) {
        this.ackUsercomment = ackUsercomment;
    }

    @Generated
    public void setResolvedDate(Date resolvedDate) {
        this.resolvedDate = resolvedDate;
    }

    @Generated
    public void setResolvedBy(String resolvedBy) {
        this.resolvedBy = resolvedBy;
    }

    @Generated
    public void setResubmissionDate(Date resubmissionDate) {
        this.resubmissionDate = resubmissionDate;
    }

    @Generated
    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Notifications() {
    }
}

