/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.sep.sesam.model.AllEvents;
import de.sep.sesam.model.core.AbstractEventsEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.runtime.interfaces.IAllEventsAdaptable;
import de.sep.sesam.model.type.AllEventFlag;
import de.sep.sesam.model.type.AllEventType;
import de.sep.sesam.model.type.SuppressFlags;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class NewdayEvents
extends AbstractEventsEntity
implements IDisplayLabelProvider,
IAllEventsAdaptable,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 7298768658143564194L;
    @JsonIgnore
    private static final Comparator<NewdayEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @Schema(description="Unique identifier for the newday event", example="1234")
    @NotNull
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(as=Long.class)
    private Long id;
    @Schema(description="Name of the newday event", example="Daily_Backup")
    @Length(max=255)
    private @Length(max=255) String name;
    @Schema(description="Object associated with the newday event", example="BACKUP")
    @NotNull
    @Length(max=50)
    private @NotNull @Length(max=50) String object;
    @Schema(description="Execution flag for the newday event", example="true")
    private Boolean exec;
    @Schema(description="End of life value for the newday event", example="30")
    private Long eol;
    @Schema(description="Name of the associated schedule", example="Weekly_Schedule")
    @Length(max=30)
    private @Length(max=30) String scheduleName;
    @Schema(description="Priority level of the newday event", example="1")
    private Long priority;
    @Schema(description="Suppress flag for the newday event", example="false")
    private Boolean suppress;
    @Schema(description="Additional options for the newday event", example="-force -quiet")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="Stop flags configuration", example="STOP_ON_ERROR")
    private SuppressFlags stopFlags;
    @Schema(description="Suppress flags configuration", example="SUPPRESS_WARNINGS")
    private SuppressFlags suppressFlags;
    @Schema(description="Follow-up actions or notes", example="Notify admin on completion", maxLength=1024)
    @Length(max=1024)
    private @Length(max=1024) String followUp;
    @Schema(description="Owner of the newday event", example="admin", maxLength=30, defaultValue="default user")
    @NotNull
    @Length(max=30)
    private @NotNull @Length(max=30) String owner = System.getProperty("user.name");
    @Schema(description="System comment", example="Auto-generated event")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="User provided comment", example="Custom backup configuration")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Visibility flag for the newday event", example="true")
    private Boolean visible;
    @Schema(description="Flag for immediate execution", example="false", defaultValue="false")
    private Boolean immediateFlag = false;
    @Schema(description="Last modification timestamp", example="2025-06-30T10:00:00Z")
    private Date mtime;

    @JsonIgnore
    public static Comparator<NewdayEvents> sorter() {
        return comparator;
    }

    public NewdayEvents(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getObjectLabel() {
        return StringUtils.isNotBlank(this.object) ? this.object : "";
    }

    @Override
    @JsonIgnore
    public void fill(AllEvents event) {
        assert (event != null);
        event.setExec(this.getExec());
        event.setEol(this.getEol());
        event.setFollowUp(this.getFollowUp());
        event.setId(this.getId());
        event.setImmediateFlag(this.getImmediateFlag());
        event.setName(this.getName());
        event.setOwner(this.getOwner());
        event.setPriority(this.getPriority());
        event.setSuppress(this.getSuppress());
        event.setType(new AllEventFlag(AllEventType.NEWDAY));
        event.setObject(this.object);
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Override
    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Override
    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Override
    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public SuppressFlags getStopFlags() {
        return this.stopFlags;
    }

    @Generated
    public SuppressFlags getSuppressFlags() {
        return this.suppressFlags;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Override
    @Generated
    public Boolean getImmediateFlag() {
        return this.immediateFlag;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonDeserialize(as=Long.class)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Override
    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Override
    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setStopFlags(SuppressFlags stopFlags) {
        this.stopFlags = stopFlags;
    }

    @Generated
    public void setSuppressFlags(SuppressFlags suppressFlags) {
        this.suppressFlags = suppressFlags;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Override
    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    @Generated
    public void setImmediateFlag(Boolean immediateFlag) {
        this.immediateFlag = immediateFlag;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public NewdayEvents() {
    }
}

