/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import de.sep.sesam.model.ReplicationTypes;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.MigrationCfdiType;
import de.sep.sesam.model.type.RelativeDate;
import de.sep.sesam.model.type.StateType;
import de.sep.sesam.model.utils.ModelUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;

public class MigrationTasks
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 5794077708248425594L;
    @JsonIgnore
    public static final int MAX_NAME_LENGTH = 49;
    @JsonIgnore
    public static final String DEFAULT_TASK_NAME_TEMPLATE = "Mig-{{source_pool}}_{{target_pool}}";
    @JsonIgnore
    private static final Comparator<MigrationTasks> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="Name of the migration task", example="migration_task_1", maxLength=64)
    @NotNull
    @Length(max=49)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    private @NotNull @Length(max=49) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @Schema(description="Type of replication to be performed", example="SEP_MIGRATION", defaultValue="SEP_MIGRATION")
    @JsonIncludeProperties(value={"name"})
    private ReplicationTypes replicationType = new ReplicationTypes("SEP Migration");
    @Schema(description="Name of the source media pool", example="source_pool_1", maxLength=32)
    @NotNull
    @Length(max=32)
    private @NotNull @Length(max=32) String sourcePool;
    @Schema(description="Name of the target media pool", example="target_pool_1", maxLength=32)
    @NotNull
    @Length(max=32)
    private @NotNull @Length(max=32) String targetPool;
    @Schema(description="ID of the source drive", example="1")
    private Long sourceDrive;
    @Schema(description="Name of the source drive", example="tape_drive_1")
    private String sourceDriveName;
    @Schema(description="ID of the target drive", example="2")
    private Long targetDrive;
    @Schema(description="Name of the target drive", example="tape_drive_2")
    private String targetDriveName;
    @Schema(description="SEP sesam date of the migration task", example="2025-06-30T10:00:00Z")
    private Date sesamDate;
    @Schema(description="Number of savesets to be processed", example="5")
    private Long savesetCnt;
    @Schema(description="Start date for the migration task", example="-7d")
    private RelativeDate dateStart;
    @Schema(description="End date for the migration task", example="now")
    private RelativeDate dateEnd;
    @Schema(description="Flag indicating if absolute dates should be used", example="true")
    private Boolean absoluteFlag;
    @Schema(description="Saveset identifier", example="saveset_123", maxLength=64)
    @Length(max=64)
    private @Length(max=64) String saveset;
    @Schema(description="Flag indicating if this is a group task", example="false")
    private Boolean grpflag;
    @Schema(description="Name of the associated task", example="backup_task_1", maxLength=64)
    @Length(max=64)
    private @Length(max=64) String task;
    @Schema(description="Name of the associated task group", example="backup_group_1", maxLength=64)
    @Length(max=64)
    private @Length(max=64) String taskGroup;
    @Schema(description="Current state of the backup", example="COMPLETED")
    private StateType backupState;
    @Schema(description="Type of CFDI for migration", example="CFDI", defaultValue="CFDI")
    private MigrationCfdiType cfdiType = MigrationCfdiType.fromString("CFDI");
    @Schema(description="Media label", example="TAPE001", maxLength=30)
    @Length(max=30)
    private @Length(max=30) String mediaLabel;
    @Schema(description="Generation mode flag", example="true")
    private Boolean genmode;
    @Schema(description="Delete flag status", example="Y")
    private String deleteFlag;
    @Schema(description="Flag indicating if the task has been migrated", example="true")
    private Boolean migratedFlag;
    @Schema(description="Flag indicating if this is an original task", example="true")
    private Boolean original;
    @Schema(description="Client name", example="client1")
    private String client;
    @Schema(description="Interface name", example="interface1")
    private String ifaceName;
    @Schema(description="Source interface name", example="source_interface1")
    private String sourceIfaceName;
    @Schema(description="Filter criteria", example="*.txt", maxLength=255)
    @Length(max=255)
    private @Length(max=255) String filter;
    @Schema(description="Flag indicating if the task has been submitted", example="true")
    private Boolean submitFlag;
    @Schema(description="Timestamp when the task was created", example="2025-06-30T10:00:00Z")
    private Date makeStamp;
    @Schema(description="End of life value", example="30")
    private Long eol;
    @Schema(description="Migration command", example="migrate_data", maxLength=64)
    @Length(max=64)
    private @Length(max=64) String migrationCmd;
    @Schema(description="Additional options for the migration", example="-verbose -force", maxLength=255)
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="System comment", example="Migration completed successfully", maxLength=1024)
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="User provided comment", example="Critical data migration", maxLength=1024)
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Generated status value", example="1")
    private Long generated;
    @Schema(description="Last modification timestamp", example="2025-06-30T10:00:00Z")
    private Date mtime;

    @JsonIgnore
    public static Comparator<MigrationTasks> sorter() {
        return comparator;
    }

    public MigrationTasks(String name) {
        this.name = name;
    }

    public MigrationTasks(MigrationTasks original) {
        assert (original != null);
        ModelUtils.copyProperties(this, original);
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.getName();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ReplicationTypes getReplicationType() {
        return this.replicationType;
    }

    @Generated
    public String getSourcePool() {
        return this.sourcePool;
    }

    @Generated
    public String getTargetPool() {
        return this.targetPool;
    }

    @Generated
    public Long getSourceDrive() {
        return this.sourceDrive;
    }

    @Generated
    public String getSourceDriveName() {
        return this.sourceDriveName;
    }

    @Generated
    public Long getTargetDrive() {
        return this.targetDrive;
    }

    @Generated
    public String getTargetDriveName() {
        return this.targetDriveName;
    }

    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public Long getSavesetCnt() {
        return this.savesetCnt;
    }

    @Generated
    public RelativeDate getDateStart() {
        return this.dateStart;
    }

    @Generated
    public RelativeDate getDateEnd() {
        return this.dateEnd;
    }

    @Generated
    public Boolean getAbsoluteFlag() {
        return this.absoluteFlag;
    }

    @Generated
    public String getSaveset() {
        return this.saveset;
    }

    @Generated
    public Boolean getGrpflag() {
        return this.grpflag;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Generated
    public String getTaskGroup() {
        return this.taskGroup;
    }

    @Generated
    public StateType getBackupState() {
        return this.backupState;
    }

    @Generated
    public MigrationCfdiType getCfdiType() {
        return this.cfdiType;
    }

    @Generated
    public String getMediaLabel() {
        return this.mediaLabel;
    }

    @Generated
    public Boolean getGenmode() {
        return this.genmode;
    }

    @Generated
    public String getDeleteFlag() {
        return this.deleteFlag;
    }

    @Generated
    public Boolean getMigratedFlag() {
        return this.migratedFlag;
    }

    @Generated
    public Boolean getOriginal() {
        return this.original;
    }

    @Generated
    public String getClient() {
        return this.client;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getSourceIfaceName() {
        return this.sourceIfaceName;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public Boolean getSubmitFlag() {
        return this.submitFlag;
    }

    @Generated
    public Date getMakeStamp() {
        return this.makeStamp;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Generated
    public String getMigrationCmd() {
        return this.migrationCmd;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Long getGenerated() {
        return this.generated;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setReplicationType(ReplicationTypes replicationType) {
        this.replicationType = replicationType;
    }

    @Generated
    public void setSourcePool(String sourcePool) {
        this.sourcePool = sourcePool;
    }

    @Generated
    public void setTargetPool(String targetPool) {
        this.targetPool = targetPool;
    }

    @Generated
    public void setSourceDrive(Long sourceDrive) {
        this.sourceDrive = sourceDrive;
    }

    @Generated
    public void setSourceDriveName(String sourceDriveName) {
        this.sourceDriveName = sourceDriveName;
    }

    @Generated
    public void setTargetDrive(Long targetDrive) {
        this.targetDrive = targetDrive;
    }

    @Generated
    public void setTargetDriveName(String targetDriveName) {
        this.targetDriveName = targetDriveName;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setSavesetCnt(Long savesetCnt) {
        this.savesetCnt = savesetCnt;
    }

    @Generated
    public void setDateStart(RelativeDate dateStart) {
        this.dateStart = dateStart;
    }

    @Generated
    public void setDateEnd(RelativeDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    @Generated
    public void setAbsoluteFlag(Boolean absoluteFlag) {
        this.absoluteFlag = absoluteFlag;
    }

    @Generated
    public void setSaveset(String saveset) {
        this.saveset = saveset;
    }

    @Generated
    public void setGrpflag(Boolean grpflag) {
        this.grpflag = grpflag;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setTaskGroup(String taskGroup) {
        this.taskGroup = taskGroup;
    }

    @Generated
    public void setBackupState(StateType backupState) {
        this.backupState = backupState;
    }

    @Generated
    public void setCfdiType(MigrationCfdiType cfdiType) {
        this.cfdiType = cfdiType;
    }

    @Generated
    public void setMediaLabel(String mediaLabel) {
        this.mediaLabel = mediaLabel;
    }

    @Generated
    public void setGenmode(Boolean genmode) {
        this.genmode = genmode;
    }

    @Generated
    public void setDeleteFlag(String deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    @Generated
    public void setMigratedFlag(Boolean migratedFlag) {
        this.migratedFlag = migratedFlag;
    }

    @Generated
    public void setOriginal(Boolean original) {
        this.original = original;
    }

    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSourceIfaceName(String sourceIfaceName) {
        this.sourceIfaceName = sourceIfaceName;
    }

    @Generated
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Generated
    public void setSubmitFlag(Boolean submitFlag) {
        this.submitFlag = submitFlag;
    }

    @Generated
    public void setMakeStamp(Date makeStamp) {
        this.makeStamp = makeStamp;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Generated
    public void setMigrationCmd(String migrationCmd) {
        this.migrationCmd = migrationCmd;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setGenerated(Long generated) {
        this.generated = generated;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public MigrationTasks() {
    }
}

