/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.runtime.interfaces.IResultsModel;
import de.sep.sesam.model.type.CfdiType;
import de.sep.sesam.model.type.RelativeDate;
import de.sep.sesam.model.type.StateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class MigrationResults
extends AbstractModelEntity<String>
implements IResultsModel<String>,
IStringEntity,
INamedEntity {
    private static final long serialVersionUID = -4946056219456139016L;
    @JsonIgnore
    private static final Comparator<MigrationResults> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="Unique identifier of the migration result.", example="MIG_20250627_001")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String name;
    @Schema(description="Name of the client system.", example="client01.example.com")
    @Length(max=255)
    private @Length(max=255) String client;
    @Schema(description="Unique identifier of the client.", example="1001")
    private Long clientId;
    @Schema(description="Duration of the migration in seconds.", example="3600")
    private Long duration;
    @Schema(description="End of life date for the migration result.", example="2026-06-27T10:00:00Z")
    private Date eol;
    @Schema(description="External identifier for the migration.", example="EXT_001")
    private String externalId;
    @Schema(description="Name of the interface used.", example="eth0")
    private String ifaceName;
    @Schema(description="System comment about the migration.", example="Migration completed successfully")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="Process ID of the migration.", example="12345")
    private Long pid;
    @Schema(description="Priority level of the migration.", example="1")
    private Long priority;
    @Schema(description="ID of the associated backup.", example="BACKUP_20250627_001")
    @Length(max=64)
    private @Length(max=64) String backupId;
    @Schema(description="Name of the saveset.", example="DAILY_BACKUP_001")
    @Length(max=64)
    private @Length(max=64) String saveset;
    @Schema(description="Name of the schedule used.", example="Weekly_Migration")
    @Length(max=30)
    private @Length(max=30) String schedule;
    @Schema(description="SEP sesam date of the migration.", example="2025-06-27T10:00:00Z")
    private Date sesamDate;
    @Schema(description="Version of SEP sesam used.", example="5.0.0")
    @Length(max=64)
    private @Length(max=64) String sesamVersion;
    @Schema(description="ID of the session.", example="SESSION_001")
    @Length(max=64)
    private @Length(max=64) String sessionId;
    @Schema(description="Size of migrated data in bytes.", example="1073741824")
    private Long size;
    @Schema(description="SSDD flag status.", example="true")
    private Boolean ssddFlag;
    @Schema(description="Progress of migration as percentage.", example="75.5")
    private Double progress;
    @Schema(description="Start time of the migration.", example="2025-06-27T10:00:00Z")
    private Date startTime;
    @Schema(description="Start time of the SBC process.", example="2025-06-27T10:00:00Z")
    private Date sbcStart;
    @Schema(description="Current state of the migration.", example="COMPLETED")
    @NotNull
    private StateType state;
    @Schema(description="Stop time of the migration.", example="2025-06-27T11:00:00Z")
    private Date stopTime;
    @Schema(description="Termination time of the migration.", example="2025-06-27T11:00:00Z")
    private Date terminationTime;
    @Schema(description="Data throughput in bytes per second.", example="104857600")
    private Double throughput;
    @Schema(description="User provided comment about the migration.", example="Monthly archive migration")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Username who initiated the migration.", example="admin")
    @Length(max=255)
    private @Length(max=255) String userName;
    @Schema(description="Name of the migration task.", example="Archive_Migration")
    @NotNull
    @Length(max=49)
    private @NotNull @Length(max=49) String migrationTask;
    @Schema(description="Type of replication used.", example="FULL")
    @Length(max=80)
    private @Length(max=80) String replicationType;
    @Schema(description="Start time of data transfer.", example="2025-06-27T10:00:00Z")
    private Date transferStart;
    @Schema(description="Name of the source media pool.", example="SOURCE_POOL_1")
    @Length(max=32)
    private @Length(max=32) String sourcePool;
    @Schema(description="Name of the target media pool.", example="TARGET_POOL_1")
    @Length(max=32)
    private @Length(max=32) String targetPool;
    @Schema(description="Number of the source drive.", example="1")
    private Long sourceDrive;
    @Schema(description="Name of the source drive.", example="DRIVE_1")
    private String sourceDriveName;
    @Schema(description="Number of the target drive.", example="2")
    private Long targetDrive;
    @Schema(description="Name of the target drive.", example="DRIVE_2")
    private String targetDriveName;
    @Schema(description="Start date of the migration period.", example="2025-06-01")
    private RelativeDate fromDate;
    @Schema(description="End date of the migration period.", example="2025-06-27")
    private RelativeDate toDate;
    @Schema(description="Name of the target saveset.", example="TARGET_BACKUP_001")
    @Length(max=64)
    private @Length(max=64) String targetSavesetName;
    @Schema(description="Flag indicating if this is a group migration.", example="false")
    private Boolean grpflag;
    @Schema(description="Name of the associated task.", example="MIGRATION_TASK_1")
    @Length(max=50)
    private @Length(max=50) String taskName;
    @Schema(description="Date of the saveset.", example="2025-06-27T10:00:00Z")
    private Date savesetDate;
    @Schema(description="Flag indicating if migration is complete.", example="true")
    private Boolean migratedFlag;
    @Schema(description="Count of savesets processed.", example="5")
    private Long savesetCnt;
    @Schema(description="State of the associated backup.", example="COMPLETED")
    private StateType backupState;
    @Schema(description="Type of CFDI used.", example="FULL")
    private CfdiType cfdiType;
    @Schema(description="Label of the media.", example="TAPE001")
    @Length(max=30)
    private @Length(max=30) String mediaLabel;
    @Schema(description="Filter criteria used for migration.", example="*.bak")
    @Length(max=255)
    private @Length(max=255) String filter;
    @Schema(description="Additional options used for migration.", example="VERIFY=true")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="Flag indicating if generic mode was used.", example="false")
    private Boolean genmode;
    @Schema(description="Mode of listing used.", example="DETAILED")
    @Length(max=32)
    private @Length(max=32) String listmode;
    @Schema(description="Flag indicating if this is a subtask.", example="false")
    private Boolean subtaskFlag;
    @Schema(description="Name of the parent task.", example="PARENT_TASK_1")
    private String parent;
    @Schema(description="Amount of data transferred in bytes.", example="1073741824")
    private Long transferred;
    @Schema(description="Gross amount of data transferred in bytes.", example="1073741824")
    private Long transferredBrutto;
    @Schema(description="Speed-up factor achieved.", example="1.5")
    private Double speedup;
    @Schema(description="Migration command executed.", example="MIGRATE_ALL")
    @Length(max=64)
    private @Length(max=64) String migrationCmd;
    @JsonIgnore
    private String originServer;
    @Schema(description="Unique identifier of the migration result.", example="550e8400-e29b-41d4-a716-446655440000")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @Schema(description="Last modification timestamp.", example="2025-06-27T10:00:00Z")
    private Date mtime;
    @Schema(description="Type of reference.", example="BACKUP")
    private String referenceType;
    @Schema(description="ID of the reference.", example="REF_001")
    private String referenceId;
    @Schema(description="Total count of savesets.", example="10")
    private Long totalSavesetCount;

    @JsonIgnore
    public static Comparator<MigrationResults> sorter() {
        return comparator;
    }

    public MigrationResults(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getClient() {
        return this.client;
    }

    @Override
    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public Long getPid() {
        return this.pid;
    }

    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public String getBackupId() {
        return this.backupId;
    }

    @Generated
    public String getSaveset() {
        return this.saveset;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public String getSesamVersion() {
        return this.sesamVersion;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public Boolean getSsddFlag() {
        return this.ssddFlag;
    }

    @Generated
    public Double getProgress() {
        return this.progress;
    }

    @Override
    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getSbcStart() {
        return this.sbcStart;
    }

    @Generated
    public StateType getState() {
        return this.state;
    }

    @Generated
    public Date getStopTime() {
        return this.stopTime;
    }

    @Generated
    public Date getTerminationTime() {
        return this.terminationTime;
    }

    @Generated
    public Double getThroughput() {
        return this.throughput;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getMigrationTask() {
        return this.migrationTask;
    }

    @Generated
    public String getReplicationType() {
        return this.replicationType;
    }

    @Generated
    public Date getTransferStart() {
        return this.transferStart;
    }

    @Generated
    public String getSourcePool() {
        return this.sourcePool;
    }

    @Generated
    public String getTargetPool() {
        return this.targetPool;
    }

    @Generated
    public Long getSourceDrive() {
        return this.sourceDrive;
    }

    @Generated
    public String getSourceDriveName() {
        return this.sourceDriveName;
    }

    @Generated
    public Long getTargetDrive() {
        return this.targetDrive;
    }

    @Generated
    public String getTargetDriveName() {
        return this.targetDriveName;
    }

    @Generated
    public RelativeDate getFromDate() {
        return this.fromDate;
    }

    @Generated
    public RelativeDate getToDate() {
        return this.toDate;
    }

    @Generated
    public String getTargetSavesetName() {
        return this.targetSavesetName;
    }

    @Generated
    public Boolean getGrpflag() {
        return this.grpflag;
    }

    @Generated
    public String getTaskName() {
        return this.taskName;
    }

    @Generated
    public Date getSavesetDate() {
        return this.savesetDate;
    }

    @Generated
    public Boolean getMigratedFlag() {
        return this.migratedFlag;
    }

    @Generated
    public Long getSavesetCnt() {
        return this.savesetCnt;
    }

    @Generated
    public StateType getBackupState() {
        return this.backupState;
    }

    @Generated
    public CfdiType getCfdiType() {
        return this.cfdiType;
    }

    @Generated
    public String getMediaLabel() {
        return this.mediaLabel;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public Boolean getGenmode() {
        return this.genmode;
    }

    @Generated
    public String getListmode() {
        return this.listmode;
    }

    @Generated
    public Boolean getSubtaskFlag() {
        return this.subtaskFlag;
    }

    @Generated
    public String getParent() {
        return this.parent;
    }

    @Generated
    public Long getTransferred() {
        return this.transferred;
    }

    @Generated
    public Long getTransferredBrutto() {
        return this.transferredBrutto;
    }

    @Generated
    public Double getSpeedup() {
        return this.speedup;
    }

    @Generated
    public String getMigrationCmd() {
        return this.migrationCmd;
    }

    @Override
    @Generated
    public String getOriginServer() {
        return this.originServer;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public Long getTotalSavesetCount() {
        return this.totalSavesetCount;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Override
    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    @Generated
    public void setSaveset(String saveset) {
        this.saveset = saveset;
    }

    @Generated
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setSesamVersion(String sesamVersion) {
        this.sesamVersion = sesamVersion;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setSsddFlag(Boolean ssddFlag) {
        this.ssddFlag = ssddFlag;
    }

    @Generated
    public void setProgress(Double progress) {
        this.progress = progress;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setSbcStart(Date sbcStart) {
        this.sbcStart = sbcStart;
    }

    @Generated
    public void setState(StateType state) {
        this.state = state;
    }

    @Generated
    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    @Generated
    public void setTerminationTime(Date terminationTime) {
        this.terminationTime = terminationTime;
    }

    @Generated
    public void setThroughput(Double throughput) {
        this.throughput = throughput;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setMigrationTask(String migrationTask) {
        this.migrationTask = migrationTask;
    }

    @Generated
    public void setReplicationType(String replicationType) {
        this.replicationType = replicationType;
    }

    @Generated
    public void setTransferStart(Date transferStart) {
        this.transferStart = transferStart;
    }

    @Generated
    public void setSourcePool(String sourcePool) {
        this.sourcePool = sourcePool;
    }

    @Generated
    public void setTargetPool(String targetPool) {
        this.targetPool = targetPool;
    }

    @Generated
    public void setSourceDrive(Long sourceDrive) {
        this.sourceDrive = sourceDrive;
    }

    @Generated
    public void setSourceDriveName(String sourceDriveName) {
        this.sourceDriveName = sourceDriveName;
    }

    @Generated
    public void setTargetDrive(Long targetDrive) {
        this.targetDrive = targetDrive;
    }

    @Generated
    public void setTargetDriveName(String targetDriveName) {
        this.targetDriveName = targetDriveName;
    }

    @Generated
    public void setFromDate(RelativeDate fromDate) {
        this.fromDate = fromDate;
    }

    @Generated
    public void setToDate(RelativeDate toDate) {
        this.toDate = toDate;
    }

    @Generated
    public void setTargetSavesetName(String targetSavesetName) {
        this.targetSavesetName = targetSavesetName;
    }

    @Generated
    public void setGrpflag(Boolean grpflag) {
        this.grpflag = grpflag;
    }

    @Generated
    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    @Generated
    public void setSavesetDate(Date savesetDate) {
        this.savesetDate = savesetDate;
    }

    @Generated
    public void setMigratedFlag(Boolean migratedFlag) {
        this.migratedFlag = migratedFlag;
    }

    @Generated
    public void setSavesetCnt(Long savesetCnt) {
        this.savesetCnt = savesetCnt;
    }

    @Generated
    public void setBackupState(StateType backupState) {
        this.backupState = backupState;
    }

    @Generated
    public void setCfdiType(CfdiType cfdiType) {
        this.cfdiType = cfdiType;
    }

    @Generated
    public void setMediaLabel(String mediaLabel) {
        this.mediaLabel = mediaLabel;
    }

    @Generated
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setGenmode(Boolean genmode) {
        this.genmode = genmode;
    }

    @Generated
    public void setListmode(String listmode) {
        this.listmode = listmode;
    }

    @Generated
    public void setSubtaskFlag(Boolean subtaskFlag) {
        this.subtaskFlag = subtaskFlag;
    }

    @Generated
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Generated
    public void setTransferred(Long transferred) {
        this.transferred = transferred;
    }

    @Generated
    public void setTransferredBrutto(Long transferredBrutto) {
        this.transferredBrutto = transferredBrutto;
    }

    @Generated
    public void setSpeedup(Double speedup) {
        this.speedup = speedup;
    }

    @Generated
    public void setMigrationCmd(String migrationCmd) {
        this.migrationCmd = migrationCmd;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setTotalSavesetCount(Long totalSavesetCount) {
        this.totalSavesetCount = totalSavesetCount;
    }

    @Generated
    public MigrationResults() {
    }
}

