/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.sep.sesam.model.AllEvents;
import de.sep.sesam.model.core.AbstractEventsEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.runtime.interfaces.IAllEventsAdaptable;
import de.sep.sesam.model.type.AllEventFlag;
import de.sep.sesam.model.type.AllEventType;
import de.sep.sesam.model.type.MigrationCfdiType;
import de.sep.sesam.model.type.ReferenceType;
import de.sep.sesam.model.type.RelativeDate;
import de.sep.sesam.model.type.StateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class MigrationEvents
extends AbstractEventsEntity
implements IDisplayLabelProvider,
IAllEventsAdaptable,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 6541062622568595036L;
    @JsonIgnore
    private static final Comparator<MigrationEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(as=Long.class)
    private Long id;
    @Schema(description="Name of the migration event.", example="Weekly_Migration")
    @Length(max=255)
    private @Length(max=255) String name;
    @Schema(description="Name of the migration task.", example="Archive_Migration_Task")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String migrationTask;
    @Schema(description="Flag indicating if the event is executable.", example="true")
    private Boolean exec;
    @Schema(description="End of life period in days.", example="365")
    private Long eol;
    @Schema(description="Name of the schedule for this event.", example="Weekly_Friday")
    @Length(max=30)
    private @Length(max=30) String scheduleName;
    @Schema(description="Follow-up action or command.", example="/scripts/post_migration.sh")
    @Length(max=1024)
    private @Length(max=1024) String followUp;
    @Schema(description="Priority level of the event.", example="1")
    private Long priority;
    @Schema(description="Flag indicating if the event is suppressed.", example="false")
    private Boolean suppress;
    @Schema(description="Owner of the event.", example="admin")
    @Length(max=30)
    private @Length(max=30) String owner;
    @Schema(description="Name of the saveset.", example="Daily_Backup_Set")
    @Length(max=64)
    private @Length(max=64) String saveset;
    @Schema(description="Flag indicating if this is a group event.", example="false")
    private Boolean grpflag;
    @Schema(description="Name of the task.", example="Migration_Task_1")
    @Length(max=64)
    private @Length(max=64) String task;
    @Schema(description="Name of the task group.", example="Archive_Tasks")
    @Length(max=64)
    private @Length(max=64) String taskGroup;
    @Schema(description="Count of savesets.", example="5")
    private Long savesetCnt;
    @Schema(description="Target drive number.", example="1")
    private Long targetDrive;
    @Schema(description="Name of the target media pool.", example="Archive_Pool")
    @NotNull
    @Length(max=16)
    private @NotNull @Length(max=16) String targetPool;
    @Schema(description="Interface name.", example="eth0")
    @Length(max=255)
    private @Length(max=255) String ifaceName;
    @Schema(description="Server interface name.", example="srv_eth0")
    @Length(max=255)
    private @Length(max=255) String srvIfaceName;
    @Schema(description="Flag indicating if migration is completed.", example="true")
    private Boolean migratedFlag;
    @Schema(description="Flag for absolute date usage.", example="false")
    private Boolean absoluteFlag;
    @Schema(description="Flag indicating deletion status.", example="Y")
    private String deleteFlag;
    @Schema(description="Start date for the migration.", example="2025-06-27")
    private RelativeDate dateStart;
    @Schema(description="End date for the migration.", example="2025-07-27")
    private RelativeDate dateEnd;
    @Schema(description="Type of migration CFDI.", example="FULL")
    private MigrationCfdiType cfdiType;
    @Schema(description="Current state of the migration.", example="RUNNING")
    private StateType state;
    @Schema(description="Label of the media.", example="TAPE001")
    @Length(max=30)
    private @Length(max=30) String mediaLabel;
    @Schema(description="Name of the client.", example="client01.example.com")
    @Length(max=255)
    private @Length(max=255) String client;
    @Schema(description="ID of the client.", example="1001")
    private Long clientId;
    @Schema(description="Mode of listing.", example="DETAILED")
    @Length(max=32)
    private @Length(max=32) String listmode;
    @Schema(description="Flag indicating if event is submitted.", example="true")
    private Boolean submitFlag;
    @Schema(description="Additional options for the migration.", example="VERIFY=true")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="Flag indicating if event is visible in UI.", example="true")
    private Boolean visible;
    @Schema(description="Name of the data mover.", example="DataMover_1")
    @Length(max=255)
    private @Length(max=255) String dataMover;
    @Schema(description="ID of the data mover.", example="1")
    private Long dataMoverId;
    @Schema(description="Migration command to execute.", example="MIGRATE_ALL")
    @Length(max=64)
    private @Length(max=64) String migrationCmd;
    @Schema(description="Type of reference.", example="BACKUP")
    private ReferenceType referenceType;
    @Schema(description="ID of the reference.", example="ref123")
    @Length(max=80)
    private @Length(max=80) String referenceId;
    @Schema(description="Unique identifier for the migration.", example="mig123")
    @Length(max=80)
    private @Length(max=80) String migrationId;
    @Schema(description="User provided comment about the migration.", example="Monthly archive migration")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Flag indicating if migration should start immediately.", example="false")
    private Boolean immediateFlag;
    @Schema(description="Flag to overwrite event with task data.", example="false")
    private Boolean overwriteWithMigrationTask;
    @Schema(description="Timestamp of last modification.", example="2025-06-27T10:00:00Z")
    private Date mtime;

    @JsonIgnore
    public static Comparator<MigrationEvents> sorter() {
        return comparator;
    }

    public MigrationEvents(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getObjectLabel() {
        return StringUtils.isNotBlank(this.migrationTask) ? this.migrationTask : "";
    }

    @Override
    @JsonIgnore
    public void fill(AllEvents event) {
        assert (event != null);
        event.setExec(this.getExec());
        event.setEol(this.getEol());
        event.setFollowUp(this.getFollowUp());
        event.setId(this.getId());
        event.setImmediateFlag(this.getImmediateFlag());
        event.setName(this.getName());
        event.setOwner(this.getOwner());
        event.setPriority(this.getPriority());
        event.setSuppress(this.getSuppress());
        event.setDriveNum(this.getTargetDrive());
        event.setPoolName(this.getTargetPool());
        event.setIfaceName(this.getIfaceName());
        event.setDataMover(this.getDataMover());
        event.setType(new AllEventFlag(AllEventType.MIGRATION));
        event.setObject(this.migrationTask);
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMigrationTask() {
        return this.migrationTask;
    }

    @Override
    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Override
    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Override
    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getSaveset() {
        return this.saveset;
    }

    @Generated
    public Boolean getGrpflag() {
        return this.grpflag;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Generated
    public String getTaskGroup() {
        return this.taskGroup;
    }

    @Generated
    public Long getSavesetCnt() {
        return this.savesetCnt;
    }

    @Generated
    public Long getTargetDrive() {
        return this.targetDrive;
    }

    @Generated
    public String getTargetPool() {
        return this.targetPool;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public String getSrvIfaceName() {
        return this.srvIfaceName;
    }

    @Generated
    public Boolean getMigratedFlag() {
        return this.migratedFlag;
    }

    @Generated
    public Boolean getAbsoluteFlag() {
        return this.absoluteFlag;
    }

    @Generated
    public String getDeleteFlag() {
        return this.deleteFlag;
    }

    @Generated
    public RelativeDate getDateStart() {
        return this.dateStart;
    }

    @Generated
    public RelativeDate getDateEnd() {
        return this.dateEnd;
    }

    @Generated
    public MigrationCfdiType getCfdiType() {
        return this.cfdiType;
    }

    @Generated
    public StateType getState() {
        return this.state;
    }

    @Generated
    public String getMediaLabel() {
        return this.mediaLabel;
    }

    @Generated
    public String getClient() {
        return this.client;
    }

    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public String getListmode() {
        return this.listmode;
    }

    @Generated
    public Boolean getSubmitFlag() {
        return this.submitFlag;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Override
    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public Long getDataMoverId() {
        return this.dataMoverId;
    }

    @Generated
    public String getMigrationCmd() {
        return this.migrationCmd;
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public String getMigrationId() {
        return this.migrationId;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Boolean getImmediateFlag() {
        return this.immediateFlag;
    }

    @Generated
    public Boolean getOverwriteWithMigrationTask() {
        return this.overwriteWithMigrationTask;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonDeserialize(as=Long.class)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMigrationTask(String migrationTask) {
        this.migrationTask = migrationTask;
    }

    @Override
    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Override
    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setSaveset(String saveset) {
        this.saveset = saveset;
    }

    @Generated
    public void setGrpflag(Boolean grpflag) {
        this.grpflag = grpflag;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setTaskGroup(String taskGroup) {
        this.taskGroup = taskGroup;
    }

    @Generated
    public void setSavesetCnt(Long savesetCnt) {
        this.savesetCnt = savesetCnt;
    }

    @Generated
    public void setTargetDrive(Long targetDrive) {
        this.targetDrive = targetDrive;
    }

    @Generated
    public void setTargetPool(String targetPool) {
        this.targetPool = targetPool;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSrvIfaceName(String srvIfaceName) {
        this.srvIfaceName = srvIfaceName;
    }

    @Generated
    public void setMigratedFlag(Boolean migratedFlag) {
        this.migratedFlag = migratedFlag;
    }

    @Generated
    public void setAbsoluteFlag(Boolean absoluteFlag) {
        this.absoluteFlag = absoluteFlag;
    }

    @Generated
    public void setDeleteFlag(String deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    @Generated
    public void setDateStart(RelativeDate dateStart) {
        this.dateStart = dateStart;
    }

    @Generated
    public void setDateEnd(RelativeDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    @Generated
    public void setCfdiType(MigrationCfdiType cfdiType) {
        this.cfdiType = cfdiType;
    }

    @Generated
    public void setState(StateType state) {
        this.state = state;
    }

    @Generated
    public void setMediaLabel(String mediaLabel) {
        this.mediaLabel = mediaLabel;
    }

    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setListmode(String listmode) {
        this.listmode = listmode;
    }

    @Generated
    public void setSubmitFlag(Boolean submitFlag) {
        this.submitFlag = submitFlag;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Override
    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setDataMoverId(Long dataMoverId) {
        this.dataMoverId = dataMoverId;
    }

    @Generated
    public void setMigrationCmd(String migrationCmd) {
        this.migrationCmd = migrationCmd;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setMigrationId(String migrationId) {
        this.migrationId = migrationId;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Override
    @Generated
    public void setImmediateFlag(Boolean immediateFlag) {
        this.immediateFlag = immediateFlag;
    }

    @Generated
    public void setOverwriteWithMigrationTask(Boolean overwriteWithMigrationTask) {
        this.overwriteWithMigrationTask = overwriteWithMigrationTask;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public MigrationEvents() {
    }
}

