/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.sep.sesam.model.AllEvents;
import de.sep.sesam.model.core.AbstractEventsEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.AllEventFlag;
import de.sep.sesam.model.type.AllEventType;
import de.sep.sesam.model.type.CheckFlagType;
import de.sep.sesam.model.type.MediaActionType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class MediapoolsEvents
extends AbstractEventsEntity
implements IDisplayLabelProvider,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -2726627348593508635L;
    @JsonIgnore
    private static final Comparator<MediapoolsEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(as=Long.class)
    private Long id;
    @Schema(description="The name of the mediapool event.", example="Weekly_Media_Check")
    @Length(max=255)
    private @Length(max=255) String name;
    @Schema(description="The name of the media pool this event belongs to.", example="Backup_Pool_1")
    @NotNull
    @Length(max=16)
    private @NotNull @Length(max=16) String poolName;
    @Schema(description="Flag indicating whether the event is executable.", example="true")
    private Boolean exec;
    @Schema(description="End of life period in days.", example="365")
    private Long eol;
    @Schema(description="The name of the schedule for this event.", example="Weekly_Friday")
    @Length(max=30)
    private @Length(max=30) String scheduleName;
    @Schema(description="The priority level of the event.", example="1")
    private Long priority;
    @Schema(description="Flag indicating whether the event is suppressed.", example="false")
    private Boolean suppress;
    @Schema(description="Follow-up action or command to be executed after the event.", example="/scripts/post_media_check.sh")
    @Length(max=1024)
    private @Length(max=1024) String followUp;
    @Schema(description="The owner of the event.", example="admin")
    @NotNull
    @Length(max=30)
    private @NotNull @Length(max=30) String owner = System.getProperty("user.name");
    @Schema(description="Flag indicating whether this is a group event.", example="false")
    @NotNull
    private Boolean grpFlag;
    @Schema(description="The type of media action to be performed.", example="CLEAN")
    private MediaActionType action;
    @Schema(description="The drive number to be used.", example="1")
    private Long driveNum;
    @Schema(description="The media count for this event.", example="5")
    private Long mcount;
    @Schema(description="List of media labels.", example="TAPE001,TAPE002,TAPE003")
    @Length(max=1024)
    private @Length(max=1024) String label;
    @Schema(description="The loader number to be used.", example="1")
    private Long loaderNum;
    @Schema(description="Range of slots to be used.", example="1-10")
    @Length(max=128)
    private @Length(max=128) String slotRange;
    @Schema(description="Emergency contact or procedure.", example="on-call-admin")
    @Length(max=30)
    private @Length(max=30) String emergency;
    @Schema(description="Initialization flags for the event.", example="QUICK,VERIFY")
    @Length(max=32)
    private @Length(max=32) String initFlags;
    @Schema(description="Type of check to be performed on media labels.", example="CHECK_LABEL_ON_TAPE")
    private CheckFlagType checkFlag;
    @Schema(description="The type of media to be used.", example="LTO-8")
    @Length(max=20)
    private @Length(max=20) String mediaType;
    @Schema(description="Additional options for the event.", example="VERIFY=TRUE,COMPRESS=FALSE")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="The name of the device to be used.", example="/dev/st0")
    @Length(max=2048)
    private @Length(max=2048) String deviceName;
    @Schema(description="System-generated comment about the event.", example="Automatic cleaning scheduled")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="User-provided comment about the event.", example="Monthly tape verification process")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Flag indicating whether the event is visible in the UI.", example="true")
    private Boolean visible;
    @Schema(description="Flag indicating whether the event should start immediately.", example="false")
    private Boolean immediateFlag;
    @Schema(description="The timestamp of the last modification.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<MediapoolsEvents> sorter() {
        return comparator;
    }

    public MediapoolsEvents(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getObjectLabel() {
        return StringUtils.isNotBlank(this.poolName) ? this.poolName : "";
    }

    @JsonIgnore
    public void fill(AllEvents event) {
        event.setExec(this.getExec());
        event.setEol(this.getEol());
        event.setFollowUp(this.getFollowUp());
        event.setId(this.getId());
        event.setImmediateFlag(this.getImmediateFlag());
        event.setName(this.getName());
        event.setOwner(this.getOwner());
        event.setPriority(this.getPriority());
        event.setSuppress(this.getSuppress());
        event.setDriveNum(this.getDriveNum());
        event.setPoolName(this.getPoolName());
        event.setType(new AllEventFlag(AllEventType.MEDIA));
        event.setObject(this.getPoolName());
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Override
    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Override
    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public Boolean getGrpFlag() {
        return this.grpFlag;
    }

    @Generated
    public MediaActionType getAction() {
        return this.action;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public Long getMcount() {
        return this.mcount;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Long getLoaderNum() {
        return this.loaderNum;
    }

    @Generated
    public String getSlotRange() {
        return this.slotRange;
    }

    @Generated
    public String getEmergency() {
        return this.emergency;
    }

    @Generated
    public String getInitFlags() {
        return this.initFlags;
    }

    @Generated
    public CheckFlagType getCheckFlag() {
        return this.checkFlag;
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Override
    @Generated
    public Boolean getImmediateFlag() {
        return this.immediateFlag;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonDeserialize(as=Long.class)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    @Override
    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Override
    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setGrpFlag(Boolean grpFlag) {
        this.grpFlag = grpFlag;
    }

    @Generated
    public void setAction(MediaActionType action) {
        this.action = action;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setMcount(Long mcount) {
        this.mcount = mcount;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setLoaderNum(Long loaderNum) {
        this.loaderNum = loaderNum;
    }

    @Generated
    public void setSlotRange(String slotRange) {
        this.slotRange = slotRange;
    }

    @Generated
    public void setEmergency(String emergency) {
        this.emergency = emergency;
    }

    @Generated
    public void setInitFlags(String initFlags) {
        this.initFlags = initFlags;
    }

    @Generated
    public void setCheckFlag(CheckFlagType checkFlag) {
        this.checkFlag = checkFlag;
    }

    @Generated
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Override
    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    @Generated
    public void setImmediateFlag(Boolean immediateFlag) {
        this.immediateFlag = immediateFlag;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public MediapoolsEvents() {
    }
}

