/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;

public class MediapoolRelations
extends AbstractModelEntity<String>
implements MtimeEntity<String> {
    @JsonIgnore
    private static final Comparator<MediapoolRelations> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getPool() == null && o2 != null && o2.getPool() == null) {
            return 0;
        }
        if (o1 == null || o1.getPool() == null) {
            return -1;
        }
        if (o2 == null || o2.getPool() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getPool().compareToIgnoreCase(o2.getPool()) : o1.getPool().compareTo(o2.getPool());
    };
    @JsonIgnore
    private static final long serialVersionUID = -1088993338532451769L;
    @Schema(description="The name of the media pool in this relation.", example="MP_Daily_File")
    @Length(max=16)
    private @Length(max=16) String pool;
    @Schema(description="The name of the location associated with the media pool.", example="LOC_Primary_Storage")
    @Length(max=32)
    private @Length(max=32) String poolLocation;
    @Schema(description="The priority of this location for the media pool, determining its usage order.", example="1")
    private Long priority;
    @Schema(description="A user-provided comment about the relationship.", example="Main location for the daily file backups.")
    @Length(max=80)
    private @Length(max=80) String usercomment;
    @Schema(description="The timestamp of the last modification to the relation record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<MediapoolRelations> sorter() {
        return comparator;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return null;
    }

    public String getDisplayLabel() {
        return this.pool;
    }

    @Generated
    public String getPool() {
        return this.pool;
    }

    @Generated
    public String getPoolLocation() {
        return this.poolLocation;
    }

    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setPool(String pool) {
        this.pool = pool;
    }

    @Generated
    public void setPoolLocation(String poolLocation) {
        this.poolLocation = poolLocation;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public MediapoolRelations() {
    }
}

