/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

@Schema(description="The media pool location.")
public class MediapoolLocations
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
IDisplayLabelProvider,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 7271691119407223465L;
    @JsonIgnore
    private static final Comparator<MediapoolLocations> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique name for the media pool location.", example="Offsite_Vault")
    @NotNull
    @Length(max=32)
    private @NotNull @Length(max=32) String name;
    @Schema(description="The file system path or identifier for the storage location.", example="/mnt/tape_library/offsite")
    @Length(max=1024)
    private @Length(max=1024) String path;
    @Schema(description="A user-provided comment describing the location.", example="Iron Mountain vault for long-term storage")
    @Length(max=80)
    private @Length(max=80) String usercomment;
    @Schema(description="The total storage capacity of the location in bytes.", example="109951162777600")
    private Long capacity;
    @Schema(description="The low water mark for storage usage, typically as a percentage, to trigger alerts or actions.", example="15")
    private Long lowWaterMark;
    @Schema(description="The high water mark for storage usage, typically as a percentage, to trigger alerts or actions.", example="85")
    private Long highWaterMark;
    @Schema(description="A command or script to be executed for loading media into this location.", example="/usr/local/bin/load_tape.sh")
    @Length(max=255)
    private @Length(max=255) String loadCmd;
    @Schema(description="A command or script to be executed for unloading media from this location.", example="/usr/local/bin/unload_tape.sh")
    @Length(max=255)
    private @Length(max=255) String unloadCmd;
    @Schema(description="The access mode for the location (e.g., READ_WRITE, READ_ONLY).", example="READ_WRITE")
    @Length(max=255)
    private @Length(max=255) String accessMode;
    @Schema(description="The current operational status of the location.", example="ONLINE")
    @Length(max=255)
    private @Length(max=255) String status;
    @Schema(description="The device path for the hardware associated with this location.", example="/dev/sg5")
    @Length(max=255)
    private @Length(max=255) String devicePath;
    @Schema(description="The timestamp of the last modification to the location record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<MediapoolLocations> sorter() {
        return comparator;
    }

    public MediapoolLocations(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Long getCapacity() {
        return this.capacity;
    }

    @Generated
    public Long getLowWaterMark() {
        return this.lowWaterMark;
    }

    @Generated
    public Long getHighWaterMark() {
        return this.highWaterMark;
    }

    @Generated
    public String getLoadCmd() {
        return this.loadCmd;
    }

    @Generated
    public String getUnloadCmd() {
        return this.unloadCmd;
    }

    @Generated
    public String getAccessMode() {
        return this.accessMode;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getDevicePath() {
        return this.devicePath;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setCapacity(Long capacity) {
        this.capacity = capacity;
    }

    @Generated
    public void setLowWaterMark(Long lowWaterMark) {
        this.lowWaterMark = lowWaterMark;
    }

    @Generated
    public void setHighWaterMark(Long highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    @Generated
    public void setLoadCmd(String loadCmd) {
        this.loadCmd = loadCmd;
    }

    @Generated
    public void setUnloadCmd(String unloadCmd) {
        this.unloadCmd = unloadCmd;
    }

    @Generated
    public void setAccessMode(String accessMode) {
        this.accessMode = accessMode;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setDevicePath(String devicePath) {
        this.devicePath = devicePath;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public MediapoolLocations() {
    }
}

