/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.runtime.interfaces.IResultsModel;
import de.sep.sesam.model.type.MediaActionType;
import de.sep.sesam.model.type.MediaResultState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class MediaResults
extends AbstractModelEntity<String>
implements IResultsModel<String>,
IStringEntity,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 6118088684886462227L;
    @JsonIgnore
    private static final Comparator<MediaResults> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique identifier/name of the media result.", example="backup_result_2025001")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String name;
    @Schema(description="The name of the client associated with this result.", example="client01.example.com")
    @Length(max=255)
    private @Length(max=255) String client;
    @Schema(description="The unique identifier of the client.", example="1001")
    private Long clientId;
    @Schema(description="The drive number used for this operation.", example="1")
    private Long driveNum;
    @Schema(description="Duration of the operation in seconds.", example="3600")
    private Long duration;
    @Schema(description="End of life date for the media.", example="2026-12-31T23:59:59Z")
    private Date eol;
    @Schema(description="Name of the interface used.", example="eth0")
    private String ifaceName;
    @Schema(description="System comment about the operation.", example="Backup completed successfully")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="Process ID of the operation.", example="12345")
    private Long pid;
    @Schema(description="Priority level of the operation.", example="1")
    private Long priority;
    @Schema(description="Name of the schedule used.", example="Daily_Backup")
    @Length(max=30)
    private @Length(max=30) String schedule;
    @Schema(description="The SEP sesam date of the operation.", example="2025-06-27T10:00:00Z")
    @NotNull
    private Date sesamDate;
    @Schema(description="Version of SEP sesam used.", example="5.0.0")
    @Length(max=64)
    private @Length(max=64) String sesamVersion;
    @Schema(description="Unique identifier of the session.", example="ses_2025062710000001")
    @Length(max=32)
    private @Length(max=32) String sessionId;
    @Schema(description="Size of the data processed in bytes.", example="1099511627776")
    private Long size;
    @Schema(description="Current state of the media operation.", example="COMPLETED")
    private MediaResultState state;
    @Schema(description="Start time of the operation.", example="2025-06-27T10:00:00Z")
    private Date startTime;
    @Schema(description="Stop time of the operation.", example="2025-06-27T11:00:00Z")
    private Date stopTime;
    @Schema(description="Start time of the SBC operation.", example="2025-06-27T10:00:00Z")
    private Date sbcStart;
    @Schema(description="Termination time of the operation.", example="2025-06-27T11:00:00Z")
    private Date terminationTime;
    @Schema(description="Data throughput in bytes per second.", example="104857600")
    private Double throughput;
    @Schema(description="Username who initiated the operation.", example="admin")
    private String username;
    @Schema(description="Type of media action performed.", example="BACKUP")
    @NotNull
    private MediaActionType action;
    @Schema(description="Sub-action of the main media action.", example="INCREMENTAL")
    @Length(max=64)
    private @Length(max=64) String subAction;
    @Schema(description="Run number of the operation.", example="1")
    @NotNull
    private Long run;
    @Schema(description="Flag indicating if media check was performed.", example="true")
    private Boolean checkFlag;
    @Schema(description="Name of the data store used.", example="MainStore")
    @Length(max=32)
    private @Length(max=32) String dataStore;
    @Schema(description="Name of the media pool used.", example="Daily_Backup_Pool")
    @Length(max=16)
    private @Length(max=16) String pool;
    @Schema(description="Label of the media used.", example="TAPE0001")
    @Length(max=30)
    private @Length(max=30) String mediaLabel;
    @Schema(description="Barcode of the media used.", example="BAR0001")
    @Length(max=30)
    private @Length(max=30) String mediaBarcode;
    @Schema(description="Device path used for the operation.", example="/dev/st0")
    @Length(max=254)
    private @Length(max=254) String device;
    @Schema(description="Name of the drive device.", example="LTO8_DRIVE1")
    @Length(max=254)
    private @Length(max=254) String driveName;
    @Schema(description="Number of the loader used.", example="1")
    private Long loaderNum;
    @Schema(description="Range of slots used in the operation.", example="1-10")
    @Length(max=128)
    private @Length(max=128) String slotRange;
    @Schema(description="Number of blocks processed.", example="1000000")
    private Long blocks;
    @Schema(description="Total capacity in bytes.", example="12000000000")
    private Double capacity;
    @Schema(description="High water mark value in bytes.", example="10000000000")
    private Double highWaterMark;
    @Schema(description="Low water mark value in bytes.", example="2000000000")
    private Double lowWaterMark;
    @Schema(description="Amount of space filled in bytes.", example="8000000000")
    private Double filled;
    @Schema(description="Amount of data stored in bytes.", example="7000000000")
    private Double stored;
    @Schema(description="Total amount of data in bytes.", example="12000000000")
    private Double total;
    @Schema(description="Amount of space used in bytes.", example="8000000000")
    private Double used;
    @Schema(description="Amount of free space in bytes.", example="4000000000")
    private Double free;
    @Schema(description="Progress of the operation as a percentage.", example="75.5")
    private Double progress;
    @Schema(description="Type of drive used.", example="LTO-8")
    @Length(max=15)
    private @Length(max=15) String driveType;
    @Schema(description="Type of media used.", example="ULTRIUM-8")
    @Length(max=20)
    private @Length(max=20) String mediaType;
    @Schema(description="Short message about the operation.", example="Backup completed")
    @JsonIgnore
    @Length(max=1024)
    private @Length(max=1024) String message;
    @Schema(description="Detailed message about the operation.", example="Backup completed successfully with verification")
    @Length(max=8192)
    private @Length(max=8192) String longMessage;
    @Schema(description="Options used for the operation.", example="VERIFY=true,COMPRESS=true")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="SSDD flag status.", example="true")
    private Boolean ssddFlag;
    @Schema(description="User provided comment about the operation.", example="Monthly full backup")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Unique identifier of the result.", example="550e8400-e29b-41d4-a716-446655440000")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @Schema(description="Last modification timestamp.", example="2025-06-27T12:00:00Z")
    private Date mtime;
    @JsonIgnore
    private String originServer;

    @JsonIgnore
    public static Comparator<MediaResults> sorter() {
        return comparator;
    }

    public MediaResults(String name) {
        this.name = name;
    }

    public Double getDedup() {
        if (this.getFilled() != null && this.getStored() != null && !this.getFilled().isNaN() && !this.getStored().isNaN()) {
            return this.getFilled() / this.getStored();
        }
        return 0.0;
    }

    public String getSepcomment() {
        if (StringUtils.isBlank(this.sepcomment) && StringUtils.isNotBlank(this.message)) {
            return this.message;
        }
        return this.sepcomment;
    }

    @Override
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getClient() {
        return this.client;
    }

    @Override
    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public String getIfaceName() {
        return this.ifaceName;
    }

    @Generated
    public Long getPid() {
        return this.pid;
    }

    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public String getSesamVersion() {
        return this.sesamVersion;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public MediaResultState getState() {
        return this.state;
    }

    @Override
    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getStopTime() {
        return this.stopTime;
    }

    @Generated
    public Date getSbcStart() {
        return this.sbcStart;
    }

    @Generated
    public Date getTerminationTime() {
        return this.terminationTime;
    }

    @Generated
    public Double getThroughput() {
        return this.throughput;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public MediaActionType getAction() {
        return this.action;
    }

    @Generated
    public String getSubAction() {
        return this.subAction;
    }

    @Generated
    public Long getRun() {
        return this.run;
    }

    @Generated
    public Boolean getCheckFlag() {
        return this.checkFlag;
    }

    @Generated
    public String getDataStore() {
        return this.dataStore;
    }

    @Generated
    public String getPool() {
        return this.pool;
    }

    @Generated
    public String getMediaLabel() {
        return this.mediaLabel;
    }

    @Generated
    public String getMediaBarcode() {
        return this.mediaBarcode;
    }

    @Generated
    public String getDevice() {
        return this.device;
    }

    @Generated
    public String getDriveName() {
        return this.driveName;
    }

    @Generated
    public Long getLoaderNum() {
        return this.loaderNum;
    }

    @Generated
    public String getSlotRange() {
        return this.slotRange;
    }

    @Generated
    public Long getBlocks() {
        return this.blocks;
    }

    @Generated
    public Double getCapacity() {
        return this.capacity;
    }

    @Generated
    public Double getHighWaterMark() {
        return this.highWaterMark;
    }

    @Generated
    public Double getLowWaterMark() {
        return this.lowWaterMark;
    }

    @Generated
    public Double getFilled() {
        return this.filled;
    }

    @Generated
    public Double getStored() {
        return this.stored;
    }

    @Generated
    public Double getTotal() {
        return this.total;
    }

    @Generated
    public Double getUsed() {
        return this.used;
    }

    @Generated
    public Double getFree() {
        return this.free;
    }

    @Generated
    public Double getProgress() {
        return this.progress;
    }

    @Generated
    public String getDriveType() {
        return this.driveType;
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getLongMessage() {
        return this.longMessage;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public Boolean getSsddFlag() {
        return this.ssddFlag;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public String getOriginServer() {
        return this.originServer;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Override
    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setSesamVersion(String sesamVersion) {
        this.sesamVersion = sesamVersion;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setState(MediaResultState state) {
        this.state = state;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    @Generated
    public void setSbcStart(Date sbcStart) {
        this.sbcStart = sbcStart;
    }

    @Generated
    public void setTerminationTime(Date terminationTime) {
        this.terminationTime = terminationTime;
    }

    @Generated
    public void setThroughput(Double throughput) {
        this.throughput = throughput;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setAction(MediaActionType action) {
        this.action = action;
    }

    @Generated
    public void setSubAction(String subAction) {
        this.subAction = subAction;
    }

    @Generated
    public void setRun(Long run) {
        this.run = run;
    }

    @Generated
    public void setCheckFlag(Boolean checkFlag) {
        this.checkFlag = checkFlag;
    }

    @Generated
    public void setDataStore(String dataStore) {
        this.dataStore = dataStore;
    }

    @Generated
    public void setPool(String pool) {
        this.pool = pool;
    }

    @Generated
    public void setMediaLabel(String mediaLabel) {
        this.mediaLabel = mediaLabel;
    }

    @Generated
    public void setMediaBarcode(String mediaBarcode) {
        this.mediaBarcode = mediaBarcode;
    }

    @Generated
    public void setDevice(String device) {
        this.device = device;
    }

    @Generated
    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    @Generated
    public void setLoaderNum(Long loaderNum) {
        this.loaderNum = loaderNum;
    }

    @Generated
    public void setSlotRange(String slotRange) {
        this.slotRange = slotRange;
    }

    @Generated
    public void setBlocks(Long blocks) {
        this.blocks = blocks;
    }

    @Generated
    public void setCapacity(Double capacity) {
        this.capacity = capacity;
    }

    @Generated
    public void setHighWaterMark(Double highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    @Generated
    public void setLowWaterMark(Double lowWaterMark) {
        this.lowWaterMark = lowWaterMark;
    }

    @Generated
    public void setFilled(Double filled) {
        this.filled = filled;
    }

    @Generated
    public void setStored(Double stored) {
        this.stored = stored;
    }

    @Generated
    public void setTotal(Double total) {
        this.total = total;
    }

    @Generated
    public void setUsed(Double used) {
        this.used = used;
    }

    @Generated
    public void setFree(Double free) {
        this.free = free;
    }

    @Generated
    public void setProgress(Double progress) {
        this.progress = progress;
    }

    @Generated
    public void setDriveType(String driveType) {
        this.driveType = driveType;
    }

    @Generated
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @JsonIgnore
    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setLongMessage(String longMessage) {
        this.longMessage = longMessage;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setSsddFlag(Boolean ssddFlag) {
        this.ssddFlag = ssddFlag;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }

    @Generated
    public MediaResults() {
    }
}

