/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.HwDriveAccessMode;
import de.sep.sesam.model.type.MediaPoolType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;

public class MediaPools
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity {
    public static final String TYPE_CLONE = "clone";
    @JsonIgnore
    private static final long serialVersionUID = 8091119936118173935L;
    @JsonIgnore
    private static final Comparator<MediaPools> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique identifier of the media pool.", example="1001")
    private Long id;
    @Schema(description="The name of the media pool. Only letters, numbers, underscores and hyphens are allowed.", example="MP_Daily_Backup")
    @NotNull
    @Length(max=16)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    private @NotNull @Length(max=16) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @Schema(description="The type of media pool.", example="DISK")
    private MediaPoolType type;
    @Schema(description="A description of the media pool.", example="Pool for daily backups")
    @Length(max=1024)
    private @Length(max=1024) String descript;
    @Schema(description="The ID of the associated drive group.", example="1")
    private Long driveGroupId;
    @Schema(description="The name of the associated drive group.", example="LTO8_Drives")
    private String driveGroupName;
    @Schema(description="The name of the failover pool to be used if this pool is unavailable.", example="MP_Backup_Failover")
    @Length(max=255)
    private @Length(max=255) String failoverPool;
    @Schema(description="The storage type of the media.", example="LTO-8")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String mediaStrg;
    @Schema(description="The changer type of the media.", example="L80")
    @NotNull
    @Length(max=8)
    private @NotNull @Length(max=8) String mediaChg;
    @Schema(description="Flag indicating whether the media should be closed after initialization.", example="true")
    private Boolean closeOnInit;
    @Schema(description="Flag indicating whether the group should be closed after initialization.", example="false")
    private Boolean closeOnInitGrp;
    @Schema(description="The access mode for the pool.", example="READ_WRITE")
    private HwDriveAccessMode accessMode;
    @Schema(description="Flag indicating whether the pool is inactive.", example="false")
    private Boolean inactive;
    @Schema(description="Flag indicating whether the pool is available.", example="true")
    private Boolean isAvailable;
    @Schema(description="Execution status of the pool.", example="1")
    private Long exec;
    @Schema(description="The capacity of the disk pool in bytes.", example="1099511627776")
    @Length(max=16)
    private @Length(max=16) Long diskCapac;
    @Schema(description="The directory for the disk pool.", example="/backup/disk_pool")
    @Length(max=254)
    private @Length(max=254) String diskDir;
    @Schema(description="The end-of-life time in days.", example="7")
    @NotNull
    private Long eol = 7L;
    @Schema(description="Flag indicating whether empty media are accepted.", example="true")
    private Boolean acceptEmpty;
    @Schema(description="Flag indicating whether end-of-life media are accepted.", example="false")
    private Boolean acceptEol;
    @Schema(description="Flag indicating whether spare media are accepted.", example="true")
    private Boolean acceptSpare;
    @Schema(description="Flag indicating whether other media are accepted.", example="false")
    private Boolean acceptOther;
    @Schema(description="Flag indicating whether moving media is allowed.", example="true")
    private Boolean allowMove;
    @Schema(description="Flag indicating whether storage pools should be used.", example="true")
    private Boolean useStoragepools;
    @Schema(description="Limit for read checks.", example="100")
    private Long readcheckLimit;
    @Schema(description="Flag for purging.", example="Y")
    @Length(max=1)
    private @Length(max=1) String purgeFlag;
    @Schema(description="Repeat rate for read checks in days.", example="30")
    private Long readcheckRepeatrate;
    @Schema(description="Overdue time for read checks in days.", example="45")
    private Long readcheckOverdue;
    @Schema(description="Encryption key for media.", example="encrypted_key_123")
    @Length(max=128)
    private @Length(max=128) String cryptKeyMedia;
    @Schema(description="Flag for media encryption.", example="true")
    private Boolean cryptFlagMedia;
    @Schema(description="Flag for saving the encryption key.", example="true")
    private Boolean cryptSavekeyFlagMedia;
    @Schema(description="The timestamp of the last modification.", example="1720077461000")
    private Date mtime;
    @Schema(description="The name of the associated data store.", example="MainDataStore")
    private String dataStoreName;
    @Schema(description="The number of the loader.", example="1")
    private Long loaderNum;
    @Schema(description="The name of the loader.", example="Tape_Library_1")
    private String loaderName;
    @Schema(description="The current occupation of the pool in percent.", example="75.5")
    private Float occupation;
    @Schema(description="The total number of media in the pool.", example="100")
    private Long totalMedia;
    @Schema(description="The number of free EOL media in the pool.", example="10")
    private Long eolFreeMedia;

    @JsonIgnore
    public static Comparator<MediaPools> sorter() {
        return comparator;
    }

    public MediaPools() {
    }

    public MediaPools(String name) {
        this.name = name;
    }

    public MediaPools(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public void setDescript(String descript) {
        this.descript = descript == null ? null : descript.trim();
    }

    public void setMediaStrg(String mediaStrg) {
        this.mediaStrg = mediaStrg == null ? null : mediaStrg.trim();
    }

    public void setMediaChg(String mediaChg) {
        this.mediaChg = mediaChg == null ? null : mediaChg.trim();
    }

    public void setDiskDir(String diskDir) {
        this.diskDir = diskDir == null ? null : diskDir.trim();
    }

    public void setCryptKeyMedia(String cryptKeyMedia) {
        this.cryptKeyMedia = cryptKeyMedia == null ? null : cryptKeyMedia.trim();
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.getName();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public MediaPoolType getType() {
        return this.type;
    }

    @Generated
    public String getDescript() {
        return this.descript;
    }

    @Generated
    public Long getDriveGroupId() {
        return this.driveGroupId;
    }

    @Generated
    public String getDriveGroupName() {
        return this.driveGroupName;
    }

    @Generated
    public String getFailoverPool() {
        return this.failoverPool;
    }

    @Generated
    public String getMediaStrg() {
        return this.mediaStrg;
    }

    @Generated
    public String getMediaChg() {
        return this.mediaChg;
    }

    @Generated
    public Boolean getCloseOnInit() {
        return this.closeOnInit;
    }

    @Generated
    public Boolean getCloseOnInitGrp() {
        return this.closeOnInitGrp;
    }

    @Generated
    public HwDriveAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Generated
    public Boolean getInactive() {
        return this.inactive;
    }

    @Generated
    public Boolean getIsAvailable() {
        return this.isAvailable;
    }

    @Generated
    public Long getExec() {
        return this.exec;
    }

    @Generated
    public Long getDiskCapac() {
        return this.diskCapac;
    }

    @Generated
    public String getDiskDir() {
        return this.diskDir;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Generated
    public Boolean getAcceptEmpty() {
        return this.acceptEmpty;
    }

    @Generated
    public Boolean getAcceptEol() {
        return this.acceptEol;
    }

    @Generated
    public Boolean getAcceptSpare() {
        return this.acceptSpare;
    }

    @Generated
    public Boolean getAcceptOther() {
        return this.acceptOther;
    }

    @Generated
    public Boolean getAllowMove() {
        return this.allowMove;
    }

    @Generated
    public Boolean getUseStoragepools() {
        return this.useStoragepools;
    }

    @Generated
    public Long getReadcheckLimit() {
        return this.readcheckLimit;
    }

    @Generated
    public String getPurgeFlag() {
        return this.purgeFlag;
    }

    @Generated
    public Long getReadcheckRepeatrate() {
        return this.readcheckRepeatrate;
    }

    @Generated
    public Long getReadcheckOverdue() {
        return this.readcheckOverdue;
    }

    @Generated
    public String getCryptKeyMedia() {
        return this.cryptKeyMedia;
    }

    @Generated
    public Boolean getCryptFlagMedia() {
        return this.cryptFlagMedia;
    }

    @Generated
    public Boolean getCryptSavekeyFlagMedia() {
        return this.cryptSavekeyFlagMedia;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getDataStoreName() {
        return this.dataStoreName;
    }

    @Generated
    public Long getLoaderNum() {
        return this.loaderNum;
    }

    @Generated
    public String getLoaderName() {
        return this.loaderName;
    }

    @Generated
    public Float getOccupation() {
        return this.occupation;
    }

    @Generated
    public Long getTotalMedia() {
        return this.totalMedia;
    }

    @Generated
    public Long getEolFreeMedia() {
        return this.eolFreeMedia;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setType(MediaPoolType type) {
        this.type = type;
    }

    @Generated
    public void setDriveGroupId(Long driveGroupId) {
        this.driveGroupId = driveGroupId;
    }

    @Generated
    public void setDriveGroupName(String driveGroupName) {
        this.driveGroupName = driveGroupName;
    }

    @Generated
    public void setFailoverPool(String failoverPool) {
        this.failoverPool = failoverPool;
    }

    @Generated
    public void setCloseOnInit(Boolean closeOnInit) {
        this.closeOnInit = closeOnInit;
    }

    @Generated
    public void setCloseOnInitGrp(Boolean closeOnInitGrp) {
        this.closeOnInitGrp = closeOnInitGrp;
    }

    @Generated
    public void setAccessMode(HwDriveAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Generated
    public void setInactive(Boolean inactive) {
        this.inactive = inactive;
    }

    @Generated
    public void setIsAvailable(Boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    @Generated
    public void setExec(Long exec) {
        this.exec = exec;
    }

    @Generated
    public void setDiskCapac(Long diskCapac) {
        this.diskCapac = diskCapac;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Generated
    public void setAcceptEmpty(Boolean acceptEmpty) {
        this.acceptEmpty = acceptEmpty;
    }

    @Generated
    public void setAcceptEol(Boolean acceptEol) {
        this.acceptEol = acceptEol;
    }

    @Generated
    public void setAcceptSpare(Boolean acceptSpare) {
        this.acceptSpare = acceptSpare;
    }

    @Generated
    public void setAcceptOther(Boolean acceptOther) {
        this.acceptOther = acceptOther;
    }

    @Generated
    public void setAllowMove(Boolean allowMove) {
        this.allowMove = allowMove;
    }

    @Generated
    public void setUseStoragepools(Boolean useStoragepools) {
        this.useStoragepools = useStoragepools;
    }

    @Generated
    public void setReadcheckLimit(Long readcheckLimit) {
        this.readcheckLimit = readcheckLimit;
    }

    @Generated
    public void setPurgeFlag(String purgeFlag) {
        this.purgeFlag = purgeFlag;
    }

    @Generated
    public void setReadcheckRepeatrate(Long readcheckRepeatrate) {
        this.readcheckRepeatrate = readcheckRepeatrate;
    }

    @Generated
    public void setReadcheckOverdue(Long readcheckOverdue) {
        this.readcheckOverdue = readcheckOverdue;
    }

    @Generated
    public void setCryptFlagMedia(Boolean cryptFlagMedia) {
        this.cryptFlagMedia = cryptFlagMedia;
    }

    @Generated
    public void setCryptSavekeyFlagMedia(Boolean cryptSavekeyFlagMedia) {
        this.cryptSavekeyFlagMedia = cryptSavekeyFlagMedia;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setDataStoreName(String dataStoreName) {
        this.dataStoreName = dataStoreName;
    }

    @Generated
    public void setLoaderNum(Long loaderNum) {
        this.loaderNum = loaderNum;
    }

    @Generated
    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName;
    }

    @Generated
    public void setOccupation(Float occupation) {
        this.occupation = occupation;
    }

    @Generated
    public void setTotalMedia(Long totalMedia) {
        this.totalMedia = totalMedia;
    }

    @Generated
    public void setEolFreeMedia(Long eolFreeMedia) {
        this.eolFreeMedia = eolFreeMedia;
    }
}

