/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.sep.sesam.model.AllEvents;
import de.sep.sesam.model.core.AbstractEventsEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.runtime.interfaces.IAllEventsAdaptable;
import de.sep.sesam.model.type.AllEventFlag;
import de.sep.sesam.model.type.AllEventType;
import de.sep.sesam.model.type.MediaActionType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class MediaEvents
extends AbstractEventsEntity
implements IDisplayLabelProvider,
IAllEventsAdaptable,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 3834817456494045219L;
    @JsonIgnore
    private static final Comparator<MediaEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @Schema(description="The unique identifier of the media event.", example="1")
    @NotNull
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(as=Long.class)
    private Long id;
    @Schema(description="The name of the media event.", example="Monthly Archive")
    @Length(max=255)
    private @Length(max=255) String name;
    @Schema(description="The action associated with the event, defining what will be executed.", example="ARCHIVE")
    @NotNull
    @Length(max=16)
    private @NotNull @Length(max=16) String action;
    @Schema(description="A flag indicating whether the event is enabled for execution.", example="true")
    private Boolean exec;
    @Schema(description="The name of the schedule that triggers this event.", example="Monthly_Backup_Schedule")
    @Length(max=30)
    private @Length(max=30) String scheduleName;
    @Schema(description="A follow-up event or script to be executed after this event completes.", example="cleanup_script")
    @Length(max=1024)
    private @Length(max=1024) String followUp;
    @Schema(description="The execution priority of the event.", example="50")
    private Long priority;
    @Schema(description="A flag to suppress notifications for this event.", example="false")
    private Boolean suppress;
    @Schema(description="The user who owns this media event.", example="admin")
    @NotNull
    @Length(max=30)
    private @NotNull @Length(max=30) String owner;
    @Schema(description="A flag to indicate if this is a group-level event.", example="false")
    private Boolean grpFlag;
    @Schema(description="The End-of-Life for the media affected by this event, often in days.", example="365")
    private Long eol;
    @Schema(description="The type of action to be performed by the event.", example="INITIALIZE")
    private MediaActionType actionType;
    @Schema(description="The loader number associated with the event.", example="1")
    @NotNull
    private Long loaderNum;
    @Schema(description="The name of the data store targeted by the event.", example="DS_Archive")
    @NotNull
    @Length(max=32)
    private @NotNull @Length(max=32) String dataStoreName;
    @Schema(description="The drive number to be used for the event.", example="2")
    private Long driveNum;
    @Schema(description="The media pool targeted by the event.", example="MP_Archive_LTO8")
    @NotNull
    @Length(max=16)
    private @NotNull @Length(max=16) String poolName;
    @Schema(description="A label or pattern to identify specific media for the event.", example="LTO_ARCH_*")
    @Length(max=1024)
    private @Length(max=1024) String label;
    @Schema(description="The number of media to be processed by the event.", example="5")
    private Long mCount;
    @Schema(description="A single-character type identifier for the event.", example="I")
    @Length(max=1)
    private @Length(max=1) String type;
    @Schema(description="The range of slots in the loader to be processed.", example="1-10")
    @Length(max=128)
    private @Length(max=128) String slotRange;
    @Schema(description="Defines an emergency follow-up event in case of failure.", example="notify_admin_on_fail")
    @Length(max=30)
    private @Length(max=30) String emergency;
    @Schema(description="Flags to control the media initialization process.", example="OVERWRITE")
    @Length(max=32)
    private @Length(max=32) String initFlags;
    @Schema(description="A flag for special checks, e.g., 'F' for a forced readcheck or 'N' for initialization during inventory.", example="F")
    @Length(max=2)
    private @Length(max=2) String checkFlag;
    @Schema(description="The specific media type to be used or processed by the event.", example="LTO-8")
    @Length(max=20)
    private @Length(max=20) String mediaType;
    @Schema(description="Additional options or parameters for the event execution.", example="-v 2")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="The low water mark for capacity-based triggers, typically as a percentage.", example="10")
    private Long lowWaterMark;
    @Schema(description="The high water mark for capacity-based triggers, typically as a percentage.", example="90")
    private Long highWaterMark;
    @Schema(description="The specific device name to be used for the event.", example="/dev/nst0")
    @Length(max=2048)
    private @Length(max=2048) String deviceName;
    @Schema(description="An internal comment or note about the media event.", example="Handles the monthly off-site archival.")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="A user-provided comment for the media event.", example="This event must run after the quarterly closing.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="A flag indicating whether the event is visible in the user interface.", example="true")
    private Boolean visible;
    @Schema(description="A flag to trigger the immediate execution of the event, bypassing the schedule.", example="false")
    private Boolean immediateFlag;
    @Schema(description="The timestamp of the last modification to the media event record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<MediaEvents> sorter() {
        return comparator;
    }

    public MediaEvents(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public String getObjectLabel() {
        return StringUtils.isNotBlank(this.action) ? this.action : "";
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public void fill(AllEvents event) {
        assert (event != null);
        event.setExec(this.getExec());
        event.setEol(this.getEol());
        event.setFollowUp(this.getFollowUp());
        event.setId(this.getId());
        event.setName(this.getName());
        event.setOwner(this.getOwner());
        event.setPriority(this.getPriority());
        event.setSuppress(this.getSuppress());
        event.setDriveNum(this.getDriveNum());
        event.setPoolName(this.getPoolName());
        event.setType(new AllEventFlag(AllEventType.MEDIA));
        event.setObject(this.action);
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Override
    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Override
    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Override
    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public Boolean getGrpFlag() {
        return this.grpFlag;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Generated
    public MediaActionType getActionType() {
        return this.actionType;
    }

    @Generated
    public Long getLoaderNum() {
        return this.loaderNum;
    }

    @Generated
    public String getDataStoreName() {
        return this.dataStoreName;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getPoolName() {
        return this.poolName;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Long getMCount() {
        return this.mCount;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getSlotRange() {
        return this.slotRange;
    }

    @Generated
    public String getEmergency() {
        return this.emergency;
    }

    @Generated
    public String getInitFlags() {
        return this.initFlags;
    }

    @Generated
    public String getCheckFlag() {
        return this.checkFlag;
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public Long getLowWaterMark() {
        return this.lowWaterMark;
    }

    @Generated
    public Long getHighWaterMark() {
        return this.highWaterMark;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Override
    @Generated
    public Boolean getImmediateFlag() {
        return this.immediateFlag;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonDeserialize(as=Long.class)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Override
    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setGrpFlag(Boolean grpFlag) {
        this.grpFlag = grpFlag;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Generated
    public void setActionType(MediaActionType actionType) {
        this.actionType = actionType;
    }

    @Generated
    public void setLoaderNum(Long loaderNum) {
        this.loaderNum = loaderNum;
    }

    @Generated
    public void setDataStoreName(String dataStoreName) {
        this.dataStoreName = dataStoreName;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setMCount(Long mCount) {
        this.mCount = mCount;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSlotRange(String slotRange) {
        this.slotRange = slotRange;
    }

    @Generated
    public void setEmergency(String emergency) {
        this.emergency = emergency;
    }

    @Generated
    public void setInitFlags(String initFlags) {
        this.initFlags = initFlags;
    }

    @Generated
    public void setCheckFlag(String checkFlag) {
        this.checkFlag = checkFlag;
    }

    @Generated
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setLowWaterMark(Long lowWaterMark) {
        this.lowWaterMark = lowWaterMark;
    }

    @Generated
    public void setHighWaterMark(Long highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    @Generated
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Override
    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    @Generated
    public void setImmediateFlag(Boolean immediateFlag) {
        this.immediateFlag = immediateFlag;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public MediaEvents() {
    }
}

