/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.MediaActionType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class MediaActions
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -853450845006601125L;
    @JsonIgnore
    private static final Comparator<MediaActions> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique name of the media action.", example="Daily_Import")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String name;
    @Schema(description="The type of the media action, defining its category.", example="im")
    @NotNull
    @Length(max=2)
    private @NotNull @Length(max=2) String type;
    @Schema(description="The user or system component that owns or initiated this action.", example="admin")
    @Length(max=30)
    private @Length(max=30) String owner;
    @Schema(description="The specific action to be performed on the media.", example="IMPORT")
    private MediaActionType action;
    @Schema(description="The target data store for the media action.", example="DataStore_1")
    @Length(max=32)
    private @Length(max=32) String dataStore;
    @Schema(description="The media pool on which the action is to be performed.", example="Weekly_Tapes")
    @Length(max=16)
    private @Length(max=16) String pool;
    @Schema(description="A label or pattern to identify specific media for the action.", example="TAPE*")
    @Length(max=1024)
    private @Length(max=1024) String label;
    @Schema(description="The drive number to be used for the action.", example="2")
    private Long driveNum;
    @Schema(description="A flag to suppress notifications or standard behavior for this action.", example="false")
    private Boolean suppress;
    @Schema(description="The low water mark for capacity-based actions, typically as a percentage.", example="10")
    private Long lowWaterMark;
    @Schema(description="The high water mark for capacity-based actions, typically as a percentage.", example="90")
    private Long highWaterMark;
    @Schema(description="A flag to enable or disable specific checks during the action.", example="true")
    private Boolean checkFlag;
    @Schema(description="The modification timestamp of the media action record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<MediaActions> sorter() {
        return comparator;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public MediaActionType getAction() {
        return this.action;
    }

    @Generated
    public String getDataStore() {
        return this.dataStore;
    }

    @Generated
    public String getPool() {
        return this.pool;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public Long getLowWaterMark() {
        return this.lowWaterMark;
    }

    @Generated
    public Long getHighWaterMark() {
        return this.highWaterMark;
    }

    @Generated
    public Boolean getCheckFlag() {
        return this.checkFlag;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setAction(MediaActionType action) {
        this.action = action;
    }

    @Generated
    public void setDataStore(String dataStore) {
        this.dataStore = dataStore;
    }

    @Generated
    public void setPool(String pool) {
        this.pool = pool;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setLowWaterMark(Long lowWaterMark) {
        this.lowWaterMark = lowWaterMark;
    }

    @Generated
    public void setHighWaterMark(Long highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    @Generated
    public void setCheckFlag(Boolean checkFlag) {
        this.checkFlag = checkFlag;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public MediaActions() {
    }
}

