/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.MediaLockType;
import de.sep.sesam.model.type.MediaReadCheckState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class Media
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
INamedEntity,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = -446592475901214691L;
    @JsonIgnore
    private static final Comparator<Media> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique label of the medium, used as its primary identifier.", example="TAPE00001")
    @NotNull
    @Length(max=30)
    private @NotNull @Length(max=30) String name;
    @Schema(description="A custom, human-readable label for the medium, used for display purposes.", example="Daily Backup Tape 1")
    private String label;
    @Schema(description="The barcode value associated with the physical medium.", example="BCN-123456789")
    @Length(max=30)
    private @Length(max=30) String barcode;
    @Schema(description="The name of the media pool this medium belongs to.", example="MP_DAILY_BACKUP")
    @NotNull
    private String poolName;
    @Schema(description="The unique numerical identifier for the medium.", example="101")
    @NotNull
    private Long id;
    @Schema(description="An external identifier for the medium, used for integration with other systems.", example="9901")
    private Long externalId;
    @Schema(description="The lock state of the medium.", example="NO")
    @NotNull
    private MediaLockType locked;
    @Schema(description="The logical SEP sesam date associated with the medium's creation or last use.", example="1720040400000")
    @NotNull
    private Date sesamDate;
    @Schema(description="The End-of-Life date for the medium, after which it can be reused.", example="1751613461000")
    private Date eol;
    @Schema(description="The user or process that last changed the End-of-Life date.", example="admin")
    @Length(max=64)
    private @Length(max=64) String eolChangedby;
    @Schema(description="The full name of the user who last changed the End-of-Life date.", example="Administrator")
    @Length(max=255)
    private @Length(max=255) String eolChangedByUser;
    @Schema(description="A message or reason provided for the last End-of-Life date change.", example="Extended retention for audit purposes.")
    @Length(max=254)
    private @Length(max=254) String eolChangedByMsg;
    @Schema(description="The number of the drive where the medium is currently loaded or was last used.", example="1")
    private Long driveNum;
    @Schema(description="The name of the drive where the medium is currently loaded or was last used.", example="DRIVE_1")
    private String driveName;
    @Schema(description="The type of object representing the medium's location within a loader (e.g., 'slot', 'drive').", example="slot")
    private String object;
    @Schema(description="The number of the drive that was used to initialize the medium.", example="1")
    private Long initDrive;
    @Schema(description="The sequence number of the medium within a media set.", example="1")
    private Long sequence;
    @Schema(description="The label of the preceding medium in a media set.", example="TAPE00000")
    @Length(max=30)
    private @Length(max=30) String previousLabel;
    @Schema(description="The label of the next medium in a media set.", example="TAPE00002")
    @Length(max=30)
    private @Length(max=30) String nextLabel;
    @Schema(description="The type of the medium.", example="LTO-8")
    @NotNull
    @Length(max=20)
    private @NotNull @Length(max=20) String mediaType;
    @Schema(description="The number of the loader where the medium is located.", example="1")
    private Long loaderNum;
    @Schema(description="The name of the loader where the medium is located.", example="LTO_LOADER_1")
    private String loaderName;
    @Schema(description="The slot number in the loader where the medium resides.", example="5")
    private Long slot;
    @Schema(description="The block size of the medium in bytes.", example="65536")
    private Long blockSize;
    @Schema(description="The total capacity of the medium in KiB.", example="12000000000")
    private Long capacity;
    @Schema(description="The available free space on the medium in KiB.", example="5000000000")
    private Long free;
    @Schema(description="The amount of used space on the medium in KiB.", example="7000000000.0")
    private Double filled;
    @Schema(description="Indicates if the End-of-Medium (EOM) has been reached.", example="false")
    private Boolean eomState;
    @Schema(description="The timestamp of the first initialization of the medium.", example="1720077461000")
    private Date firstInit;
    @Schema(description="The timestamp of the most recent initialization of the medium.", example="1720084800000")
    private Date lastInit;
    @Schema(description="Flag indicating whether the tape is closed for further writing.", example="false")
    private Boolean closeTape;
    @Schema(description="A flag indicating the initialization status of the medium.", example="true")
    private Boolean initFlag;
    @Schema(description="The number of errors recorded for this medium.", example="0")
    private Long error;
    @Schema(description="The number of deleted or resolved errors for this medium.", example="0")
    private Long errorDelt;
    @Schema(description="The number of times this medium has been used.", example="25")
    private Long useCount;
    @Schema(description="The physical location of the medium (e.g., a shelf or off-site vault).", example="Main_Safe")
    @Length(max=32)
    private @Length(max=32) String location;
    @Schema(description="A flag indicating if the medium is a duplicate.", example="false")
    private Boolean duplflag;
    @Schema(description="An internal comment about the medium.", example="For quarterly financial data archival.")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="A flag indicating if the medium is marked for purging.", example="false")
    private Boolean purgeFlag;
    @Schema(description="A comment provided by a user.", example="Contains encrypted backups of the CRM database.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The state of the last read check performed on the medium.", example="OK")
    private MediaReadCheckState readcheckState;
    @Schema(description="A message associated with the last read check.", example="Read check completed successfully.")
    @Length(max=254)
    private @Length(max=254) String readcheckMsg;
    @Schema(description="The encryption key used for the data on this medium.", example="key-placeholder")
    @Length(max=512)
    private @Length(max=512) String cryptKeyMedia;
    @Schema(description="The Base64 encoded hash of the encryption key.", example="...")
    @Length(max=180)
    private @Length(max=180) String cryptHashBase64Media;
    @Schema(description="A flag indicating if the medium is encrypted.", example="true")
    private Boolean cryptFlagMedia;
    @Schema(description="Indicates whether the medium is capable of encryption.", example="true")
    private Boolean encryptionCapable;
    @Schema(description="Indicates whether the medium contains encrypted data blocks.", example="true")
    private Boolean containsEncryptedBlocks;
    @Schema(description="The Unique Cartridge Identity (UCI) of the medium.", example="LTO_12345_L8")
    @Length(max=132)
    private @Length(max=132) String uniqueCartridgeIdentity;
    @Schema(description="The manufacturer's serial number of the cartridge.", example="SN-ABC-123")
    @Length(max=128)
    private @Length(max=128) String serialNumber;
    @Schema(description="The timestamp of the last modification to the medium's record.", example="1720077461000")
    private Date mtime;
    @Schema(description="The unique identifier (UUID) of the medium.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef12")
    @Length(max=40)
    private @Length(max=40) String uuid;

    @JsonIgnore
    public static Comparator<Media> sorter() {
        return comparator;
    }

    public Media(String label) {
        this.name = label;
    }

    public Double getFilled() {
        if (this.filled == null) {
            return 0.0;
        }
        return this.filled;
    }

    @Override
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        if (this.label == null) {
            return this.name;
        }
        return this.label;
    }

    @JsonIgnore
    public void setDisplayLabel(String label) {
        this.label = label;
        if (StringUtils.isEmpty(label)) {
            this.label = null;
        }
    }

    @JsonIgnore
    public boolean isActive() {
        boolean active = false;
        if (!Boolean.TRUE.equals(this.getEomState()) && !Boolean.TRUE.equals(this.getCloseTape()) && !MediaLockType.LOCKED.equals((Object)this.getLocked()) && this.getEol() != null && this.getEol().after(new Date())) {
            active = true;
        }
        return active;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getBarcode() {
        return this.barcode;
    }

    @Generated
    public String getPoolName() {
        return this.poolName;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getExternalId() {
        return this.externalId;
    }

    @Generated
    public MediaLockType getLocked() {
        return this.locked;
    }

    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public String getEolChangedby() {
        return this.eolChangedby;
    }

    @Generated
    public String getEolChangedByUser() {
        return this.eolChangedByUser;
    }

    @Generated
    public String getEolChangedByMsg() {
        return this.eolChangedByMsg;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getDriveName() {
        return this.driveName;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getInitDrive() {
        return this.initDrive;
    }

    @Generated
    public Long getSequence() {
        return this.sequence;
    }

    @Generated
    public String getPreviousLabel() {
        return this.previousLabel;
    }

    @Generated
    public String getNextLabel() {
        return this.nextLabel;
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public Long getLoaderNum() {
        return this.loaderNum;
    }

    @Generated
    public String getLoaderName() {
        return this.loaderName;
    }

    @Generated
    public Long getSlot() {
        return this.slot;
    }

    @Generated
    public Long getBlockSize() {
        return this.blockSize;
    }

    @Generated
    public Long getCapacity() {
        return this.capacity;
    }

    @Generated
    public Long getFree() {
        return this.free;
    }

    @Generated
    public Boolean getEomState() {
        return this.eomState;
    }

    @Generated
    public Date getFirstInit() {
        return this.firstInit;
    }

    @Generated
    public Date getLastInit() {
        return this.lastInit;
    }

    @Generated
    public Boolean getCloseTape() {
        return this.closeTape;
    }

    @Generated
    public Boolean getInitFlag() {
        return this.initFlag;
    }

    @Generated
    public Long getError() {
        return this.error;
    }

    @Generated
    public Long getErrorDelt() {
        return this.errorDelt;
    }

    @Generated
    public Long getUseCount() {
        return this.useCount;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public Boolean getDuplflag() {
        return this.duplflag;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public Boolean getPurgeFlag() {
        return this.purgeFlag;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public MediaReadCheckState getReadcheckState() {
        return this.readcheckState;
    }

    @Generated
    public String getReadcheckMsg() {
        return this.readcheckMsg;
    }

    @Generated
    public String getCryptKeyMedia() {
        return this.cryptKeyMedia;
    }

    @Generated
    public String getCryptHashBase64Media() {
        return this.cryptHashBase64Media;
    }

    @Generated
    public Boolean getCryptFlagMedia() {
        return this.cryptFlagMedia;
    }

    @Generated
    public Boolean getEncryptionCapable() {
        return this.encryptionCapable;
    }

    @Generated
    public Boolean getContainsEncryptedBlocks() {
        return this.containsEncryptedBlocks;
    }

    @Generated
    public String getUniqueCartridgeIdentity() {
        return this.uniqueCartridgeIdentity;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    @Generated
    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setExternalId(Long externalId) {
        this.externalId = externalId;
    }

    @Generated
    public void setLocked(MediaLockType locked) {
        this.locked = locked;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setEolChangedby(String eolChangedby) {
        this.eolChangedby = eolChangedby;
    }

    @Generated
    public void setEolChangedByUser(String eolChangedByUser) {
        this.eolChangedByUser = eolChangedByUser;
    }

    @Generated
    public void setEolChangedByMsg(String eolChangedByMsg) {
        this.eolChangedByMsg = eolChangedByMsg;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setInitDrive(Long initDrive) {
        this.initDrive = initDrive;
    }

    @Generated
    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    @Generated
    public void setPreviousLabel(String previousLabel) {
        this.previousLabel = previousLabel;
    }

    @Generated
    public void setNextLabel(String nextLabel) {
        this.nextLabel = nextLabel;
    }

    @Generated
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Generated
    public void setLoaderNum(Long loaderNum) {
        this.loaderNum = loaderNum;
    }

    @Generated
    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName;
    }

    @Generated
    public void setSlot(Long slot) {
        this.slot = slot;
    }

    @Generated
    public void setBlockSize(Long blockSize) {
        this.blockSize = blockSize;
    }

    @Generated
    public void setCapacity(Long capacity) {
        this.capacity = capacity;
    }

    @Generated
    public void setFree(Long free) {
        this.free = free;
    }

    @Generated
    public void setFilled(Double filled) {
        this.filled = filled;
    }

    @Generated
    public void setEomState(Boolean eomState) {
        this.eomState = eomState;
    }

    @Generated
    public void setFirstInit(Date firstInit) {
        this.firstInit = firstInit;
    }

    @Generated
    public void setLastInit(Date lastInit) {
        this.lastInit = lastInit;
    }

    @Generated
    public void setCloseTape(Boolean closeTape) {
        this.closeTape = closeTape;
    }

    @Generated
    public void setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
    }

    @Generated
    public void setError(Long error) {
        this.error = error;
    }

    @Generated
    public void setErrorDelt(Long errorDelt) {
        this.errorDelt = errorDelt;
    }

    @Generated
    public void setUseCount(Long useCount) {
        this.useCount = useCount;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setDuplflag(Boolean duplflag) {
        this.duplflag = duplflag;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setPurgeFlag(Boolean purgeFlag) {
        this.purgeFlag = purgeFlag;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setReadcheckState(MediaReadCheckState readcheckState) {
        this.readcheckState = readcheckState;
    }

    @Generated
    public void setReadcheckMsg(String readcheckMsg) {
        this.readcheckMsg = readcheckMsg;
    }

    @Generated
    public void setCryptKeyMedia(String cryptKeyMedia) {
        this.cryptKeyMedia = cryptKeyMedia;
    }

    @Generated
    public void setCryptHashBase64Media(String cryptHashBase64Media) {
        this.cryptHashBase64Media = cryptHashBase64Media;
    }

    @Generated
    public void setCryptFlagMedia(Boolean cryptFlagMedia) {
        this.cryptFlagMedia = cryptFlagMedia;
    }

    @Generated
    public void setEncryptionCapable(Boolean encryptionCapable) {
        this.encryptionCapable = encryptionCapable;
    }

    @Generated
    public void setContainsEncryptedBlocks(Boolean containsEncryptedBlocks) {
        this.containsEncryptedBlocks = containsEncryptedBlocks;
    }

    @Generated
    public void setUniqueCartridgeIdentity(String uniqueCartridgeIdentity) {
        this.uniqueCartridgeIdentity = uniqueCartridgeIdentity;
    }

    @Generated
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public Media() {
    }
}

