/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.ICredentialsProvider;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IOsCredentialsProvider;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.LocationType;
import de.sep.sesam.model.utils.ModelUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotBlank;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class Locations
extends AbstractModelEntity<Long>
implements ILongEntity,
IDisplayLabelProvider,
MtimeEntity<Long>,
INamedEntity,
ICredentialsProvider,
IOsCredentialsProvider {
    @JsonIgnore
    private static final long serialVersionUID = -6631340662145718263L;
    @JsonIgnore
    private static final Comparator<Locations> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getLocationType() == null && o2 != null && o2.getLocationType() != null) {
            return -1;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @JsonIgnore
    private static final Comparator<Locations> comparatorByDisplayLabel = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getLocationType() == null && o2 != null && o2.getLocationType() != null) {
            return -1;
        }
        if (o1 != null && o1.getDisplayLabel() == null && o2 != null && o2.getDisplayLabel() == null) {
            return 0;
        }
        if (o1 == null || o1.getDisplayLabel() == null) {
            return -1;
        }
        if (o2 == null || o2.getDisplayLabel() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getDisplayLabel().compareToIgnoreCase(o2.getDisplayLabel()) : o1.getDisplayLabel().compareTo(o2.getDisplayLabel());
    };
    @Schema(description="The unique identifier for the location.", example="1")
    private Long id;
    @Schema(description="The name of the location. Must be unique.", example="Hauptstandort", requiredMode=Schema.RequiredMode.REQUIRED)
    @Length(max=64)
    @NotBlank
    @NotNull
    @MatchPattern(pattern={"^[a-zA-Z0-9_\\u0020-]*$"})
    private @Length(max=64) @NotBlank @NotNull @MatchPattern(pattern={"^[a-zA-Z0-9_\\u0020-]*$"}) String name;
    @Schema(description="The ID of the parent location, if this is a sub-location.", example="1")
    private Long parentId;
    @Schema(description="A short description of the location.", example="Central data center in Munich")
    @Length(max=128)
    private @Length(max=128) String describe;
    @Schema(description="Contact person or information for the location.", example="network.admins@example.com")
    @Length(max=128)
    private @Length(max=128) String contact;
    @Schema(description="Internal comment regarding the location.", example="Created during initial setup on 2024-01-01")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="The ID of the credential associated with this location.", example="101")
    private Long credentialId;
    @Schema(description="The UUID of the credential associated with this location.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    @Length(max=40)
    private @Length(max=40) String credentialUuid;
    @Schema(description="The ID of the operating system credential.", example="102")
    private Long osCredentialId;
    @Schema(description="The UUID of the operating system credential.", example="b2c3d4e5-f6a7-8901-2345-67890abcdef1")
    @Length(max=40)
    private @Length(max=40) String osCredentialUuid;
    @Schema(description="The operating system user for accessing resources at this location.", example="administrator")
    @Length(max=255)
    private @Length(max=255) String osUser;
    @Schema(description="The password for the operating system user.", example="<password_placeholder>")
    @Length(max=512)
    private @Length(max=512) String osPassword;
    @Schema(description="The ID of the user who owns or manages this location.", example="25")
    private Long userId;
    @Schema(description="The ID of the user group associated with this location.", example="5")
    private Long groupId;
    @Schema(description="The timestamp of the last modification.", example="2025-06-26T10:00:00Z")
    private Date dateChanged;
    @Schema(description="The timestamp of the creation.", example="2025-01-15T09:30:00Z")
    private Date dateCreated;
    @Schema(description="The user who performed the last change.", example="admin")
    private String changedBy;
    @Schema(description="The type of the location.", example="PRIMARY")
    private LocationType locationType;
    @Schema(description="A comment provided by the user.", example="Main location for all production servers.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The unique identifier (UUID) for the location.", example="c3d4e5f6-a7b8-9012-3456-7890abcdef12")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @Schema(description="The display label showing the full path from the root location. Used by external tools.", example="Global/Europe/Germany/Hauptstandort")
    private String displayLabel;
    @Schema(description="List of client IDs associated with a secondary location.", example="[10, 15, 22]")
    private List<Long> clientIds;
    @Schema(description="The modification time of the location record from the database.", example="1720077461")
    private Date mtime;

    @JsonIgnore
    public static Comparator<Locations> sorter() {
        return comparator;
    }

    @JsonIgnore
    public static Comparator<Locations> sorterByDisplayLabel() {
        return comparatorByDisplayLabel;
    }

    public Locations(Long id) {
        this.id = id;
    }

    public Locations(Locations original) {
        assert (original != null);
        ModelUtils.copyProperties(this, original);
    }

    @Override
    public String getDisplayLabel() {
        if (StringUtils.isBlank(this.displayLabel)) {
            return this.name;
        }
        return this.displayLabel;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getParentId() {
        return this.parentId;
    }

    @Generated
    public String getDescribe() {
        return this.describe;
    }

    @Generated
    public String getContact() {
        return this.contact;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Override
    @Generated
    public Long getCredentialId() {
        return this.credentialId;
    }

    @Override
    @Generated
    public String getCredentialUuid() {
        return this.credentialUuid;
    }

    @Override
    @Generated
    public Long getOsCredentialId() {
        return this.osCredentialId;
    }

    @Override
    @Generated
    public String getOsCredentialUuid() {
        return this.osCredentialUuid;
    }

    @Generated
    public String getOsUser() {
        return this.osUser;
    }

    @Generated
    public String getOsPassword() {
        return this.osPassword;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public Long getGroupId() {
        return this.groupId;
    }

    @Generated
    public Date getDateChanged() {
        return this.dateChanged;
    }

    @Generated
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Generated
    public String getChangedBy() {
        return this.changedBy;
    }

    @Generated
    public LocationType getLocationType() {
        return this.locationType;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public List<Long> getClientIds() {
        return this.clientIds;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Generated
    public void setDescribe(String describe) {
        this.describe = describe;
    }

    @Generated
    public void setContact(String contact) {
        this.contact = contact;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Override
    @Generated
    public void setCredentialId(Long credentialId) {
        this.credentialId = credentialId;
    }

    @Override
    @Generated
    public void setCredentialUuid(String credentialUuid) {
        this.credentialUuid = credentialUuid;
    }

    @Override
    @Generated
    public void setOsCredentialId(Long osCredentialId) {
        this.osCredentialId = osCredentialId;
    }

    @Override
    @Generated
    public void setOsCredentialUuid(String osCredentialUuid) {
        this.osCredentialUuid = osCredentialUuid;
    }

    @Generated
    public void setOsUser(String osUser) {
        this.osUser = osUser;
    }

    @Generated
    public void setOsPassword(String osPassword) {
        this.osPassword = osPassword;
    }

    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setDateChanged(Date dateChanged) {
        this.dateChanged = dateChanged;
    }

    @Generated
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Generated
    public void setChangedBy(String changedBy) {
        this.changedBy = changedBy;
    }

    @Generated
    public void setLocationType(LocationType locationType) {
        this.locationType = locationType;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    @Generated
    public void setClientIds(List<Long> clientIds) {
        this.clientIds = clientIds;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Locations() {
    }
}

