/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.LoaderDevicesKey;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;

public class LoaderDevices
extends AbstractModelEntity<LoaderDevicesKey>
implements MtimeEntity<LoaderDevicesKey> {
    private static final long serialVersionUID = -8022548373218863499L;
    @JsonIgnore
    private static final Comparator<LoaderDevices> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getDevicePath() == null && o2 != null && o2.getDevicePath() == null) {
            return 0;
        }
        if (o1 == null || o1.getDevicePath() == null) {
            return -1;
        }
        if (o2 == null || o2.getDevicePath() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getDevicePath().compareToIgnoreCase(o2.getDevicePath()) : o1.getDevicePath().compareTo(o2.getDevicePath());
    };
    @JsonIgnore
    private LoaderDevicesKey pk = new LoaderDevicesKey();
    @Schema(description="The path to the device.", example="/dev/tape/by-id/scsi-3500104f00140228d-nst")
    @Length(max=1024)
    private @Length(max=1024) String devicePath;
    @Schema(description="The point in time where the object was last modified. The last modification time is represented as UNIX Epoch time.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<LoaderDevices> sorter() {
        return comparator;
    }

    public final Long getLoader() {
        return this.pk.getLoader();
    }

    public final void setLoader(Long loader) {
        this.pk.setLoader(loader);
    }

    public final Long getSlot() {
        return this.pk.getSlot();
    }

    public final void setSlot(Long slot) {
        this.pk.setSlot(slot);
    }

    @Override
    @JsonIgnore
    public LoaderDevicesKey getPK() {
        return this.pk;
    }

    public String getDisplayLabel() {
        return this.devicePath;
    }

    @Generated
    public String getDevicePath() {
        return this.devicePath;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @JsonIgnore
    @Generated
    public void setPk(LoaderDevicesKey pk) {
        this.pk = pk;
    }

    @Generated
    public void setDevicePath(String devicePath) {
        this.devicePath = devicePath;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public LoaderDevices() {
    }
}

