/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.LoaderContentsKey;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.LoaderCheckLbl;
import de.sep.sesam.model.type.LoaderContentsObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;

public class LoaderContents
extends AbstractModelEntity<LoaderContentsKey>
implements IDisplayLabelProvider,
MtimeEntity<LoaderContentsKey> {
    @JsonIgnore
    private static final long serialVersionUID = -2796973717548432911L;
    @JsonIgnore
    private static final Comparator<LoaderContents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getNumber() == null && o2 != null && o2.getNumber() == null) {
            return 0;
        }
        if (o1 == null || o1.getNumber() == null) {
            return -1;
        }
        if (o2 == null || o2.getNumber() == null) {
            return 1;
        }
        return o1.getNumber().compareTo(o2.getNumber());
    };
    @JsonIgnore
    private LoaderContentsKey pk = new LoaderContentsKey();
    @Schema(description="The label of the medium in the loader slot.", example="TAPE00123")
    @Length(max=30)
    private @Length(max=30) String lbl;
    @Schema(description="The barcode of the medium in the loader slot.", example="BC123456789XYZ")
    @Length(max=30)
    private @Length(max=30) String barcode;
    @Schema(description="The status of the label check.", example="g")
    private LoaderCheckLbl checkLbl;
    @Schema(description="The label that was verified during the check.", example="TAPE00123")
    private String checkedlbl;
    @Schema(description="The source object of a media movement operation.", example="slot")
    private LoaderContentsObject fromObject;
    @Schema(description="The slot/drive/port number of the source.", example="5")
    private Long fromNumber;
    @Schema(description="The destination object of a media movement operation.", example="drive")
    private LoaderContentsObject toObject;
    @Schema(description="The slot/drive/port number of the destination.", example="1")
    private Long toNumber;
    @Schema(description="The unique number of the drive.", example="1")
    private Long driveNum;
    @Schema(description="The name of the drive.", example="DRIVE_1")
    private String driveName;
    @Schema(description="The physical location of the item within the loader.", example="SLOT_12")
    @Length(max=32)
    private @Length(max=32) String location;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<LoaderContents> sorter() {
        return comparator;
    }

    public final Long getLoaderNum() {
        return this.pk.getLoaderNum();
    }

    public final void setLoaderNum(Long loaderNum) {
        this.pk.setLoaderNum(loaderNum);
    }

    public final LoaderContentsObject getObject() {
        return this.pk.getObject();
    }

    public final void setObject(LoaderContentsObject object) {
        this.pk.setObject(object);
    }

    public final Long getNumber() {
        return this.pk.getNumber();
    }

    public final void setNumber(Long number) {
        this.pk.setNumber(number);
    }

    @Override
    @JsonIgnore
    public LoaderContentsKey getPK() {
        return this.pk;
    }

    @Override
    public String getDisplayLabel() {
        return String.valueOf(this.pk.getNumber());
    }

    @Generated
    public String getLbl() {
        return this.lbl;
    }

    @Generated
    public String getBarcode() {
        return this.barcode;
    }

    @Generated
    public LoaderCheckLbl getCheckLbl() {
        return this.checkLbl;
    }

    @Generated
    public String getCheckedlbl() {
        return this.checkedlbl;
    }

    @Generated
    public LoaderContentsObject getFromObject() {
        return this.fromObject;
    }

    @Generated
    public Long getFromNumber() {
        return this.fromNumber;
    }

    @Generated
    public LoaderContentsObject getToObject() {
        return this.toObject;
    }

    @Generated
    public Long getToNumber() {
        return this.toNumber;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getDriveName() {
        return this.driveName;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @JsonIgnore
    @Generated
    public void setPk(LoaderContentsKey pk) {
        this.pk = pk;
    }

    @Generated
    public void setLbl(String lbl) {
        this.lbl = lbl;
    }

    @Generated
    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    @Generated
    public void setCheckLbl(LoaderCheckLbl checkLbl) {
        this.checkLbl = checkLbl;
    }

    @Generated
    public void setCheckedlbl(String checkedlbl) {
        this.checkedlbl = checkedlbl;
    }

    @Generated
    public void setFromObject(LoaderContentsObject fromObject) {
        this.fromObject = fromObject;
    }

    @Generated
    public void setFromNumber(Long fromNumber) {
        this.fromNumber = fromNumber;
    }

    @Generated
    public void setToObject(LoaderContentsObject toObject) {
        this.toObject = toObject;
    }

    @Generated
    public void setToNumber(Long toNumber) {
        this.toNumber = toNumber;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public LoaderContents() {
    }
}

