/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.LoaderDevices;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.LoaderCtrlType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class HwLoaders
extends AbstractModelEntity<Long>
implements ILongEntity,
IDisplayLabelProvider,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 2843587218483343803L;
    @JsonIgnore
    private static final Comparator<HwLoaders> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @Schema(description="The unique ID of the loader.", example="1")
    @NotNull
    private Long id;
    @Schema(description="The device path or name for the loader.", example="/dev/tape/by-id/scsi-3500104f0012e1f3a")
    @NotNull
    @Length(max=254)
    private @NotNull @Length(max=254) String device;
    @Schema(description="The ID of the client to which the loader is attached.", example="101")
    @NotNull
    private Long clientId;
    @Schema(description="The name of the client to which the loader is attached.", example="my-tape-server")
    private String clientName;
    @Schema(description="The logical name of the loader.", example="TAPE_LIBRARY_01")
    @Length(max=32)
    private @Length(max=32) String name;
    @Schema(description="The type of the loader.", example="LTO-8")
    @NotNull
    @Length(max=32)
    private @NotNull @Length(max=32) String loaderType;
    @Schema(description="The vendor of the loader hardware.", example="Quantum")
    @Length(max=64)
    private @Length(max=64) String vendor;
    @Schema(description="The product name of the loader hardware.", example="Scalar i500")
    @Length(max=64)
    private @Length(max=64) String product;
    @Schema(description="The serial number of the loader hardware.", example="SN123456XYZ")
    @Length(max=64)
    private @Length(max=64) String serialNumber;
    @Schema(description="An additional identifier for the loader.", example="QUANTUM-SCALAR-I500-A")
    @Length(max=255)
    private @Length(max=255) String identifier;
    @Schema(description="The loader control library type.", example="DIR_SLU")
    @NotNull
    private LoaderCtrlType ctrl;
    @Schema(description="The number of slots in the loader.", example="50")
    @NotNull
    private Long slots;
    @Schema(description="The maximum number of slots the loader can have.", example="100")
    private Long maxSlots;
    @Schema(description="The number of drives in the loader.", example="4")
    private Long drives;
    @Schema(description="The number of import/export ports in the loader.", example="5")
    private Long ports;
    @Schema(description="The number of transport elements in the loader.", example="1")
    private Long transport;
    @Schema(description="The number of the first slot in the loader.", example="1")
    private Long firstSlot;
    @Schema(description="The number of the last slot in the loader.", example="50")
    private Long lastSlot;
    @Schema(description="Indicates whether the loader should automatically unload media.", example="true")
    private Boolean autounload;
    @Schema(description="Indicates whether the loader has a barcode reader.", example="true")
    private Boolean barcode;
    @Schema(description="A custom command to load a medium.", example="/usr/bin/custom_load.sh %d %s")
    @Length(max=255)
    private @Length(max=255) String loadCmd;
    @Schema(description="A custom command to unload a medium.", example="/usr/bin/custom_unload.sh %d")
    @Length(max=255)
    private @Length(max=255) String unloadCmd;
    @Schema(description="An internal comment for the loader.", example="System-generated comment")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="A user-provided comment for the loader.", example="Main tape library in Rack 2")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="A list of devices associated with this loader.")
    private List<LoaderDevices> loaderDevices;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;
    @Schema(description="The number of drives configured for this loader.", example="4")
    private Long driveCount;

    @JsonIgnore
    public static Comparator<HwLoaders> sorter() {
        return comparator;
    }

    public HwLoaders(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        String label = "";
        if (this.getId() == null) {
            return label;
        }
        if (this.getId() == 0L) {
            label = I18n.get("Label.VirtualLoader", new Object[0]);
        } else {
            String name = StringUtils.isNotBlank(this.getName()) ? this.getName() : I18n.get("Label.Loader", this.getId());
            label = I18n.get("AbstractComponentTreeTableRowData.Label.Loader", name, this.getId());
        }
        return label;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDevice() {
        return this.device;
    }

    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getLoaderType() {
        return this.loaderType;
    }

    @Generated
    public String getVendor() {
        return this.vendor;
    }

    @Generated
    public String getProduct() {
        return this.product;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public LoaderCtrlType getCtrl() {
        return this.ctrl;
    }

    @Generated
    public Long getSlots() {
        return this.slots;
    }

    @Generated
    public Long getMaxSlots() {
        return this.maxSlots;
    }

    @Generated
    public Long getDrives() {
        return this.drives;
    }

    @Generated
    public Long getPorts() {
        return this.ports;
    }

    @Generated
    public Long getTransport() {
        return this.transport;
    }

    @Generated
    public Long getFirstSlot() {
        return this.firstSlot;
    }

    @Generated
    public Long getLastSlot() {
        return this.lastSlot;
    }

    @Generated
    public Boolean getAutounload() {
        return this.autounload;
    }

    @Generated
    public Boolean getBarcode() {
        return this.barcode;
    }

    @Generated
    public String getLoadCmd() {
        return this.loadCmd;
    }

    @Generated
    public String getUnloadCmd() {
        return this.unloadCmd;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public List<LoaderDevices> getLoaderDevices() {
        return this.loaderDevices;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public Long getDriveCount() {
        return this.driveCount;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDevice(String device) {
        this.device = device;
    }

    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLoaderType(String loaderType) {
        this.loaderType = loaderType;
    }

    @Generated
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Generated
    public void setProduct(String product) {
        this.product = product;
    }

    @Generated
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setCtrl(LoaderCtrlType ctrl) {
        this.ctrl = ctrl;
    }

    @Generated
    public void setSlots(Long slots) {
        this.slots = slots;
    }

    @Generated
    public void setMaxSlots(Long maxSlots) {
        this.maxSlots = maxSlots;
    }

    @Generated
    public void setDrives(Long drives) {
        this.drives = drives;
    }

    @Generated
    public void setPorts(Long ports) {
        this.ports = ports;
    }

    @Generated
    public void setTransport(Long transport) {
        this.transport = transport;
    }

    @Generated
    public void setFirstSlot(Long firstSlot) {
        this.firstSlot = firstSlot;
    }

    @Generated
    public void setLastSlot(Long lastSlot) {
        this.lastSlot = lastSlot;
    }

    @Generated
    public void setAutounload(Boolean autounload) {
        this.autounload = autounload;
    }

    @Generated
    public void setBarcode(Boolean barcode) {
        this.barcode = barcode;
    }

    @Generated
    public void setLoadCmd(String loadCmd) {
        this.loadCmd = loadCmd;
    }

    @Generated
    public void setUnloadCmd(String unloadCmd) {
        this.unloadCmd = unloadCmd;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setLoaderDevices(List<LoaderDevices> loaderDevices) {
        this.loaderDevices = loaderDevices;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setDriveCount(Long driveCount) {
        this.driveCount = driveCount;
    }

    @Generated
    public HwLoaders() {
    }
}

