/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.Clients;
import de.sep.sesam.model.DriveGroups;
import de.sep.sesam.model.DriveTypes;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.ICredentialsProvider;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.DSDriveMode;
import de.sep.sesam.model.type.HwDriveAccessMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class HwDrives
extends AbstractModelEntity<Long>
implements ILongEntity,
IDisplayLabelProvider,
MtimeEntity<Long>,
INamedEntity,
ICredentialsProvider {
    @JsonIgnore
    private static final long serialVersionUID = -4344736902888748592L;
    @JsonIgnore
    private static final Comparator<HwDrives> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @Schema(description="The unique ID of the drive, corresponding to the drive number.", example="1")
    @NotNull
    private Long id;
    @Schema(description="The device path or name for the drive.", example="/dev/nst0")
    @NotNull
    @Length(max=254)
    @MatchPattern(pattern={"^[a-zA-Z0-9_/\\\\.\\-@]*$"})
    private @NotNull @Length(max=254) @MatchPattern(pattern={"^[a-zA-Z0-9_/\\\\.\\-@]*$"}) String device;
    @Schema(description="The client to which the drive is attached.", example="CLIENT_01", defaultValue="0")
    @NotNull
    private Clients client = new Clients(0L);
    @Schema(description="The type of the drive.", example="DISK_STORE")
    @NotNull
    private DriveTypes driveType;
    @Schema(description="The vendor of the drive hardware.", example="IBM")
    @Length(max=64)
    private @Length(max=64) String vendor;
    @Schema(description="The product name of the drive hardware.", example="ULT3580-HH8")
    @Length(max=64)
    private @Length(max=64) String product;
    @Schema(description="The serial number of the drive hardware.", example="1234567890")
    @Length(max=64)
    private @Length(max=64) String serialNumber;
    @Schema(description="An additional identifier for the drive.", example="DRIVE-001-SERIAL-ABC")
    @Length(max=255)
    private @Length(max=255) String identifier;
    @Schema(description="The logical name of the drive.", example="TAPE_DRIVE_1")
    @Length(max=32)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    private @Length(max=32) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @Schema(description="The number of the loader that this drive belongs to.", example="1")
    private Long loaderNum;
    @Schema(description="The name of the loader that this drive belongs to.", example="LTO_LOADER")
    private String loaderName;
    @Schema(description="Indicates whether hardware compression is enabled for the drive.", example="true")
    private Boolean compress;
    @Schema(description="The status of the drive.", example="OK")
    @Length(max=132)
    private @Length(max=132) String sts;
    @Schema(description="A message providing more details about the drive's status.", example="Drive is online and ready.")
    @Length(max=1024)
    private @Length(max=1024) String msg;
    @Schema(description="Indicates whether the drive is currently occupied.", example="false")
    private Boolean occupy;
    @Schema(description="The access mode for the drive, e.g., READ_WRITE.", example="READ_WRITE")
    private HwDriveAccessMode accessMode;
    @Schema(description="The number of tasks executed by the drive.", example="150")
    private Long exec;
    @Schema(description="The number of tasks completed by the drive.", example="150")
    private Long done;
    @Schema(description="The number of tasks currently running on the drive.", example="0")
    private Long run;
    @Schema(description="The number of tasks waiting for the drive.", example="0")
    private Long waiting;
    @Schema(description="The data throughput of the drive in bytes per second.", example="100000000.0")
    private Double throughput;
    @Schema(description="The drive group.", example="GROUP_1")
    @JsonIgnore
    private DriveGroups group;
    @Schema(description="Internal counter related to SMS.", example="0")
    private Long smsCnts;
    @Schema(description="The label of the medium currently in the drive.", example="LTO800001")
    @Length(max=30)
    private @Length(max=30) String label;
    @Schema(description="The label of the last medium that was in the drive.", example="LTO800000")
    @Length(max=30)
    private @Length(max=30) String lastLabel;
    @Schema(description="The timeout for drive operations in seconds.", example="3600")
    private Long timeout;
    @Schema(description="The timeout for media operations in seconds.", example="7200")
    private Long mediaTimeout;
    @Schema(description="A flag indicating if the drive requires cleaning.", example="false")
    private Boolean cleanBit;
    @Schema(description="The drive number within the loader.", example="1")
    private Long loaderDrive;
    @Schema(description="The path for a disk-based drive.", example="/mnt/data/disk_drive_1")
    @Length(max=255)
    private @Length(max=255) String path;
    @Schema(description="The device path of the drive.", example="/dev/sg5")
    @Length(max=255)
    private @Length(max=255) String devicePath;
    @Schema(description="The path where the drive's index is stored.", example="/var/opt/sesam/var/ini/drive1_index")
    @Length(max=255)
    private @Length(max=255) String indexPath;
    @Schema(description="The name of the data store associated with this drive.", example="DATASTORE_01")
    @Length(max=32)
    private @Length(max=32) String dataStore;
    @Schema(description="A flag to indicate whether the medium should be ejected after use.", example="true")
    private Boolean ejectFlag;
    @Schema(description="A custom command to mount the drive.", example="/bin/mount /dev/sdb1 /mnt/backup")
    @Length(max=255)
    private @Length(max=255) String mountCmd;
    @Schema(description="A custom command to unmount the drive.", example="/bin/umount /mnt/backup")
    @Length(max=255)
    private @Length(max=255) String umountCmd;
    @Schema(description="A command to bring the drive online.", example="/opt/sesam/bin/sms_drive online 1")
    @Length(max=255)
    private @Length(max=255) String onlineCmd;
    @Schema(description="A command to load a medium into the drive.", example="/opt/sesam/bin/sms_load LTO_LOADER 1 LTO800001")
    @Length(max=255)
    private @Length(max=255) String loadCmd;
    @Schema(description="A command to unload a medium from the drive.", example="/opt/sesam/bin/sms_unload LTO_LOADER 1")
    @Length(max=255)
    private @Length(max=255) String unloadCmd;
    @Schema(description="The UUID of the credential used to access the drive.", example="b2c3d4e5-f6a7-8901-2345-67890abcdef1")
    @Length(max=40)
    private @Length(max=40) String credentialUuid;
    @Schema(description="The ID of the credential used to access the drive.", example="10")
    private Long credentialId;
    @Schema(description="The username for accessing the storage.", example="nas_admin")
    @Length(max=128)
    private @Length(max=128) String username;
    @Schema(description="The password for accessing the storage.", example="********")
    @Length(max=512)
    private @Length(max=512) String password;
    @Schema(description="The server or device providing the storage.", example="nas.example.com")
    @Length(max=255)
    private @Length(max=255) String storageServer;
    @Schema(description="A command to eject a medium from the drive.", example="/opt/sesam/bin/sms_eject LTO_LOADER 1")
    @Length(max=255)
    private @Length(max=255) String ejectCmd;
    @Schema(description="The block size for the drive in bytes.", example="65536")
    private Long blockSize;
    @Schema(description="The default block size for the drive in bytes.", example="65536")
    private Long defaultBlockSize;
    @Schema(description="The SMS number of the drive.", example="1")
    private Long smsNr;
    @Schema(description="The segment size for data transfers in bytes.", example="1073741824")
    private Long segmentSize;
    @Schema(description="The listen port for the drive.", example="11301")
    private Long listenPort;
    @Schema(description="The TLS listen port for the drive.", example="11302")
    private Long listenTlsPort;
    @Schema(description="The admin listen port for the drive.", example="11303")
    private Long listenAdminPort;
    @Schema(description="Additional options for the drive.", example="OPTION_A=1,OPTION_B=2")
    @Length(max=512)
    private @Length(max=512) String options;
    @Schema(description="Additional queue manager options.", example="QM_OPT=FAST")
    @Length(max=512)
    private @Length(max=512) String qmOptions;
    @Schema(description="Indicates if the drive is capable of hardware encryption.", example="true")
    private Boolean encryptionCapable;
    @Schema(description="The password for drive-based encryption.", example="********")
    @Length(max=512)
    private @Length(max=512) String encryptionPassword;
    @Schema(description="The previous password for drive-based encryption, used for key rotation.", example="********")
    @Length(max=512)
    private @Length(max=512) String previousPassword;
    @Schema(description="An internal comment for the drive.", example="System-generated comment")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="A user-provided comment for the drive.", example="Primary tape drive in data center A.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The unique identifier (UUID) for the drive.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @Schema(description="A flag that controls the invocation of a configuration command before database insertion.", example="false")
    private Boolean configDrive;
    @Schema(description="The data store drive mode.", example="MASTER")
    private DSDriveMode dsDriveMode;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;
    @JsonIgnore
    private Boolean skipAccessModeValidation;

    @JsonIgnore
    public static Comparator<HwDrives> sorter() {
        return comparator;
    }

    public HwDrives(Long id) {
        this.id = id;
    }

    public String getDriveGroupName() {
        if (this.group == null) {
            return null;
        }
        return this.group.getName();
    }

    public void setDriveGroupName(String groupName) {
        if (groupName == null) {
            this.group = null;
        } else {
            if (this.group == null || this.group.getName() != null && !this.group.getName().equals(groupName)) {
                this.group = new DriveGroups();
            }
            this.group.setName(groupName);
        }
    }

    public Long getDriveGroupId() {
        if (this.group == null) {
            return null;
        }
        return this.group.getId();
    }

    public void setDriveGroupId(Long id) {
        if (id == null) {
            this.group = null;
        } else {
            if (this.group == null || this.group.getId() != null && !this.group.getId().equals(id)) {
                this.group = new DriveGroups();
            }
            this.group.setId(id);
        }
    }

    public String getSepcomment() {
        return StringUtils.isNotBlank(this.sepcomment) ? this.sepcomment : this.msg;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        if (this.getId() == null && StringUtils.isBlank(this.name)) {
            return "";
        }
        return this.getId() == null || this.getId() != -1L ? I18n.get("AbstractComponentTreeTableRowData.Label.Drive", StringUtils.isNotBlank(this.getName()) ? this.getName() : "-", this.getId() != null ? this.getId() : "-") : "*";
    }

    @JsonIgnore
    public void addQmOption(int prio, int streams) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank(this.qmOptions)) {
            builder.append(this.qmOptions);
            builder.append(",");
        }
        builder.append("prio=");
        builder.append(prio);
        builder.append("_");
        builder.append(streams);
        this.qmOptions = builder.toString();
    }

    @JsonIgnore
    public List<Integer> getPriorityWithStreams() {
        if (StringUtils.isNotBlank(this.qmOptions)) {
            ArrayList<Integer> resultList = new ArrayList<Integer>();
            List<String> pairs = Arrays.asList(this.qmOptions.split(","));
            pairs.forEach(pair -> {
                try {
                    String tmp = pair.replaceAll("[^0-9]+", " ");
                    int prio = Integer.parseInt(tmp.split(" ")[1]);
                    int streams = Integer.parseInt(tmp.split(" ")[2]);
                    resultList.add(prio);
                    resultList.add(streams);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return resultList;
        }
        return null;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDevice() {
        return this.device;
    }

    @Generated
    public Clients getClient() {
        return this.client;
    }

    @Generated
    public DriveTypes getDriveType() {
        return this.driveType;
    }

    @Generated
    public String getVendor() {
        return this.vendor;
    }

    @Generated
    public String getProduct() {
        return this.product;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getLoaderNum() {
        return this.loaderNum;
    }

    @Generated
    public String getLoaderName() {
        return this.loaderName;
    }

    @Generated
    public Boolean getCompress() {
        return this.compress;
    }

    @Generated
    public String getSts() {
        return this.sts;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public Boolean getOccupy() {
        return this.occupy;
    }

    @Generated
    public HwDriveAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Generated
    public Long getExec() {
        return this.exec;
    }

    @Generated
    public Long getDone() {
        return this.done;
    }

    @Generated
    public Long getRun() {
        return this.run;
    }

    @Generated
    public Long getWaiting() {
        return this.waiting;
    }

    @Generated
    public Double getThroughput() {
        return this.throughput;
    }

    @Generated
    public DriveGroups getGroup() {
        return this.group;
    }

    @Generated
    public Long getSmsCnts() {
        return this.smsCnts;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getLastLabel() {
        return this.lastLabel;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public Long getMediaTimeout() {
        return this.mediaTimeout;
    }

    @Generated
    public Boolean getCleanBit() {
        return this.cleanBit;
    }

    @Generated
    public Long getLoaderDrive() {
        return this.loaderDrive;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getDevicePath() {
        return this.devicePath;
    }

    @Generated
    public String getIndexPath() {
        return this.indexPath;
    }

    @Generated
    public String getDataStore() {
        return this.dataStore;
    }

    @Generated
    public Boolean getEjectFlag() {
        return this.ejectFlag;
    }

    @Generated
    public String getMountCmd() {
        return this.mountCmd;
    }

    @Generated
    public String getUmountCmd() {
        return this.umountCmd;
    }

    @Generated
    public String getOnlineCmd() {
        return this.onlineCmd;
    }

    @Generated
    public String getLoadCmd() {
        return this.loadCmd;
    }

    @Generated
    public String getUnloadCmd() {
        return this.unloadCmd;
    }

    @Override
    @Generated
    public String getCredentialUuid() {
        return this.credentialUuid;
    }

    @Override
    @Generated
    public Long getCredentialId() {
        return this.credentialId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getStorageServer() {
        return this.storageServer;
    }

    @Generated
    public String getEjectCmd() {
        return this.ejectCmd;
    }

    @Generated
    public Long getBlockSize() {
        return this.blockSize;
    }

    @Generated
    public Long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    @Generated
    public Long getSmsNr() {
        return this.smsNr;
    }

    @Generated
    public Long getSegmentSize() {
        return this.segmentSize;
    }

    @Generated
    public Long getListenPort() {
        return this.listenPort;
    }

    @Generated
    public Long getListenTlsPort() {
        return this.listenTlsPort;
    }

    @Generated
    public Long getListenAdminPort() {
        return this.listenAdminPort;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getQmOptions() {
        return this.qmOptions;
    }

    @Generated
    public Boolean getEncryptionCapable() {
        return this.encryptionCapable;
    }

    @Generated
    public String getEncryptionPassword() {
        return this.encryptionPassword;
    }

    @Generated
    public String getPreviousPassword() {
        return this.previousPassword;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public Boolean getConfigDrive() {
        return this.configDrive;
    }

    @Generated
    public DSDriveMode getDsDriveMode() {
        return this.dsDriveMode;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public Boolean getSkipAccessModeValidation() {
        return this.skipAccessModeValidation;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDevice(String device) {
        this.device = device;
    }

    @Generated
    public void setClient(Clients client) {
        this.client = client;
    }

    @Generated
    public void setDriveType(DriveTypes driveType) {
        this.driveType = driveType;
    }

    @Generated
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Generated
    public void setProduct(String product) {
        this.product = product;
    }

    @Generated
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLoaderNum(Long loaderNum) {
        this.loaderNum = loaderNum;
    }

    @Generated
    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName;
    }

    @Generated
    public void setCompress(Boolean compress) {
        this.compress = compress;
    }

    @Generated
    public void setSts(String sts) {
        this.sts = sts;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public void setOccupy(Boolean occupy) {
        this.occupy = occupy;
    }

    @Generated
    public void setAccessMode(HwDriveAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Generated
    public void setExec(Long exec) {
        this.exec = exec;
    }

    @Generated
    public void setDone(Long done) {
        this.done = done;
    }

    @Generated
    public void setRun(Long run) {
        this.run = run;
    }

    @Generated
    public void setWaiting(Long waiting) {
        this.waiting = waiting;
    }

    @Generated
    public void setThroughput(Double throughput) {
        this.throughput = throughput;
    }

    @JsonIgnore
    @Generated
    public void setGroup(DriveGroups group) {
        this.group = group;
    }

    @Generated
    public void setSmsCnts(Long smsCnts) {
        this.smsCnts = smsCnts;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setLastLabel(String lastLabel) {
        this.lastLabel = lastLabel;
    }

    @Generated
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setMediaTimeout(Long mediaTimeout) {
        this.mediaTimeout = mediaTimeout;
    }

    @Generated
    public void setCleanBit(Boolean cleanBit) {
        this.cleanBit = cleanBit;
    }

    @Generated
    public void setLoaderDrive(Long loaderDrive) {
        this.loaderDrive = loaderDrive;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setDevicePath(String devicePath) {
        this.devicePath = devicePath;
    }

    @Generated
    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    @Generated
    public void setDataStore(String dataStore) {
        this.dataStore = dataStore;
    }

    @Generated
    public void setEjectFlag(Boolean ejectFlag) {
        this.ejectFlag = ejectFlag;
    }

    @Generated
    public void setMountCmd(String mountCmd) {
        this.mountCmd = mountCmd;
    }

    @Generated
    public void setUmountCmd(String umountCmd) {
        this.umountCmd = umountCmd;
    }

    @Generated
    public void setOnlineCmd(String onlineCmd) {
        this.onlineCmd = onlineCmd;
    }

    @Generated
    public void setLoadCmd(String loadCmd) {
        this.loadCmd = loadCmd;
    }

    @Generated
    public void setUnloadCmd(String unloadCmd) {
        this.unloadCmd = unloadCmd;
    }

    @Override
    @Generated
    public void setCredentialUuid(String credentialUuid) {
        this.credentialUuid = credentialUuid;
    }

    @Override
    @Generated
    public void setCredentialId(Long credentialId) {
        this.credentialId = credentialId;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setStorageServer(String storageServer) {
        this.storageServer = storageServer;
    }

    @Generated
    public void setEjectCmd(String ejectCmd) {
        this.ejectCmd = ejectCmd;
    }

    @Generated
    public void setBlockSize(Long blockSize) {
        this.blockSize = blockSize;
    }

    @Generated
    public void setDefaultBlockSize(Long defaultBlockSize) {
        this.defaultBlockSize = defaultBlockSize;
    }

    @Generated
    public void setSmsNr(Long smsNr) {
        this.smsNr = smsNr;
    }

    @Generated
    public void setSegmentSize(Long segmentSize) {
        this.segmentSize = segmentSize;
    }

    @Generated
    public void setListenPort(Long listenPort) {
        this.listenPort = listenPort;
    }

    @Generated
    public void setListenTlsPort(Long listenTlsPort) {
        this.listenTlsPort = listenTlsPort;
    }

    @Generated
    public void setListenAdminPort(Long listenAdminPort) {
        this.listenAdminPort = listenAdminPort;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setQmOptions(String qmOptions) {
        this.qmOptions = qmOptions;
    }

    @Generated
    public void setEncryptionCapable(Boolean encryptionCapable) {
        this.encryptionCapable = encryptionCapable;
    }

    @Generated
    public void setEncryptionPassword(String encryptionPassword) {
        this.encryptionPassword = encryptionPassword;
    }

    @Generated
    public void setPreviousPassword(String previousPassword) {
        this.previousPassword = previousPassword;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setConfigDrive(Boolean configDrive) {
        this.configDrive = configDrive;
    }

    @Generated
    public void setDsDriveMode(DSDriveMode dsDriveMode) {
        this.dsDriveMode = dsDriveMode;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @JsonIgnore
    @Generated
    public void setSkipAccessModeValidation(Boolean skipAccessModeValidation) {
        this.skipAccessModeValidation = skipAccessModeValidation;
    }

    @Generated
    public HwDrives() {
    }
}

