/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.dto.GroupsDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class Groups
extends AbstractModelEntity<Long>
implements ILongEntity,
IDisplayLabelProvider,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 974675297559506021L;
    @JsonIgnore
    private static final Comparator<Groups> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique ID of the group.", example="1")
    @NotNull
    private Long id;
    @Schema(description="The name of the group.", example="Administrators")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String name;
    @Schema(description="Flag to indicate if the group is enabled. If the group is disabled, users who belong to\nthis group only will not be able to log in.", example="true")
    @NotNull
    private Boolean enabled;
    @Schema(description="An internal comment for the group.", example="System-generated comment")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="A user-provided comment for the group.", example="Group for all company administrators")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The date and time when the group was last changed.", example="1720077461000")
    private Date dateChanged;
    @Schema(description="The date and time when the group was created.", example="1720077461000")
    private Date dateCreated;
    @Schema(description="The user who last changed the group.", example="admin")
    @Length(max=128)
    private @Length(max=128) String changedBy;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;
    @Schema(description="The list of users belonging to this group.", example="[\"admin\", \"user1\"]")
    private List<String> usersList;
    @Schema(description="The list of roles the group is associated with. When creating a new group, a role can\\n\" +\n\t\t\t\"be either presented by its ID or its name. The roles association can not be changed\\n\" +\n\t\t\t\"after the creation of the group! Valid values are \u2018SuperUser\u2019, \u2018All\u2019 (Administrator),\\n\" +\n\t\t\t\"\u2018Disabled\u2019, \u2018ReadOnly\u2019 (Operator), \u2018Restore\u2019 and \u2018Backup\u2019.", example="[\"ADMINISTRATOR\", \"OPERATOR\"]")
    private List<String> rolesList;

    @JsonIgnore
    public static Comparator<Groups> sorter() {
        return comparator;
    }

    public Groups(GroupsDto dto) {
        assert (dto != null);
        this.setId(dto.getId());
        this.setName(dto.getName());
        this.setEnabled(dto.getEnabled());
        this.setSepcomment(dto.getSepcomment());
        this.setUsercomment(dto.getUsercomment());
        this.setDateChanged(dto.getDateChanged());
        this.setDateCreated(dto.getDateCreated());
        this.setChangedBy(dto.getChangedBy());
        this.mtime = dto.getMtime();
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        String s = I18n.get("Label.Group" + WordUtils.capitalizeFully(this.name), new Object[0]);
        if (!StringUtils.startsWith(s, "!") && !StringUtils.startsWith(s, "!")) {
            return s;
        }
        return this.name;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Date getDateChanged() {
        return this.dateChanged;
    }

    @Generated
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Generated
    public String getChangedBy() {
        return this.changedBy;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setDateChanged(Date dateChanged) {
        this.dateChanged = dateChanged;
    }

    @Generated
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Generated
    public void setChangedBy(String changedBy) {
        this.changedBy = changedBy;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Groups() {
    }

    @Generated
    public List<String> getUsersList() {
        return this.usersList;
    }

    @Generated
    public void setUsersList(List<String> usersList) {
        this.usersList = usersList;
    }

    @Generated
    public void setRolesList(List<String> rolesList) {
        this.rolesList = rolesList;
    }

    @Generated
    public List<String> getRolesList() {
        return this.rolesList;
    }
}

