/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.ExternalGroupRelations;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.ExternalGroupsType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class ExternalGroups
extends AbstractModelEntity<Long>
implements IDisplayLabelProvider,
ILongEntity,
MtimeEntity<Long> {
    @JsonIgnore
    private static final long serialVersionUID = 2616225933727362285L;
    @JsonIgnore
    private static final Comparator<ExternalGroups> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getExternalId() == null && o2 != null && o2.getExternalId() == null) {
            return 0;
        }
        if (o1 == null || o1.getExternalId() == null) {
            return -1;
        }
        if (o2 == null || o2.getExternalId() == null) {
            return 1;
        }
        return o1.getExternalId().compareTo(o2.getExternalId());
    };
    @Schema(description="The unique ID of the external group.", example="1")
    @NotNull
    private Long id;
    @Schema(description="The identifier of the group in the external directory service (e.g., AD or LDAP).", example="CN=Domain Admins,CN=Users,DC=example,DC=com")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String externalId;
    @Schema(description="Indicates whether the external group is enabled for synchronization.", example="true")
    @NotNull
    private Boolean enabled;
    @Schema(description="A user-provided comment for the external group.", example="Active Directory administrators group")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;
    @Schema(description="The type of the external directory service.", example="AD")
    private ExternalGroupsType type;
    @JsonIgnore
    private List<ExternalGroupRelations> relations;

    @JsonIgnore
    public static Comparator<ExternalGroups> sorter() {
        return comparator;
    }

    public ExternalGroups(String externalId) {
        this.externalId = externalId;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.externalId;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public ExternalGroupsType getType() {
        return this.type;
    }

    @Generated
    public List<ExternalGroupRelations> getRelations() {
        return this.relations;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setType(ExternalGroupsType type) {
        this.type = type;
    }

    @JsonIgnore
    @Generated
    public void setRelations(List<ExternalGroupRelations> relations) {
        this.relations = relations;
    }

    @Generated
    public ExternalGroups() {
    }
}

