/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.Groups;
import de.sep.sesam.model.annotations.SesamParameter;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class ExternalGroupRelations
extends AbstractModelEntity<Long>
implements ILongEntity,
MtimeEntity<Long>,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = 2616225933727362285L;
    @JsonIgnore
    private static final Comparator<ExternalGroupRelations> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getExternalGroupId() == null && o2 != null && o2.getExternalGroupId() == null) {
            return 0;
        }
        if (o1 == null || o1.getExternalGroupId() == null) {
            return -1;
        }
        if (o2 == null || o2.getExternalGroupId() == null) {
            return 1;
        }
        return o1.getExternalGroupId().compareTo(o2.getExternalGroupId());
    };
    @Schema(description="The unique ID of the group relation.", example="1")
    @NotNull
    private Long id;
    @Schema(description="The ID of the UI group.", example="101")
    @NotNull
    private Long groupId;
    @JsonIgnore
    private Groups group;
    @Schema(description="The ID of the external group.", example="202")
    @NotNull
    @SesamParameter(target="ui_external_group_id")
    private Long externalGroupId;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;
    @Schema(description="The unique identifier (UUID) for the group relation.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    @Length(max=40)
    private @Length(max=40) String uuid;

    @JsonIgnore
    public static Comparator<ExternalGroupRelations> sorter() {
        return comparator;
    }

    @JsonIgnore
    public Groups getGroup() {
        return this.group;
    }

    @JsonIgnore
    public void setGroup(Groups group) {
        this.group = group;
    }

    @Override
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.group != null ? this.group.getDisplayLabel() : "";
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getGroupId() {
        return this.groupId;
    }

    @Generated
    public Long getExternalGroupId() {
        return this.externalGroupId;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setExternalGroupId(Long externalGroupId) {
        this.externalGroupId = externalGroupId;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public ExternalGroupRelations() {
    }
}

