/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class DriveTypes
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
INamedEntity,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = 379480433316111455L;
    @JsonIgnore
    private static final Comparator<DriveTypes> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @JsonIgnore
    public static final String DISK_STORE = "DISK_STORE";
    @JsonIgnore
    public static final String SNAP_STORE = "SNAP_STORE";
    @Schema(description="The name of the drive type.", example="LTO-8")
    @NotNull
    @Length(max=15)
    private @NotNull @Length(max=15) String name;
    @Schema(description="The generic type of the drive, e.g., TAPE.", example="TAPE")
    @NotNull
    @Length(max=10)
    private @NotNull @Length(max=10) String genericType;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<DriveTypes> sorter() {
        return comparator;
    }

    public DriveTypes(String name) {
        this.name = name;
    }

    @JsonIgnore
    public boolean isDiskStore() {
        return StringUtils.equals(this.name, DISK_STORE);
    }

    @JsonIgnore
    public boolean isDisk() {
        return StringUtils.startsWith(this.name, "DISK_");
    }

    @JsonIgnore
    public boolean isDiskHard() {
        return StringUtils.equals(this.name, "DISK_HARD");
    }

    @JsonIgnore
    public boolean isDiskChange() {
        return StringUtils.equals(this.name, "DISK_CHNG");
    }

    @JsonIgnore
    public boolean isSnap() {
        return StringUtils.equals(this.genericType, "SNAP");
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getGenericType() {
        return this.genericType;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setGenericType(String genericType) {
        this.genericType = genericType;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public DriveTypes() {
    }
}

