/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.HwDrives;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.SmsFlag;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;

public class DriveGroups
extends AbstractModelEntity<Long>
implements ILongEntity,
IDisplayLabelProvider,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -7665992137407483055L;
    @JsonIgnore
    private static final Comparator<DriveGroups> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique ID of the drive group.", example="10")
    private Long id;
    @Schema(description="The name of the drive group. It can only contain alphanumeric characters, underscores, and hyphens.", example="Tape-Group-01")
    @Length(max=50)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    private @Length(max=50) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @Schema(description="The flag indicating the type of storage management system. 'S' for SEP sesam, 'N' for NDMP.", example="S")
    private SmsFlag smsFlag = SmsFlag.SESAM;
    @Schema(description="The default network interface used by the drives in this group.", example="eth0")
    private String defaultInterface;
    @Schema(description="The list of hardware drives that are part of this drive group.")
    private List<HwDrives> drives = new ArrayList<HwDrives>();
    @Schema(description="Indicates whether the drives in the group are capable of encryption.", example="true")
    private Boolean encryptionCapable;
    @Schema(description="A user-provided comment for the drive group.", example="Primary tape library for production backups.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<DriveGroups> sorter() {
        return comparator;
    }

    public DriveGroups(Long id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public SmsFlag getSmsFlag() {
        return this.smsFlag;
    }

    @Generated
    public String getDefaultInterface() {
        return this.defaultInterface;
    }

    @Generated
    public List<HwDrives> getDrives() {
        return this.drives;
    }

    @Generated
    public Boolean getEncryptionCapable() {
        return this.encryptionCapable;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSmsFlag(SmsFlag smsFlag) {
        this.smsFlag = smsFlag;
    }

    @Generated
    public void setDefaultInterface(String defaultInterface) {
        this.defaultInterface = defaultInterface;
    }

    @Generated
    public void setDrives(List<HwDrives> drives) {
        this.drives = drives;
    }

    @Generated
    public void setEncryptionCapable(Boolean encryptionCapable) {
        this.encryptionCapable = encryptionCapable;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public DriveGroups() {
    }
}

