/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.DataStoreTypes;
import de.sep.sesam.model.MediaPools;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.ICredentialsProvider;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.DSDriveMode;
import de.sep.sesam.model.core.types.StorageWizardSubType;
import de.sep.sesam.model.core.types.StorageWizardType;
import de.sep.sesam.model.type.DatastoreCalculation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;

public class DataStores
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity,
ICredentialsProvider {
    @JsonIgnore
    private static final long serialVersionUID = 4747335575231570954L;
    @JsonIgnore
    private static final Comparator<DataStores> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique name of the data store.", example="MyDataStore")
    @NotNull
    @Length(max=32)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    private @NotNull @Length(max=32) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @Schema(description="An internal SEP comment about the data store.", example="Primary storage for production backups.")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="A user-provided comment about the data store.", example="Used for daily file server backups.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Configuration options for the data store.", example="ENCRYPTION=true;DEDUPLICATION=true")
    @Length(max=1024)
    private @Length(max=1024) String options;
    @Schema(description="The identifier for the type of data store.", example="PATH")
    @Length(max=64)
    private @Length(max=64) String typeId;
    @JsonIgnore
    private DataStoreTypes type;
    @Schema(description="The main type identifier for the storage wizard.", example="DISK_STORAGE")
    private StorageWizardType wizardType;
    @Schema(description="The subtype identifier for the storage wizard.", example="LOCAL_DISK")
    private StorageWizardSubType wizardSubType;
    @Schema(description="The calculation mode for data store metrics.", example="STANDARD")
    @Length(max=64)
    private @Length(max=64) DatastoreCalculation calculation;
    @Schema(description="The ID of the credentials used to access the data store.", example="101")
    private Long credentialId;
    @Schema(description="The name or ID of the credentials. Used for convenience, especially in CLI.", example="MyS3Credentials")
    private String credentialIdName;
    @Schema(description="The total capacity of the data store in bytes.", example="1099511627776")
    private Double capacity;
    @Schema(description="The low water mark for the data store usage in percent.", example="10.0")
    private Double lowWaterMark;
    @Schema(description="The high water mark for the data store usage in percent.", example="90.0")
    private Double highWaterMark;
    @Schema(description="The minimum free space required in the data store in bytes.", example="53687091200")
    private Double minFree;
    @Schema(description="The percentage of the data store that is filled.", example="75.5")
    private Double filled;
    @Schema(description="The amount of data stored in bytes, after deduplication and compression.", example="829352229273")
    private Double stored;
    @Schema(description="The amount of data in the trash waiting for garbage collection, in bytes.", example="10737418240")
    private Double trash;
    @Schema(description="The total size of the data store in bytes (may differ from capacity).", example="1099511627776")
    private Double total;
    @Schema(description="The amount of used space in the data store in bytes.", example="829352229273")
    private Double used;
    @Schema(description="The amount of free space in the data store in bytes.", example="270159398503")
    private Double free;
    @Schema(description="A description of the last action performed on the data store.", example="Garbage collection successful.")
    @Length(max=255)
    private @Length(max=255) String lastAction;
    @Schema(description="The timestamp of the last status update.", example="1720077461000")
    private Date timestamp;
    @Schema(description="The access mode of the data store (e.g., READ_WRITE).", example="READ_WRITE")
    @Length(max=255)
    private @Length(max=255) String accessMode;
    @Schema(description="Execution flag or status for the data store.", example="1")
    private Long exec;
    @Schema(description="The current operational status of the data store.", example="OK")
    @Length(max=255)
    private @Length(max=255) String status;
    @Schema(description="A status message associated with the data store.", example="Data store is online and operating normally.")
    @Length(max=1024)
    private @Length(max=1024) String message;
    @Schema(description="A message related to deduplication status.", example="Deduplication ratio is 2.5:1.")
    @Length(max=8192)
    private @Length(max=8192) String dedupMessage;
    @Schema(description="The status of the clone operation (e.g., 'I' for in-progress, 'D' for done).", example="D")
    @Length(max=2)
    private @Length(max=2) String cloneStatus;
    @Schema(description="A message associated with the clone operation.", example="Cloning completed successfully.")
    @Length(max=1024)
    private @Length(max=1024) String cloneMessage;
    @Schema(description="The timestamp of the last clone operation.", example="1720077461000")
    private Date cloneTime;
    @Schema(description="The status of the disk (e.g., 'OK', 'ER' for error).", example="OK")
    @Length(max=2)
    private @Length(max=2) String diskStatus;
    @Schema(description="A message associated with the disk status.", example="All disks are healthy.")
    @Length(max=1024)
    private @Length(max=1024) String diskMessage;
    @Schema(description="The status of the garbage collection (GC) process.", example="D")
    @Length(max=2)
    private @Length(max=2) String gcStatus;
    @Schema(description="A message associated with the garbage collection process.", example="GC reclaimed 10GiB.")
    @Length(max=1024)
    private @Length(max=1024) String gcMessage;
    @Schema(description="The start time of the last garbage collection.", example="1720070000000")
    private Date gcStartTime;
    @Schema(description="The stop time of the last garbage collection.", example="1720071800000")
    private Date gcStopTime;
    @Schema(description="The status of the file system check (fsck) process.", example="D")
    @Length(max=2)
    private @Length(max=2) String fsckStatus;
    @Schema(description="A message associated with the file system check process.", example="No inconsistencies found.")
    @Length(max=1024)
    private @Length(max=1024) String fsckMessage;
    @Schema(description="The start time of the last file system check.", example="1720060000000")
    private Date fsckStartTime;
    @Schema(description="The stop time of the last file system check.", example="1720061800000")
    private Date fsckStopTime;
    @Schema(description="The timestamp of the last full file system check.", example="1719061800000")
    private Date fsckFullTime;
    @Schema(description="The status of the read check process.", example="D")
    @Length(max=2)
    private @Length(max=2) String readcheckStatus;
    @Schema(description="A message associated with the read check process.", example="All data is readable.")
    @Length(max=1024)
    private @Length(max=1024) String readcheckMessage;
    @Schema(description="The start time of the last read check.", example="1720050000000")
    private Date readcheckStartTime;
    @Schema(description="The stop time of the last read check.", example="1720051800000")
    private Date readcheckStopTime;
    @Schema(description="The status of the sanity check.", example="OK")
    @Length(max=2)
    private @Length(max=2) String sanityStatus;
    @Schema(description="A message associated with the sanity check.", example="Sanity check passed.")
    @Length(max=1024)
    private @Length(max=1024) String sanityMessage;
    @Schema(description="The timestamp of the last sanity check.", example="1720077000000")
    private Date sanityTime;
    @Schema(description="The name of the replication store.", example="ReplicationDataStore")
    @Length(max=32)
    private @Length(max=32) String replicationStoreId;
    @Schema(description="The end-of-life for retention, as a Unix timestamp.", example="1751613461000")
    private Long retentionEol;
    @Schema(description="Flags for the retention policy.", example="KEEP_FOREVER")
    @Length(max=255)
    private @Length(max=255) String retentionFlags;
    @Schema(description="The timestamp when the data store was created.", example="1710077461000")
    private Date creationTime;
    @Schema(description="The timestamp of the last modification.", example="1720077461000")
    private Date mtime;
    @Schema(description="The unique identifier (UUID) for the data store.", example="223e4567-e89b-12d3-a456-426614174001")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @Schema(description="The name of the associated sesam server.", example="main-sesam-server")
    private String sesamServer;
    @Schema(description="Default path for new drives in the data store. Internal use only.", example="/mnt/backups/datastore")
    private String path;
    @Schema(description="Default number of channels for new drives. Internal use only.", example="4")
    private Long smsCnts;
    @Schema(description="If true, a drive configuration is executed after data store persistence.", example="true", defaultValue="true")
    private Boolean configDrive = Boolean.TRUE;
    @Schema(description="The configuration mode for 'sm_config_drives'.", example="CREATE")
    private DSDriveMode dsDriveMode;
    @Schema(description="Indicates if the number of drives has changed, to trigger drive reconfiguration.", example="true")
    private boolean countOfDrivesChanged;
    @Schema(description="Indicates if credentials have changed, to trigger drive reconfiguration.", example="false")
    private boolean credentialsChanged;
    @Schema(description="Flag to force creation even if the path already exists.", example="false")
    private Boolean forceCreate;
    @Schema(description="A snapshot list of media pools associated with this data store. For display only.")
    private List<MediaPools> pools;

    @JsonIgnore
    public static Comparator<DataStores> sorter() {
        return comparator;
    }

    public String getTypeId() {
        if (this.typeId == null && this.type != null) {
            return this.type.getPK();
        }
        return this.typeId;
    }

    public boolean isPositive() {
        return this.getHighWaterMark() != null && this.getHighWaterMark() > 0.0 && this.getCapacity() != null && this.getCapacity() > 0.0 && this.getLowWaterMark() != null && this.getLowWaterMark() >= 0.0;
    }

    public Double getDedup() {
        return this.getFilled() != null && this.getStored() != null && !this.getFilled().isNaN() && !this.getStored().isNaN() && !this.getStored().equals(0.0) ? this.getFilled() / this.getStored() : 0.0;
    }

    @Override
    public String getCredentialUuid() {
        return this.uuid;
    }

    @Override
    public void setCredentialUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setCredentialIdName(String credentialIdName) {
        try {
            this.credentialId = Long.parseLong(credentialIdName);
        }
        catch (NumberFormatException e) {
            this.credentialIdName = credentialIdName;
        }
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    public DataStores(String string) {
        this.name = string;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public DataStoreTypes getType() {
        return this.type;
    }

    @Generated
    public StorageWizardType getWizardType() {
        return this.wizardType;
    }

    @Generated
    public StorageWizardSubType getWizardSubType() {
        return this.wizardSubType;
    }

    @Generated
    public DatastoreCalculation getCalculation() {
        return this.calculation;
    }

    @Override
    @Generated
    public Long getCredentialId() {
        return this.credentialId;
    }

    @Generated
    public String getCredentialIdName() {
        return this.credentialIdName;
    }

    @Generated
    public Double getCapacity() {
        return this.capacity;
    }

    @Generated
    public Double getLowWaterMark() {
        return this.lowWaterMark;
    }

    @Generated
    public Double getHighWaterMark() {
        return this.highWaterMark;
    }

    @Generated
    public Double getMinFree() {
        return this.minFree;
    }

    @Generated
    public Double getFilled() {
        return this.filled;
    }

    @Generated
    public Double getStored() {
        return this.stored;
    }

    @Generated
    public Double getTrash() {
        return this.trash;
    }

    @Generated
    public Double getTotal() {
        return this.total;
    }

    @Generated
    public Double getUsed() {
        return this.used;
    }

    @Generated
    public Double getFree() {
        return this.free;
    }

    @Generated
    public String getLastAction() {
        return this.lastAction;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getAccessMode() {
        return this.accessMode;
    }

    @Generated
    public Long getExec() {
        return this.exec;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getDedupMessage() {
        return this.dedupMessage;
    }

    @Generated
    public String getCloneStatus() {
        return this.cloneStatus;
    }

    @Generated
    public String getCloneMessage() {
        return this.cloneMessage;
    }

    @Generated
    public Date getCloneTime() {
        return this.cloneTime;
    }

    @Generated
    public String getDiskStatus() {
        return this.diskStatus;
    }

    @Generated
    public String getDiskMessage() {
        return this.diskMessage;
    }

    @Generated
    public String getGcStatus() {
        return this.gcStatus;
    }

    @Generated
    public String getGcMessage() {
        return this.gcMessage;
    }

    @Generated
    public Date getGcStartTime() {
        return this.gcStartTime;
    }

    @Generated
    public Date getGcStopTime() {
        return this.gcStopTime;
    }

    @Generated
    public String getFsckStatus() {
        return this.fsckStatus;
    }

    @Generated
    public String getFsckMessage() {
        return this.fsckMessage;
    }

    @Generated
    public Date getFsckStartTime() {
        return this.fsckStartTime;
    }

    @Generated
    public Date getFsckStopTime() {
        return this.fsckStopTime;
    }

    @Generated
    public Date getFsckFullTime() {
        return this.fsckFullTime;
    }

    @Generated
    public String getReadcheckStatus() {
        return this.readcheckStatus;
    }

    @Generated
    public String getReadcheckMessage() {
        return this.readcheckMessage;
    }

    @Generated
    public Date getReadcheckStartTime() {
        return this.readcheckStartTime;
    }

    @Generated
    public Date getReadcheckStopTime() {
        return this.readcheckStopTime;
    }

    @Generated
    public String getSanityStatus() {
        return this.sanityStatus;
    }

    @Generated
    public String getSanityMessage() {
        return this.sanityMessage;
    }

    @Generated
    public Date getSanityTime() {
        return this.sanityTime;
    }

    @Generated
    public String getReplicationStoreId() {
        return this.replicationStoreId;
    }

    @Generated
    public Long getRetentionEol() {
        return this.retentionEol;
    }

    @Generated
    public String getRetentionFlags() {
        return this.retentionFlags;
    }

    @Generated
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getSesamServer() {
        return this.sesamServer;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Long getSmsCnts() {
        return this.smsCnts;
    }

    @Generated
    public Boolean getConfigDrive() {
        return this.configDrive;
    }

    @Generated
    public DSDriveMode getDsDriveMode() {
        return this.dsDriveMode;
    }

    @Generated
    public boolean isCountOfDrivesChanged() {
        return this.countOfDrivesChanged;
    }

    @Generated
    public boolean isCredentialsChanged() {
        return this.credentialsChanged;
    }

    @Generated
    public Boolean getForceCreate() {
        return this.forceCreate;
    }

    @Generated
    public List<MediaPools> getPools() {
        return this.pools;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @JsonIgnore
    @Generated
    public void setType(DataStoreTypes type) {
        this.type = type;
    }

    @Generated
    public void setWizardType(StorageWizardType wizardType) {
        this.wizardType = wizardType;
    }

    @Generated
    public void setWizardSubType(StorageWizardSubType wizardSubType) {
        this.wizardSubType = wizardSubType;
    }

    @Generated
    public void setCalculation(DatastoreCalculation calculation) {
        this.calculation = calculation;
    }

    @Override
    @Generated
    public void setCredentialId(Long credentialId) {
        this.credentialId = credentialId;
    }

    @Generated
    public void setCapacity(Double capacity) {
        this.capacity = capacity;
    }

    @Generated
    public void setLowWaterMark(Double lowWaterMark) {
        this.lowWaterMark = lowWaterMark;
    }

    @Generated
    public void setHighWaterMark(Double highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    @Generated
    public void setMinFree(Double minFree) {
        this.minFree = minFree;
    }

    @Generated
    public void setFilled(Double filled) {
        this.filled = filled;
    }

    @Generated
    public void setStored(Double stored) {
        this.stored = stored;
    }

    @Generated
    public void setTrash(Double trash) {
        this.trash = trash;
    }

    @Generated
    public void setTotal(Double total) {
        this.total = total;
    }

    @Generated
    public void setUsed(Double used) {
        this.used = used;
    }

    @Generated
    public void setFree(Double free) {
        this.free = free;
    }

    @Generated
    public void setLastAction(String lastAction) {
        this.lastAction = lastAction;
    }

    @Generated
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setAccessMode(String accessMode) {
        this.accessMode = accessMode;
    }

    @Generated
    public void setExec(Long exec) {
        this.exec = exec;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setDedupMessage(String dedupMessage) {
        this.dedupMessage = dedupMessage;
    }

    @Generated
    public void setCloneStatus(String cloneStatus) {
        this.cloneStatus = cloneStatus;
    }

    @Generated
    public void setCloneMessage(String cloneMessage) {
        this.cloneMessage = cloneMessage;
    }

    @Generated
    public void setCloneTime(Date cloneTime) {
        this.cloneTime = cloneTime;
    }

    @Generated
    public void setDiskStatus(String diskStatus) {
        this.diskStatus = diskStatus;
    }

    @Generated
    public void setDiskMessage(String diskMessage) {
        this.diskMessage = diskMessage;
    }

    @Generated
    public void setGcStatus(String gcStatus) {
        this.gcStatus = gcStatus;
    }

    @Generated
    public void setGcMessage(String gcMessage) {
        this.gcMessage = gcMessage;
    }

    @Generated
    public void setGcStartTime(Date gcStartTime) {
        this.gcStartTime = gcStartTime;
    }

    @Generated
    public void setGcStopTime(Date gcStopTime) {
        this.gcStopTime = gcStopTime;
    }

    @Generated
    public void setFsckStatus(String fsckStatus) {
        this.fsckStatus = fsckStatus;
    }

    @Generated
    public void setFsckMessage(String fsckMessage) {
        this.fsckMessage = fsckMessage;
    }

    @Generated
    public void setFsckStartTime(Date fsckStartTime) {
        this.fsckStartTime = fsckStartTime;
    }

    @Generated
    public void setFsckStopTime(Date fsckStopTime) {
        this.fsckStopTime = fsckStopTime;
    }

    @Generated
    public void setFsckFullTime(Date fsckFullTime) {
        this.fsckFullTime = fsckFullTime;
    }

    @Generated
    public void setReadcheckStatus(String readcheckStatus) {
        this.readcheckStatus = readcheckStatus;
    }

    @Generated
    public void setReadcheckMessage(String readcheckMessage) {
        this.readcheckMessage = readcheckMessage;
    }

    @Generated
    public void setReadcheckStartTime(Date readcheckStartTime) {
        this.readcheckStartTime = readcheckStartTime;
    }

    @Generated
    public void setReadcheckStopTime(Date readcheckStopTime) {
        this.readcheckStopTime = readcheckStopTime;
    }

    @Generated
    public void setSanityStatus(String sanityStatus) {
        this.sanityStatus = sanityStatus;
    }

    @Generated
    public void setSanityMessage(String sanityMessage) {
        this.sanityMessage = sanityMessage;
    }

    @Generated
    public void setSanityTime(Date sanityTime) {
        this.sanityTime = sanityTime;
    }

    @Generated
    public void setReplicationStoreId(String replicationStoreId) {
        this.replicationStoreId = replicationStoreId;
    }

    @Generated
    public void setRetentionEol(Long retentionEol) {
        this.retentionEol = retentionEol;
    }

    @Generated
    public void setRetentionFlags(String retentionFlags) {
        this.retentionFlags = retentionFlags;
    }

    @Generated
    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setSesamServer(String sesamServer) {
        this.sesamServer = sesamServer;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setSmsCnts(Long smsCnts) {
        this.smsCnts = smsCnts;
    }

    @Generated
    public void setConfigDrive(Boolean configDrive) {
        this.configDrive = configDrive;
    }

    @Generated
    public void setDsDriveMode(DSDriveMode dsDriveMode) {
        this.dsDriveMode = dsDriveMode;
    }

    @Generated
    public void setCountOfDrivesChanged(boolean countOfDrivesChanged) {
        this.countOfDrivesChanged = countOfDrivesChanged;
    }

    @Generated
    public void setCredentialsChanged(boolean credentialsChanged) {
        this.credentialsChanged = credentialsChanged;
    }

    @Generated
    public void setForceCreate(Boolean forceCreate) {
        this.forceCreate = forceCreate;
    }

    @Generated
    public void setPools(List<MediaPools> pools) {
        this.pools = pools;
    }

    @Generated
    public DataStores() {
    }
}

