/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.DatastoreGenericType;
import java.util.Comparator;
import java.util.Date;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class DataStoreTypes
extends AbstractModelEntity<String>
implements IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 9063148193000196435L;
    @JsonIgnore
    public static final String SEP_SI3 = "SEP Si3";
    @JsonIgnore
    private static final String SEP_SI3_NG = "SEP Si3 NG";
    @JsonIgnore
    public static final String SEP_SI3_DEDUP_STORE = "SEP Si3 Deduplication Store";
    @JsonIgnore
    public static final String SEP_SI3_NG_DEDUP_STORE = "SEP Si3 NG Deduplication Store";
    @JsonIgnore
    public static final String PATH = "Path";
    @JsonIgnore
    public static final String SEP_EASYARCHIVE = "SEP EasyArchive";
    @JsonIgnore
    public static final String NETAPP_SNAP_STORE = "NetApp Snap Store";
    @JsonIgnore
    public static final String HPE = "HPE StoreOnce";
    @JsonIgnore
    public static final String HPE_CLOUD_BANK = "HPE Cloud Bank Store";
    @JsonIgnore
    public static final String SESAM = "Meta-Server-Data";
    @JsonIgnore
    private static final Comparator<DataStoreTypes> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String name;
    @NotNull
    private DatastoreGenericType genericType;
    @Length(max=64)
    private @Length(max=64) String vendorType;
    private Date mtime;

    @JsonIgnore
    public static Comparator<DataStoreTypes> sorter() {
        return comparator;
    }

    public DataStoreTypes() {
    }

    public DataStoreTypes(String name) {
        assert (name != null);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public DatastoreGenericType getGenericType() {
        return this.genericType;
    }

    public void setGenericType(DatastoreGenericType genericType) {
        this.genericType = genericType;
    }

    public String getVendorType() {
        return this.vendorType;
    }

    public void setVendorType(String vendorType) {
        this.vendorType = vendorType == null ? null : vendorType.trim();
    }

    @Override
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @JsonIgnore
    public boolean isSepSI3() {
        return StringUtils.startsWith(this.name, SEP_SI3);
    }

    @JsonIgnore
    public boolean isSepSI3NG() {
        return StringUtils.startsWith(this.name, SEP_SI3_NG);
    }

    @JsonIgnore
    public boolean isNetappSnapStore() {
        return StringUtils.equals(this.name, NETAPP_SNAP_STORE);
    }

    @JsonIgnore
    public boolean isHPEStore() {
        return StringUtils.equals(this.name, HPE);
    }

    @JsonIgnore
    public boolean isHPECloudBankStore() {
        return StringUtils.equals(this.name, HPE_CLOUD_BANK);
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        if (StringUtils.equals(this.name, SEP_SI3_NG_DEDUP_STORE)) {
            return SEP_SI3_DEDUP_STORE;
        }
        if (StringUtils.equals(this.name, SEP_SI3_DEDUP_STORE)) {
            return "SEP Si3 V1 Deduplication Store";
        }
        return this.name;
    }
}

