/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.credentials.dto.CredentialsKeyDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Credentials
extends AbstractModelEntity<Long>
implements ILongEntity,
IDisplayLabelProvider,
MtimeEntity<Long>,
INamedEntity {
    private static final long serialVersionUID = -2062962784498132592L;
    @JsonIgnore
    private static final Comparator<Credentials> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @JsonIgnore
    private static final Comparator<Credentials> rankComparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null || o1.getRank() == null) {
            return -1;
        }
        if (o2 == null || o2.getRank() == null) {
            return 1;
        }
        return o1.getRank().compareTo(o2.getRank());
    };
    @Schema(description="The unique ID of the credentials.", example="1")
    @NotNull
    private Long id;
    @Schema(description="The name of the credentials.", example="My-S3-Bucket-Access")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String name;
    @Schema(description="The type of the credentials.", example="AMAZON_AWS")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String type;
    @Schema(description="Indicates whether the credentials are enabled.", example="true")
    private Boolean enabled;
    @Schema(description="The access name or username for the credentials.", example="AKIAIOSFODNN7EXAMPLE")
    @Length(max=255)
    private @Length(max=255) String accessName;
    @Schema(description="The operating system username, if applicable.", example="root")
    @Length(max=255)
    private @Length(max=255) String osAccessName;
    @Schema(description="The secret or password associated with the credentials.", example="wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY")
    @Length(max=2048)
    private @Length(max=2048) String secret;
    @Schema(description="The private key for authentication.", example="-----BEGIN RSA PRIVATE KEY-----\\n...\\n-----END RSA PRIVATE KEY-----")
    @Length(max=8192)
    private @Length(max=8192) String privateKey;
    @Schema(description="The public key for authentication.", example="-----BEGIN PUBLIC KEY-----\\n...\\n-----END PUBLIC KEY-----")
    @Length(max=8192)
    private @Length(max=8192) String publicKey;
    @Schema(description="The hostname of the target system.", example="s3.eu-central-1.amazonaws.com")
    @Length(max=255)
    private @Length(max=255) String hostname;
    @Schema(description="The port number for connecting to the host.", example="443")
    private Long port;
    @Schema(description="The name of the store, e.g., a keystore name.", example="my_keystore")
    @Length(max=255)
    private @Length(max=255) String storeName;
    @Schema(description="The path to a relevant resource or file.", example="/credentials/store")
    @Length(max=4096)
    private @Length(max=4096) String path;
    @Schema(description="A user-provided comment for the credentials.", example="Credentials for accessing the primary S3 storage.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The rank or priority of these credentials.", example="1")
    private Long rank;
    @Schema(description="The timestamp of the last modification of the record.", example="1720077461000")
    private Date mtime;
    @Schema(description="DTO that contains the public key file.")
    private CredentialsKeyDto publicKeyFile;
    @Schema(description="DTO that contains the private key file.")
    private CredentialsKeyDto privateKeyFile;
    @Schema(description="The unique identifier (UUID) for the credentials.", example="123e4567-e89b-12d3-a456-426614174000")
    @Length(max=40)
    private @Length(max=40) String uuid;

    @JsonIgnore
    public static Comparator<Credentials> sorter() {
        return comparator;
    }

    @JsonIgnore
    public static Comparator<Credentials> rankSorter() {
        return rankComparator;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public String getAccessName() {
        return this.accessName;
    }

    @Generated
    public String getOsAccessName() {
        return this.osAccessName;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public Long getPort() {
        return this.port;
    }

    @Generated
    public String getStoreName() {
        return this.storeName;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Long getRank() {
        return this.rank;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public CredentialsKeyDto getPublicKeyFile() {
        return this.publicKeyFile;
    }

    @Generated
    public CredentialsKeyDto getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setAccessName(String accessName) {
        this.accessName = accessName;
    }

    @Generated
    public void setOsAccessName(String osAccessName) {
        this.osAccessName = osAccessName;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Generated
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setPort(Long port) {
        this.port = port;
    }

    @Generated
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setRank(Long rank) {
        this.rank = rank;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setPublicKeyFile(CredentialsKeyDto publicKeyFile) {
        this.publicKeyFile = publicKeyFile;
    }

    @Generated
    public void setPrivateKeyFile(CredentialsKeyDto privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public Credentials() {
    }
}

