/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.CommandType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;

public class Commands
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = -4286466550782755408L;
    @JsonIgnore
    private static final Comparator<Commands> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The name of the command.", example="mein_benutzerdefinierter_befehl")
    @NotNull
    @Length(max=64)
    @MatchPattern(pattern={"^[@a-zA-Z0-9_-]*$"})
    private @NotNull @Length(max=64) @MatchPattern(pattern={"^[@a-zA-Z0-9_-]*$"}) String name;
    @Schema(description="The owner of the command", example="admin", defaultValue="-")
    @NotNull
    @Length(max=30)
    private @NotNull @Length(max=30) String owner = "-";
    @Schema(description="The type of the command", example="X", defaultValue="EXECUTE")
    @NotNull
    private CommandType type = CommandType.EXECUTE;
    @Schema(description="The name of the client, on which the command should be executed.", example="client2.domain.com")
    @Length(max=512)
    private @Length(max=512) String host;
    @Schema(description="The name of the user account which is used to execute the command.", example="root")
    @Length(max=255)
    private @Length(max=255) String userName;
    @Schema(description="The actual command.", example="test")
    @NotNull
    @Length(max=2048)
    private @NotNull @Length(max=2048) String command;
    @Schema(description="The abortion command.", example="send_die.sh $PID $CMD")
    @Length(max=2048)
    private @Length(max=2048) String abortCommand;
    @Schema(description="The exit option", example="Exit Options")
    @Length(max=64)
    private @Length(max=64) String exitOptions;
    @Schema(description="The Options.", example="DB2_KRI")
    @Length(max=1024)
    private @Length(max=1024) String options;
    @Schema(description="The server options.", example="--retry=3")
    @Length(max=1024)
    private @Length(max=1024) String serverOptions;
    @Schema(description="The comment or note from Sesam.", example="Test note")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="The comment or note from the user.", example="Test comment")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The time stamp of the last change", example="1720077461000")
    private Date mtime;
    @Schema(description="The duration of the command in seconds.", example="30")
    public String duration;
    @Schema(description="The lifetime of the command in seconds.", example="100000000")
    private String lifetime;

    @JsonIgnore
    public static Comparator<Commands> sorter() {
        return comparator;
    }

    public Commands(String name) {
        this.name = name;
    }

    public Commands(Commands other) {
        assert (other != null);
        this.name = other.name;
        this.owner = other.owner;
        this.command = other.command;
        this.abortCommand = other.abortCommand;
        this.host = other.host;
        this.type = other.type;
        this.userName = other.userName;
        this.options = other.options;
        this.duration = other.duration;
        this.lifetime = other.lifetime;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public CommandType getType() {
        return this.type;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public String getAbortCommand() {
        return this.abortCommand;
    }

    @Generated
    public String getExitOptions() {
        return this.exitOptions;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getServerOptions() {
        return this.serverOptions;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getDuration() {
        return this.duration;
    }

    @Generated
    public String getLifetime() {
        return this.lifetime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setType(CommandType type) {
        this.type = type;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    @Generated
    public void setAbortCommand(String abortCommand) {
        this.abortCommand = abortCommand;
    }

    @Generated
    public void setExitOptions(String exitOptions) {
        this.exitOptions = exitOptions;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setServerOptions(String serverOptions) {
        this.serverOptions = serverOptions;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setDuration(String duration) {
        this.duration = duration;
    }

    @Generated
    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    @Generated
    public Commands() {
    }
}

