/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.sep.sesam.model.AllEvents;
import de.sep.sesam.model.core.AbstractEventsEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.runtime.interfaces.IAllEventsAdaptable;
import de.sep.sesam.model.type.AllEventFlag;
import de.sep.sesam.model.type.AllEventType;
import de.sep.sesam.model.type.CommandType;
import de.sep.sesam.model.type.ReferenceType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class CommandEvents
extends AbstractEventsEntity
implements IDisplayLabelProvider,
IAllEventsAdaptable,
MtimeEntity<Long>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 7603591361211097827L;
    @JsonIgnore
    private static final Comparator<CommandEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique ID of the command event.", example="1")
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(as=Long.class)
    private Long id;
    @Schema(description="The name of the command event. The maximum length of the name is 255 characters.\nThe name can contain only letters, digits, the \u2018-\u2018 and the \u2018_\u2019 character.", example="backup_all_clients")
    @Length(max=255)
    @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"})
    private @Length(max=255) @MatchPattern(pattern={"^[a-zA-Z0-9_-]*$"}) String name;
    @Schema(description="The name of the associated command. The maximum length of the object is 50 character.", example="all_clients")
    @Length(max=64)
    private @Length(max=64) String object;
    @Schema(description="Flag to indicate if the command event is enabled for execution", example="true")
    private Boolean exec;
    @Schema(description="The retention time in days.", example="1722384000000")
    private Long eol;
    @Schema(description="The name of the schedule the command event is associated with.", example="daily_backups")
    @Length(max=30)
    private @Length(max=30) String scheduleName;
    @Schema(description="The priority of the command event.", example="10")
    private Long priority;
    @Schema(description="Flag to indicate if the command event is a blocking event.", example="false")
    private Boolean suppress;
    @Schema(description="The follow up actions to execute when the executed command finished successfully. ", example="verify_backup")
    @Length(max=1024)
    private @Length(max=1024) String followUp;
    @Schema(description="The command owner.", example="admin")
    @NotNull
    @Length(max=30)
    private @NotNull @Length(max=30) String owner;
    @Schema(description="The command type. Possible value is \u2018EXECUTE\u2019.", example="BACKUP")
    @NotNull
    private CommandType type;
    @Schema(description="The unique ID of the client where to execute the associated command.", example="101")
    private Long clientId;
    @Schema(description="The host name.", example="server01.example.com")
    @Length(max=64)
    private @Length(max=64) String host;
    @Schema(description="The name of the user used to execute the associated command.", example="j.doe")
    @Length(max=255)
    private @Length(max=255) String userName;
    @Schema(description="The execution options.", example="NULL")
    @Length(max=1024)
    private @Length(max=1024) String options;
    @Schema(description="The server side execution options.", example="NULL")
    @Length(max=1024)
    private @Length(max=1024) String serverOptions;
    @Schema(description="The command to execute.", example="/opt/sep/bin/sbc -b -s ...")
    @Length(max=2048)
    private @Length(max=2048) String command;
    @Schema(description="The name of the command to execute.", example="sbc_backup")
    @Length(max=64)
    private @Length(max=64) String commandName;
    @Schema(description="The comment or note from Sesam.", example="Nightly backup job.")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="The comment or note from the user. ", example="The cake is a lie.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Flag to indicate if the command event is visible to the user or not.", example="true")
    private Boolean visible;
    @Schema(description="Variable immediateFlag used for flagging an immediate backup", example="false")
    private Boolean immediateFlag;
    @Schema(description="The time at which the notification object was modified at last.", example="1720077461000")
    private Date mtime;
    @Schema(description="The reference type", example="start")
    private ReferenceType referenceType;
    @Schema(description="The reference ssid", example="S20240701123456")
    @Length(max=80)
    private @Length(max=80) String referenceSsid;

    @JsonIgnore
    public static Comparator<CommandEvents> sorter() {
        return comparator;
    }

    public CommandEvents(Long id) {
        this.id = id;
    }

    public String getObject() {
        return StringUtils.isNotBlank(this.object) ? this.object : "";
    }

    public String getCommandName() {
        if (StringUtils.isBlank(this.commandName) && StringUtils.isNotBlank(this.object)) {
            this.commandName = this.object;
        }
        return this.commandName;
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getObjectLabel() {
        return StringUtils.isNotBlank(this.getCommandName()) ? this.getCommandName() : "";
    }

    @Override
    @JsonIgnore
    public void fill(AllEvents event) {
        assert (event != null);
        event.setExec(this.getExec());
        event.setEol(this.getEol());
        event.setFollowUp(this.getFollowUp());
        event.setId(this.getId());
        event.setImmediateFlag(this.getImmediateFlag());
        event.setName(this.getName());
        event.setOwner(this.getOwner());
        event.setPriority(this.getPriority());
        event.setSuppress(this.getSuppress());
        event.setType(new AllEventFlag(AllEventType.COMMAND));
        event.setObject(this.getCommandName());
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Boolean getExec() {
        return this.exec;
    }

    @Generated
    public Long getEol() {
        return this.eol;
    }

    @Override
    @Generated
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Override
    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public String getFollowUp() {
        return this.followUp;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public CommandType getType() {
        return this.type;
    }

    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public String getServerOptions() {
        return this.serverOptions;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Override
    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Override
    @Generated
    public Boolean getImmediateFlag() {
        return this.immediateFlag;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceSsid() {
        return this.referenceSsid;
    }

    @Override
    @JsonDeserialize(as=Long.class)
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Override
    @Generated
    public void setExec(Boolean exec) {
        this.exec = exec;
    }

    @Generated
    public void setEol(Long eol) {
        this.eol = eol;
    }

    @Override
    @Generated
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setType(CommandType type) {
        this.type = type;
    }

    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setServerOptions(String serverOptions) {
        this.serverOptions = serverOptions;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    @Generated
    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Override
    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    @Generated
    public void setImmediateFlag(Boolean immediateFlag) {
        this.immediateFlag = immediateFlag;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceSsid(String referenceSsid) {
        this.referenceSsid = referenceSsid;
    }

    @Generated
    public CommandEvents() {
    }
}

