/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import de.sep.sesam.model.Locations;
import de.sep.sesam.model.OperSystems;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.dto.ClientUpdateDto;
import de.sep.sesam.model.core.interfaces.IBrowsableEntity;
import de.sep.sesam.model.core.interfaces.ICredentialsProvider;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IOsCredentialsProvider;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.core.types.BackupType;
import de.sep.sesam.model.core.types.OperatingSystemType;
import de.sep.sesam.model.core.types.VmServerType;
import de.sep.sesam.model.type.AccessMode;
import de.sep.sesam.model.type.ExcludeType;
import de.sep.sesam.model.type.NetProt;
import de.sep.sesam.model.type.SesamVersion;
import de.sep.sesam.model.type.StateType;
import de.sep.sesam.model.type.UpdateMode;
import de.sep.sesam.model.type.UpdateState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.MatchPattern;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class Clients
extends AbstractModelEntity<Long>
implements ILongEntity,
IDisplayLabelProvider,
MtimeEntity<Long>,
INamedEntity,
ICredentialsProvider,
IOsCredentialsProvider,
IBrowsableEntity {
    @JsonIgnore
    private static final long serialVersionUID = 7236077669021056434L;
    @JsonIgnore
    private static final Comparator<Clients> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The client id", example="123456789")
    private Long id;
    @NotNull
    @Length(max=255)
    @MatchPattern(pattern={"^[a-zA-Z0-9_\\.:-]*$"})
    @Schema(description="The client name", example="client1")
    private @NotNull @Length(max=255) @MatchPattern(pattern={"^[a-zA-Z0-9_\\.:-]*$"}) String name;
    @NotNull
    @JsonIncludeProperties(value={"id", "name", "parentId", "displayLabel"})
    @Schema(description="The location of the client", example="{ \"id\": 123456789, \"name\": \"location1\" }")
    private Locations location;
    @JsonIncludeProperties(value={"id", "name", "parentId", "displayLabel"})
    @Schema(description="The location of the client", example="{ \"id\": 123456789, \"name\": \"location1\" }")
    private List<Locations> dataMoverGroups;
    @NotNull
    @JsonIncludeProperties(value={"name", "platform"})
    @Schema(description="The operating system of the client", example="{ \"name\": \"Windows 10\", \"platform\": \"win\" }")
    private OperSystems operSystem;
    @NotNull
    @Schema(description="The network protocol of the client", example="tcp")
    private NetProt netProt;
    @Length(max=64)
    @Schema(description="The MAC address of the client", example="00:11:22:33:44:55")
    private @Length(max=64) String macAddress;
    @Schema(description="The access mode of the client", example="proxy")
    private AccessMode accessmode;
    @Schema(description="The access state of the client", example="1")
    private Integer accessState;
    @Schema(description="The access time of the client", example="2019-01-01 00:00:00")
    private Date accessTime;
    @Schema(description="The access success of the client", example="2019-01-01 00:00:00")
    private Date accessSuccess;
    @Schema(description="The message of the client", example="This is a test message")
    @Length(max=1024)
    private @Length(max=1024) String msg;
    @Schema(description="The user comment of the client", example="This is a test comment")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="The execution of the client", example="1")
    private Long exec;
    @Schema(description="The wake on lan flag of the client", example="1")
    private Boolean wolFlag;
    @Schema(description="The update flag of the client", example="1")
    private UpdateMode updateMode;
    @Schema(description="The credential id of the client", example="123456789")
    private Long credentialId;
    @Schema(description="The credential uuid of the client", example="123456789-abcd-ef01-2345-6789abcdef01")
    @Length(max=40)
    private @Length(max=40) String credentialUuid;
    @Schema(description="The user name of the client", example="user1")
    @Length(max=255)
    private @Length(max=255) String userName;
    @Schema(description="The password of the client", example="<PASSWORD>")
    @Length(max=512)
    private @Length(max=512) String password;
    @Schema(description="The os credential id of the client", example="123456789")
    private Long osCredentialId;
    @Schema(description="The os credential uuid of the client", example="123456789-abcd-ef01-2345-6789abcdef01")
    @Length(max=40)
    private @Length(max=40) String osCredentialUuid;
    @Schema(description="The os user of the client", example="user1")
    @Length(max=255)
    private @Length(max=255) String osUser;
    @Schema(description="The os password of the client", example="<PASSWORD>")
    @Length(max=512)
    private @Length(max=512) String osPassword;
    @Schema(description="The access options of the client", example="127.0.0.1:8080")
    @Length(max=255)
    private @Length(max=255) String accessOptions;
    @Schema(description="The stpd port of the client", example="8080")
    private Long stpdPort;
    @Schema(description="The stpd options of the client", example="127.0.0.1:8080")
    @Length(max=255)
    private @Length(max=255) String stpdOptions;
    @Schema(description="The stpd http port of the client", example="8080")
    private Long stpdHttpPort;
    @Schema(description="The stpd http options of the client", example="127.0.0.1:8080")
    @Length(max=255)
    private @Length(max=255) String stpdHttpOptions;
    @Schema(description="The stpd https port of the client", example="8080")
    private Long stpdHttpsPort;
    @Schema(description="The stpd https options of the client", example="127.0.0.1:8080")
    @Length(max=255)
    private @Length(max=255) String stpdHttpsOptions;
    @Schema(description="The sshd port of the client", example="22")
    private Long sshdPort;
    @Schema(description="The sshd options of the client", example="127.0.0.1:22")
    @Length(max=255)
    private @Length(max=255) String sshdOptions;
    @Schema(description="The sbc version of the client", example="1.0.0")
    @Length(max=20)
    private @Length(max=20) String sbcVersion;
    @Schema(description="The jar version of the client", example="1.0.0")
    @Length(max=256)
    private @Length(max=256) String jarVersion;
    @Schema(description="The jar version number of the client", example="1.0.0")
    private Long jarVersionNumber;
    @Schema(description="The jar available version of the client", example="1.0.0")
    @Length(max=256)
    private @Length(max=256) String jarAvailableVersion;
    @Schema(description="The jar available number of the client", example="1.0.0")
    private Long jarAvailableNumber;
    @Schema(description="The jar update date of the client", example="2019-01-01 00:00:00")
    private Date jarUpdateDate;
    @Schema(description="The sesam version of the client", example="server,5.2.0.9,20250521140505")
    private SesamVersion sesamVersion;
    @Schema(description="The available version of the client", example="4.4.1")
    @Length(max=64)
    private @Length(max=64) String availableVersion;
    @Schema(description="The version id of the client", example="123456789")
    @Length(max=128)
    private @Length(max=128) String versionId;
    @Schema(description="The version number of the client", example="50.200.009")
    private Long versionNumber;
    @Schema(description="The available number of the client", example="0")
    private Long availableNumber;
    @Schema(description="The servicepack number of the client", example="1")
    private Long servicepackVersionNumber;
    @Schema(description="The servicepack available number of the client", example="1")
    private Long servicepackAvailableNumber;
    @Schema(description="The computed update state of the client", example="NONE")
    private String computedUpdateMessage;
    @Schema(description="The module versions of the client", example="1.0.0,2.0.0")
    @Length(max=1024)
    private @Length(max=1024) String moduleVersions;
    @Schema(description="The exclude type of the client", example="ALL")
    private ExcludeType excludeType;
    @Schema(description="The hardware platform of the client", example="x86_64")
    @Length(max=32)
    private @Length(max=32) String hwPlatform;
    @Schema(description="The package of the client", example="clients.zip")
    @Length(max=128)
    private @Length(max=128) String genPack;
    @Schema(description="The servicepack package of the client", example="clients.zip")
    @Length(max=128)
    private @Length(max=128) String servicepackGenPack;
    @Schema(description="The number of cores of the client", example="1")
    private Long cores;
    @Schema(description="The data mover of the client", example="datamover.zip")
    @Length(max=255)
    private @Length(max=255) String dataMover;
    @Schema(description="The virtualization host of the client", example="127.0.0.1")
    @Length(max=64)
    private @Length(max=64) String vmHost;
    @Schema(description="The virtualization host type of the client", example="VMWARE")
    private VmServerType vmHostType;
    @Schema(description="The virtualization name of the client", example="vm-1")
    @Length(max=255)
    private @Length(max=255) String vmName;
    @Schema(description="The virtualization server type of the client", example="VMWARE")
    private VmServerType vmServerType;
    @Schema(description="The license level of the client", example="STANDARD")
    @Length(max=32)
    private @Length(max=32) String licenseLevel;
    @Schema(description="The installation date of the client", example="2019-01-01 00:00:00")
    private Date installationDate;
    @Schema(description="The servicepack date of the client", example="2019-01-01 00:00:00")
    private Date servicepackDate;
    @Schema(description="The update date of the client", example="2019-01-01 00:00:00")
    private Date updateDate;
    @Length(max=5)
    @Schema(description="The update state of the client", example="NONE")
    private @Length(max=5) String updateState;
    @Length(max=2048)
    @Schema(description="The update message of the client", example="No update available")
    private @Length(max=2048) String updateMessage;
    @Schema(description="The date changed of the client", example="2019-01-01 00:00:00")
    private Date dateChanged;
    @Schema(description="The date created of the client", example="2019-01-01 00:00:00")
    private Date dateCreated;
    @Length(max=128)
    @Schema(description="The changed by of the client", example="admin")
    private @Length(max=128) String changedBy;
    @Schema(description="The auto generated of the client", example="1")
    private Long autoGenerated;
    @Schema(description="The creation time of the client", example="2019-01-01 00:00:00")
    private Date creationTime;
    @Schema(description="The mtime of the client", example="2019-01-01 00:00:00")
    private Date mtime;
    @Length(max=40)
    @Schema(description="The uuid of the client", example="12345678-abcd-ef01-2345-6789abcdef01")
    private @Length(max=40) String uuid;
    @Schema(description="The list of backup types available for the client.", example="[\"PATH\", \"SYSTEM_STATE\", \"MS_SQL_SERVER\"]")
    private List<BackupType> availableBackupTypes;
    @Schema(description="Indicates whether the client is orphaned.", example="true")
    private Boolean orphaned;
    @Schema(description="The data transfer object for client updates.", example="{\n  \"clientName\": \"my-test-client\",\n  \"locationId\": 1,\n  \"os\": \"Windows\",\n  \"install\": true,\n  \"sesamPackage\": \"sep-sesam-5.0.0.zip\",\n  \"force\": false\n}")
    private ClientUpdateDto clientUpdateDto;

    @JsonIgnore
    public static Comparator<Clients> sorter() {
        return comparator;
    }

    public Clients(Long id) {
        this.id = id;
    }

    public Clients(String name) {
        this.name = name;
    }

    public final String getVmName() {
        return StringUtils.removeStart(this.vmName, "null/");
    }

    @JsonIgnore
    public boolean isServer(String mode, SesamVersion sesamVersion) {
        if (AccessMode.PROXY.equals(this.accessmode)) {
            return false;
        }
        if (StringUtils.isNotBlank(mode) && !StringUtils.containsIgnoreCase(mode, "expert")) {
            if (this.getAccessState() == null || this.getAccessState().equals(1)) {
                return false;
            }
            if (this.getSesamVersion() == null || this.getSesamVersion().getValue() == null) {
                return false;
            }
            if (!this.getSesamVersion().getValue().contains("server")) {
                return false;
            }
            if (SesamVersion.compareVersion(this.getSesamVersion().getValue(), sesamVersion.getValue()) < 0) {
                return false;
            }
        }
        return this.getSesamVersion() != null && this.getSesamVersion().getValue() != null && this.getSesamVersion().getValue().contains("server");
    }

    @JsonIgnore
    public boolean isSi3Capable() {
        return this.isServer(null, null) && this.getSesamVersion() != null && SesamVersion.compareVersion(this.getSesamVersion().getValue(), "4.4.1") >= 0;
    }

    @Override
    @JsonIgnore
    public OperatingSystemType getOperatingSystemType() {
        return this.getOperSystem() != null ? this.getOperSystem().getType() : null;
    }

    public final UpdateState getComputedUpdateState() {
        int c;
        int c2;
        String candidate;
        UpdateState value = UpdateState.NONE;
        Long version = this.getVersionNumber();
        Long available = this.getAvailableNumber();
        Long spVersion = this.getServicepackVersionNumber();
        Long spAvailable = this.getServicepackAvailableNumber();
        Long jarVersion = this.getJarVersionNumber();
        Long jarAvailable = this.getJarAvailableNumber();
        StateType state = StateType.fromString(this.getUpdateState());
        if (StateType.NONE.equals(state) && StringUtils.length(this.getUpdateState()) > 1) {
            state = StringUtils.equalsAny(this.getUpdateState(), "1641", "1644", "1645", "1652", "1653", "1654", "3010") ? StateType.INFO : StateType.ERROR;
        }
        if (available == null && StringUtils.isNotBlank(candidate = this.getAvailableVersion())) {
            try {
                available = Long.decode(candidate);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (version != null && !version.equals(0L) && available != null && !available.equals(0L)) {
            int c3 = available.compareTo(version);
            if (c3 == 0) {
                value = UpdateState.UP_TO_DATE;
            } else if (c3 > 0) {
                value = UpdateState.UPDATEABLE;
            } else if (c3 < 0) {
                value = UpdateState.NEWER;
            }
        }
        if (!UpdateState.UPDATEABLE.equals((Object)value) && spVersion != null && spAvailable != null && !spAvailable.equals(0L) && (c2 = spAvailable.compareTo(spVersion)) > 0) {
            value = UpdateState.UPDATEABLE;
        }
        if (!UpdateState.UPDATEABLE.equals((Object)value) && jarVersion != null && jarAvailable != null && !jarAvailable.equals(0L) && (c = jarAvailable.compareTo(jarVersion)) > 0) {
            value = UpdateState.UPDATEABLE;
        }
        switch (state) {
            case IN_QUEUE: {
                value = UpdateState.QUEUED;
                break;
            }
            case ACTIVE: {
                value = UpdateState.IN_PROGRESS;
                break;
            }
            case ERROR: {
                value = UpdateState.ERROR;
                break;
            }
        }
        this.computedUpdateMessage = this.getUpdateMessage();
        return UpdateState.NONE.equals((Object)value) ? null : value;
    }

    public final String getComputedUpdateMessage() {
        if (StringUtils.isBlank(this.computedUpdateMessage)) {
            this.getComputedUpdateState();
        }
        return this.computedUpdateMessage;
    }

    @JsonIgnore
    public String getShortName() {
        return StringUtils.isBlank(this.name) ? this.name : this.name.split("\\.")[0];
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Locations getLocation() {
        return this.location;
    }

    @Generated
    public List<Locations> getDataMoverGroups() {
        return this.dataMoverGroups;
    }

    @Generated
    public OperSystems getOperSystem() {
        return this.operSystem;
    }

    @Generated
    public NetProt getNetProt() {
        return this.netProt;
    }

    @Generated
    public String getMacAddress() {
        return this.macAddress;
    }

    @Generated
    public AccessMode getAccessmode() {
        return this.accessmode;
    }

    @Generated
    public Integer getAccessState() {
        return this.accessState;
    }

    @Generated
    public Date getAccessTime() {
        return this.accessTime;
    }

    @Generated
    public Date getAccessSuccess() {
        return this.accessSuccess;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Long getExec() {
        return this.exec;
    }

    @Generated
    public Boolean getWolFlag() {
        return this.wolFlag;
    }

    @Generated
    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    @Override
    @Generated
    public Long getCredentialId() {
        return this.credentialId;
    }

    @Override
    @Generated
    public String getCredentialUuid() {
        return this.credentialUuid;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Long getOsCredentialId() {
        return this.osCredentialId;
    }

    @Override
    @Generated
    public String getOsCredentialUuid() {
        return this.osCredentialUuid;
    }

    @Generated
    public String getOsUser() {
        return this.osUser;
    }

    @Generated
    public String getOsPassword() {
        return this.osPassword;
    }

    @Generated
    public String getAccessOptions() {
        return this.accessOptions;
    }

    @Generated
    public Long getStpdPort() {
        return this.stpdPort;
    }

    @Generated
    public String getStpdOptions() {
        return this.stpdOptions;
    }

    @Generated
    public Long getStpdHttpPort() {
        return this.stpdHttpPort;
    }

    @Generated
    public String getStpdHttpOptions() {
        return this.stpdHttpOptions;
    }

    @Generated
    public Long getStpdHttpsPort() {
        return this.stpdHttpsPort;
    }

    @Generated
    public String getStpdHttpsOptions() {
        return this.stpdHttpsOptions;
    }

    @Generated
    public Long getSshdPort() {
        return this.sshdPort;
    }

    @Generated
    public String getSshdOptions() {
        return this.sshdOptions;
    }

    @Generated
    public String getSbcVersion() {
        return this.sbcVersion;
    }

    @Generated
    public String getJarVersion() {
        return this.jarVersion;
    }

    @Generated
    public Long getJarVersionNumber() {
        return this.jarVersionNumber;
    }

    @Generated
    public String getJarAvailableVersion() {
        return this.jarAvailableVersion;
    }

    @Generated
    public Long getJarAvailableNumber() {
        return this.jarAvailableNumber;
    }

    @Generated
    public Date getJarUpdateDate() {
        return this.jarUpdateDate;
    }

    @Generated
    public SesamVersion getSesamVersion() {
        return this.sesamVersion;
    }

    @Generated
    public String getAvailableVersion() {
        return this.availableVersion;
    }

    @Generated
    public String getVersionId() {
        return this.versionId;
    }

    @Generated
    public Long getVersionNumber() {
        return this.versionNumber;
    }

    @Generated
    public Long getAvailableNumber() {
        return this.availableNumber;
    }

    @Generated
    public Long getServicepackVersionNumber() {
        return this.servicepackVersionNumber;
    }

    @Generated
    public Long getServicepackAvailableNumber() {
        return this.servicepackAvailableNumber;
    }

    @Generated
    public String getModuleVersions() {
        return this.moduleVersions;
    }

    @Generated
    public ExcludeType getExcludeType() {
        return this.excludeType;
    }

    @Generated
    public String getHwPlatform() {
        return this.hwPlatform;
    }

    @Generated
    public String getGenPack() {
        return this.genPack;
    }

    @Generated
    public String getServicepackGenPack() {
        return this.servicepackGenPack;
    }

    @Generated
    public Long getCores() {
        return this.cores;
    }

    @Generated
    public String getDataMover() {
        return this.dataMover;
    }

    @Generated
    public String getVmHost() {
        return this.vmHost;
    }

    @Generated
    public VmServerType getVmHostType() {
        return this.vmHostType;
    }

    @Override
    @Generated
    public VmServerType getVmServerType() {
        return this.vmServerType;
    }

    @Generated
    public String getLicenseLevel() {
        return this.licenseLevel;
    }

    @Generated
    public Date getInstallationDate() {
        return this.installationDate;
    }

    @Generated
    public Date getServicepackDate() {
        return this.servicepackDate;
    }

    @Generated
    public Date getUpdateDate() {
        return this.updateDate;
    }

    @Generated
    public String getUpdateState() {
        return this.updateState;
    }

    @Generated
    public String getUpdateMessage() {
        return this.updateMessage;
    }

    @Generated
    public Date getDateChanged() {
        return this.dateChanged;
    }

    @Generated
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Generated
    public String getChangedBy() {
        return this.changedBy;
    }

    @Generated
    public Long getAutoGenerated() {
        return this.autoGenerated;
    }

    @Generated
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public List<BackupType> getAvailableBackupTypes() {
        return this.availableBackupTypes;
    }

    @Generated
    public Boolean getOrphaned() {
        return this.orphaned;
    }

    @Generated
    public ClientUpdateDto getClientUpdateDto() {
        return this.clientUpdateDto;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLocation(Locations location) {
        this.location = location;
    }

    @Generated
    public void setDataMoverGroups(List<Locations> dataMoverGroups) {
        this.dataMoverGroups = dataMoverGroups;
    }

    @Generated
    public void setOperSystem(OperSystems operSystem) {
        this.operSystem = operSystem;
    }

    @Generated
    public void setNetProt(NetProt netProt) {
        this.netProt = netProt;
    }

    @Generated
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Generated
    public void setAccessmode(AccessMode accessmode) {
        this.accessmode = accessmode;
    }

    @Generated
    public void setAccessState(Integer accessState) {
        this.accessState = accessState;
    }

    @Generated
    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
    }

    @Generated
    public void setAccessSuccess(Date accessSuccess) {
        this.accessSuccess = accessSuccess;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setExec(Long exec) {
        this.exec = exec;
    }

    @Generated
    public void setWolFlag(Boolean wolFlag) {
        this.wolFlag = wolFlag;
    }

    @Generated
    public void setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    @Override
    @Generated
    public void setCredentialId(Long credentialId) {
        this.credentialId = credentialId;
    }

    @Override
    @Generated
    public void setCredentialUuid(String credentialUuid) {
        this.credentialUuid = credentialUuid;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Generated
    public void setOsCredentialId(Long osCredentialId) {
        this.osCredentialId = osCredentialId;
    }

    @Override
    @Generated
    public void setOsCredentialUuid(String osCredentialUuid) {
        this.osCredentialUuid = osCredentialUuid;
    }

    @Generated
    public void setOsUser(String osUser) {
        this.osUser = osUser;
    }

    @Generated
    public void setOsPassword(String osPassword) {
        this.osPassword = osPassword;
    }

    @Generated
    public void setAccessOptions(String accessOptions) {
        this.accessOptions = accessOptions;
    }

    @Generated
    public void setStpdPort(Long stpdPort) {
        this.stpdPort = stpdPort;
    }

    @Generated
    public void setStpdOptions(String stpdOptions) {
        this.stpdOptions = stpdOptions;
    }

    @Generated
    public void setStpdHttpPort(Long stpdHttpPort) {
        this.stpdHttpPort = stpdHttpPort;
    }

    @Generated
    public void setStpdHttpOptions(String stpdHttpOptions) {
        this.stpdHttpOptions = stpdHttpOptions;
    }

    @Generated
    public void setStpdHttpsPort(Long stpdHttpsPort) {
        this.stpdHttpsPort = stpdHttpsPort;
    }

    @Generated
    public void setStpdHttpsOptions(String stpdHttpsOptions) {
        this.stpdHttpsOptions = stpdHttpsOptions;
    }

    @Generated
    public void setSshdPort(Long sshdPort) {
        this.sshdPort = sshdPort;
    }

    @Generated
    public void setSshdOptions(String sshdOptions) {
        this.sshdOptions = sshdOptions;
    }

    @Generated
    public void setSbcVersion(String sbcVersion) {
        this.sbcVersion = sbcVersion;
    }

    @Generated
    public void setJarVersion(String jarVersion) {
        this.jarVersion = jarVersion;
    }

    @Generated
    public void setJarVersionNumber(Long jarVersionNumber) {
        this.jarVersionNumber = jarVersionNumber;
    }

    @Generated
    public void setJarAvailableVersion(String jarAvailableVersion) {
        this.jarAvailableVersion = jarAvailableVersion;
    }

    @Generated
    public void setJarAvailableNumber(Long jarAvailableNumber) {
        this.jarAvailableNumber = jarAvailableNumber;
    }

    @Generated
    public void setJarUpdateDate(Date jarUpdateDate) {
        this.jarUpdateDate = jarUpdateDate;
    }

    @Generated
    public void setSesamVersion(SesamVersion sesamVersion) {
        this.sesamVersion = sesamVersion;
    }

    @Generated
    public void setAvailableVersion(String availableVersion) {
        this.availableVersion = availableVersion;
    }

    @Generated
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Generated
    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    @Generated
    public void setAvailableNumber(Long availableNumber) {
        this.availableNumber = availableNumber;
    }

    @Generated
    public void setServicepackVersionNumber(Long servicepackVersionNumber) {
        this.servicepackVersionNumber = servicepackVersionNumber;
    }

    @Generated
    public void setServicepackAvailableNumber(Long servicepackAvailableNumber) {
        this.servicepackAvailableNumber = servicepackAvailableNumber;
    }

    @Generated
    public void setModuleVersions(String moduleVersions) {
        this.moduleVersions = moduleVersions;
    }

    @Generated
    public void setExcludeType(ExcludeType excludeType) {
        this.excludeType = excludeType;
    }

    @Generated
    public void setHwPlatform(String hwPlatform) {
        this.hwPlatform = hwPlatform;
    }

    @Generated
    public void setGenPack(String genPack) {
        this.genPack = genPack;
    }

    @Generated
    public void setServicepackGenPack(String servicepackGenPack) {
        this.servicepackGenPack = servicepackGenPack;
    }

    @Generated
    public void setCores(Long cores) {
        this.cores = cores;
    }

    @Generated
    public void setDataMover(String dataMover) {
        this.dataMover = dataMover;
    }

    @Generated
    public void setVmHost(String vmHost) {
        this.vmHost = vmHost;
    }

    @Generated
    public void setVmHostType(VmServerType vmHostType) {
        this.vmHostType = vmHostType;
    }

    @Generated
    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    @Generated
    public void setVmServerType(VmServerType vmServerType) {
        this.vmServerType = vmServerType;
    }

    @Generated
    public void setLicenseLevel(String licenseLevel) {
        this.licenseLevel = licenseLevel;
    }

    @Generated
    public void setInstallationDate(Date installationDate) {
        this.installationDate = installationDate;
    }

    @Generated
    public void setServicepackDate(Date servicepackDate) {
        this.servicepackDate = servicepackDate;
    }

    @Generated
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Generated
    public void setUpdateState(String updateState) {
        this.updateState = updateState;
    }

    @Generated
    public void setUpdateMessage(String updateMessage) {
        this.updateMessage = updateMessage;
    }

    @Generated
    public void setDateChanged(Date dateChanged) {
        this.dateChanged = dateChanged;
    }

    @Generated
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Generated
    public void setChangedBy(String changedBy) {
        this.changedBy = changedBy;
    }

    @Generated
    public void setAutoGenerated(Long autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    @Generated
    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setAvailableBackupTypes(List<BackupType> availableBackupTypes) {
        this.availableBackupTypes = availableBackupTypes;
    }

    @Generated
    public void setOrphaned(Boolean orphaned) {
        this.orphaned = orphaned;
    }

    @Generated
    public void setClientUpdateDto(ClientUpdateDto clientUpdateDto) {
        this.clientUpdateDto = clientUpdateDto;
    }

    @Generated
    public Clients() {
    }
}

