/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.ClientLocationRelationsKey;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;

public class ClientLocationRelations
extends AbstractModelEntity<ClientLocationRelationsKey>
implements MtimeEntity<ClientLocationRelationsKey> {
    @JsonIgnore
    private static final long serialVersionUID = -8860390981684650791L;
    @JsonIgnore
    private static final Comparator<ClientLocationRelations> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getPK() == null && o2 != null && o2.getPK() == null) {
            return 0;
        }
        if (o1 == null || o1.getPK() == null) {
            return -1;
        }
        if (o2 == null || o2.getPK() == null) {
            return 1;
        }
        return ClientLocationRelationsKey.sorter().compare(o1.getPK(), o2.getPK());
    };
    @JsonIgnore
    private static final Comparator<ClientLocationRelations> comparatorByOrder = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getClientOrder() == null && o2 != null && o2.getClientOrder() == null) {
            return 0;
        }
        if (o1 == null || o1.getClientOrder() == null) {
            return -1;
        }
        if (o2 == null || o2.getClientOrder() == null) {
            return 1;
        }
        return Long.compare(o1.getClientOrder(), o2.getClientOrder());
    };
    @JsonIgnore
    private final ClientLocationRelationsKey pk = new ClientLocationRelationsKey();
    @Schema(description="Die Reihenfolge des Clients am Standort.", example="1")
    private Long clientOrder;
    @Schema(description="Der eindeutige Bezeichner f\u00fcr die Client-Standort-Beziehung.", example="123e4567-e89b-12d3-a456-426614174000")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @Schema(description="Der Zeitstempel der letzten \u00c4nderung des Datensatzes.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<ClientLocationRelations> sorter() {
        return comparator;
    }

    @JsonIgnore
    public static Comparator<ClientLocationRelations> sorterByOrder() {
        return comparatorByOrder;
    }

    public final Long getLocationId() {
        return this.pk.getLocationId();
    }

    public final void setLocationId(Long loaderNum) {
        this.pk.setLocationId(loaderNum);
    }

    public final Long getClientId() {
        return this.pk.getClientId();
    }

    public final void setClientId(Long number) {
        this.pk.setClientId(number);
    }

    @Override
    @JsonIgnore
    public ClientLocationRelationsKey getPK() {
        return this.pk;
    }

    @Generated
    public Long getClientOrder() {
        return this.clientOrder;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setClientOrder(Long clientOrder) {
        this.clientOrder = clientOrder;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public ClientLocationRelations() {
    }
}

