/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Calendars
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 5312926027660906871L;
    @JsonIgnore
    private static final Comparator<Calendars> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique identifier (UUID) for the calendar.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    @NotNull
    @Length(max=128)
    private @NotNull @Length(max=128) String uuid;
    @Schema(description="The name of the calendar.", example="Holiday Calendar")
    @NotNull
    @Length(max=128)
    private @NotNull @Length(max=128) String name;
    @Schema(description="A short summary or description of the calendar's purpose.", example="Contains all public holidays for Germany.")
    @Length(max=256)
    private @Length(max=256) String summary;
    @Schema(description="The date and time when the calendar was created.", example="1719486000000")
    @Length(max=100)
    private @Length(max=100) Date dateCreated;
    @Schema(description="Indicates if the calendar is currently active.", example="true", defaultValue="true")
    private Boolean active;
    @Schema(description="A user-provided comment or note for the calendar.", example="This calendar is maintained by the HR department.")
    @Length(max=1024)
    private @Length(max=1024) String comment;
    @Schema(description="The modification timestamp of the calendar record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<Calendars> sorter() {
        return comparator;
    }

    public Calendars(String uuid) {
        this.uuid = uuid;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.uuid;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Generated
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Calendars() {
    }
}

