/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.IStringEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class CalendarEvents
extends AbstractModelEntity<String>
implements IStringEntity,
IDisplayLabelProvider,
MtimeEntity<String> {
    @JsonIgnore
    private static final long serialVersionUID = 2254277753775753669L;
    @JsonIgnore
    private static final Comparator<CalendarEvents> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getDateStart() == null && o2 != null && o2.getDateStart() == null) {
            return 0;
        }
        if (o1 == null || o1.getDateStart() == null) {
            return -1;
        }
        if (o2 == null || o2.getDateStart() == null) {
            return 1;
        }
        return o1.getDateStart().compareTo(o2.getDateStart());
    };
    @Schema(description="The UUID of the calendar this event belongs to.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    @NotNull
    @Length(max=40)
    private @NotNull @Length(max=40) String calendar;
    @Schema(description="A short summary or title for the calendar event.", example="Maintenance Window")
    @Length(max=256)
    private @Length(max=256) String summary;
    @Schema(description="The start date and time of the event.", example="1720084800000")
    @NotNull
    @Length(max=40)
    private @NotNull @Length(max=40) Date dateStart;
    @Schema(description="The end date and time of the event.", example="1720092000000")
    @Length(max=40)
    private @Length(max=40) Date dateEnd;
    @Schema(description="Indicates if the event is currently active and should be considered.", example="true", defaultValue="true")
    private Boolean active = true;
    @Schema(description="If true, the event spans the entire day of `dateStart`. The time parts of `dateStart` and `dateEnd` will be ignored and set to the beginning and end of the day, respectively.", example="false", defaultValue="false")
    private Boolean allDay = Boolean.FALSE;
    @Schema(description="If set, this event is treated as an all-day event for the specified date, overriding `dateStart` and `dateEnd`.", example="1720040400000")
    private Date singleDay;
    @Schema(description="A user-provided comment or note for the event.", example="No backups should run during this time.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="Indicates if the event should be visible in the user interface.", example="true", defaultValue="true")
    private Boolean visible;
    @Schema(description="The unique identifier (UUID) for this specific calendar event.", example="f0e9d8c7-b6a5-4321-fedc-ba9876543210")
    @NotNull
    @Length(max=128)
    private @NotNull @Length(max=128) String uuid;
    @Schema(description="The modification timestamp of the event record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<CalendarEvents> sorter() {
        return comparator;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.uuid;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.uuid;
    }

    @Generated
    public String getCalendar() {
        return this.calendar;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public Date getDateStart() {
        return this.dateStart;
    }

    @Generated
    public Date getDateEnd() {
        return this.dateEnd;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Boolean getAllDay() {
        return this.allDay;
    }

    @Generated
    public Date getSingleDay() {
        return this.singleDay;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Boolean getVisible() {
        return this.visible;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setCalendar(String calendar) {
        this.calendar = calendar;
    }

    @Generated
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Generated
    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    @Generated
    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAllDay(Boolean allDay) {
        this.allDay = allDay;
    }

    @Generated
    public void setSingleDay(Date singleDay) {
        this.singleDay = singleDay;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public CalendarEvents() {
    }
}

