/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.EventType;
import de.sep.sesam.model.type.StateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class CalSheets
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
INamedEntity {
    @JsonIgnore
    private static final long serialVersionUID = 6914734316169006958L;
    @JsonIgnore
    private static final Comparator<CalSheets> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique identifier for the calendar sheet entry, often corresponding to an event or job ID.", example="B20250627100000")
    @NotNull
    private String name;
    @Schema(description="The scheduled start time for the event.", example="1720084800000")
    private Date start;
    @Schema(description="The actual end time of the event after its completion.", example="1720085400000")
    private Date endTime;
    @Schema(description="The originally planned or set end time for the event's execution window.", example="1720092000000")
    private Date endTimeSet;
    @Schema(description="The time when the event was terminated, if applicable.", example="1720085400000")
    private Date terminationTime;
    @Schema(description="The logical SEP sesam date for which the event was scheduled.", example="1720040400000")
    private Date sesamDate;
    @Schema(description="The type of the calendar event.", example="BCK")
    @Length(max=3)
    private @Length(max=3) EventType eventType;
    @Schema(description="The unique numerical identifier for the event.", example="101")
    private Long evId;
    @Schema(description="The name of the schedule that generated this event.", example="daily_backup_schedule")
    private String schedule;
    @Schema(description="The priority of the event, determining its execution order.", example="10")
    private Long priority;
    @Schema(description="The current state of the event.", example="QUEUED")
    private StateType state;
    @Schema(description="The name of the task associated with this event.", example="backup_fileserver_c")
    private String taskname;
    @Schema(description="A flag indicating whether the execution of this event should be suppressed.", example="false", defaultValue="false")
    private Boolean suppress;
    @Schema(description="A message or comment from the SEP sesam system related to the event.", example="Event is waiting for a free drive.")
    @Length(max=2048)
    private @Length(max=2048) String sepcomment;
    @Schema(description="Additional execution options for the event.", example="-v 2")
    @Length(max=255)
    private @Length(max=255) String options;
    @Schema(description="The modification timestamp of the calendar sheet record.", example="1720077461000")
    private Date mtime;

    @JsonIgnore
    public static Comparator<CalSheets> sorter() {
        return comparator;
    }

    public CalSheets(String name) {
        this.name = name;
    }

    @Override
    public Date getMtime() {
        return this.mtime;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Date getStart() {
        return this.start;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @Generated
    public Date getEndTimeSet() {
        return this.endTimeSet;
    }

    @Generated
    public Date getTerminationTime() {
        return this.terminationTime;
    }

    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public EventType getEventType() {
        return this.eventType;
    }

    @Generated
    public Long getEvId() {
        return this.evId;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Generated
    public Long getPriority() {
        return this.priority;
    }

    @Generated
    public StateType getState() {
        return this.state;
    }

    @Generated
    public String getTaskname() {
        return this.taskname;
    }

    @Generated
    public Boolean getSuppress() {
        return this.suppress;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStart(Date start) {
        this.start = start;
    }

    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setEndTimeSet(Date endTimeSet) {
        this.endTimeSet = endTimeSet;
    }

    @Generated
    public void setTerminationTime(Date terminationTime) {
        this.terminationTime = terminationTime;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setEvId(Long evId) {
        this.evId = evId;
    }

    @Generated
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Generated
    public void setState(StateType state) {
        this.state = state;
    }

    @Generated
    public void setTaskname(String taskname) {
        this.taskname = taskname;
    }

    @Generated
    public void setSuppress(Boolean suppress) {
        this.suppress = suppress;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public CalSheets() {
    }
}

