/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.runtime.interfaces.IResultsModel;
import de.sep.sesam.model.type.AllResultsFlag;
import de.sep.sesam.model.type.AllResultsType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class AllResults
extends AbstractModelEntity<String>
implements IResultsModel<String>,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = 4642380114754631782L;
    @JsonIgnore
    private static final Comparator<AllResults> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getId().compareToIgnoreCase(o2.getId()) : o1.getId().compareTo(o2.getId());
    };
    @Schema(description="The unique identifier of the result entry.", example="B20250627100000")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String id;
    @Schema(description="The type of the result (e.g., Backup, Restore).", example="BACKUP")
    private AllResultsFlag fdiType;
    @Schema(description="The final state of the operation.", example="SUCCESSFUL")
    private String state;
    @Schema(description="The object associated with the result, typically the client name.", example="my-client")
    private String object;
    @Schema(description="The name of the task that produced this result.", example="daily_backup_task")
    @Length(max=50)
    private @Length(max=50) String task;
    @Schema(description="The start time of the operation.", example="1720077461")
    private Date startTime;
    @Schema(description="The stop time of the operation.", example="1720078361")
    private Date stopTime;
    @Schema(description="The logical SEP sesam date of the operation.", example="1720040400")
    private Date sesamDate;
    @Schema(description="The ID of the saveset created by the operation.", example="SF20250627100000")
    @Length(max=64)
    private @Length(max=64) String saveset;
    @Schema(description="The name of the client.", example="my-client.sep.de")
    @Length(max=255)
    private @Length(max=255) String client;
    @Schema(description="The unique ID of the client.", example="101")
    private Long clientId;
    @Schema(description="The number of the drive used for the operation.", example="2")
    private Long driveNum;
    @Schema(description="The name of the drive used for the operation.", example="LTO-7-Drive-2")
    private String driveName;
    @Schema(description="The size of the transferred data in bytes.", example="10737418240")
    private Double dataSize;
    @Schema(description="The total estimated size of the data in bytes.", example="11000000000")
    private Double estimatedSize;
    @Schema(description="The current size of the data transfer in bytes (for running operations).", example="5368709120")
    private Double currentSize;
    @Schema(description="The progress of the operation in percent.", example="50.5")
    private Double progress;
    @Schema(description="The start time of the specific action.", example="1720077462")
    private Date actionStart;
    @Schema(description="The process ID of the operation on the server.", example="25432")
    private Long pid;
    @Schema(description="The data transfer throughput in bytes per second.", example="29127111")
    private Double throughput;
    @Schema(description="The duration of the operation in seconds.", example="900")
    private Long duration;
    @Schema(description="The session ID of the operation.", example="S20250627100000_25432")
    @Length(max=32)
    private @Length(max=32) String sessionId;
    @Schema(description="The original saveset ID, e.g., in a migration or replication scenario.", example="SF20250620100000")
    @Length(max=80)
    private @Length(max=80) String originalSaveset;
    @Schema(description="The name of the media pool used.", example="MP_WEEKLY")
    @Length(max=16)
    private @Length(max=16) String mediaPool;
    @Schema(description="A comment or message from the SEP sesam system related to the result.", example="Backup finished successfully.")
    @Length(max=1024)
    private @Length(max=1024) String sepcomment;
    @Schema(description="A user-provided comment for the operation.", example="Weekly full backup of file server.")
    @Length(max=1024)
    private @Length(max=1024) String usercomment;
    @Schema(description="A flag indicating if server-side data deduplication was used.", example="true")
    private Boolean ssddFlag;
    @Schema(description="The name of the schedule that triggered the operation.", example="Weekly_Full_Backup")
    @Length(max=30)
    private @Length(max=30) String schedule;
    @Schema(description="The source path(s) for the backup task.", example="/data/important_files")
    @Length(max=4096)
    private @Length(max=4096) String taskSource;
    @Schema(description="The end-of-life date for the created saveset.", example="1751613461")
    private Date eol;
    @Schema(description="A flag indicating if the task was started externally (e.g., via command line).", example="false")
    private Boolean externFlag;
    @Schema(description="The time when the operation was terminated.", example="1720078361")
    private Date terminationTime;
    @Schema(description="The estimated stop time for a running operation.", example="1720078500")
    private Date estimatedStopTime;
    @Schema(description="The estimated duration of the operation.", example="00:15:00")
    private String estimatedDuration;
    @JsonIgnore
    private String originServer;
    private Date mtime;

    @JsonIgnore
    public static Comparator<AllResults> sorter() {
        return comparator;
    }

    public AllResults(String id) {
        this.id = id;
    }

    public void setFdiType(AllResultsFlag fdiType) {
        String s;
        if (fdiType.getType() == AllResultsType.NONE && StringUtils.isNotBlank(s = fdiType.getType().toString())) {
            fdiType.setType(AllResultsType.fromChar(s.charAt(0)));
        }
        this.fdiType = fdiType;
    }

    @Override
    public String getPK() {
        return this.id;
    }

    @Override
    public String getDisplayLabel() {
        return this.id;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public AllResultsFlag getFdiType() {
        return this.fdiType;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Override
    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getStopTime() {
        return this.stopTime;
    }

    @Override
    @Generated
    public Date getSesamDate() {
        return this.sesamDate;
    }

    @Generated
    public String getSaveset() {
        return this.saveset;
    }

    @Override
    @Generated
    public String getClient() {
        return this.client;
    }

    @Override
    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public Long getDriveNum() {
        return this.driveNum;
    }

    @Generated
    public String getDriveName() {
        return this.driveName;
    }

    @Generated
    public Double getDataSize() {
        return this.dataSize;
    }

    @Generated
    public Double getEstimatedSize() {
        return this.estimatedSize;
    }

    @Generated
    public Double getCurrentSize() {
        return this.currentSize;
    }

    @Generated
    public Double getProgress() {
        return this.progress;
    }

    @Generated
    public Date getActionStart() {
        return this.actionStart;
    }

    @Generated
    public Long getPid() {
        return this.pid;
    }

    @Generated
    public Double getThroughput() {
        return this.throughput;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getOriginalSaveset() {
        return this.originalSaveset;
    }

    @Generated
    public String getMediaPool() {
        return this.mediaPool;
    }

    @Generated
    public String getSepcomment() {
        return this.sepcomment;
    }

    @Generated
    public String getUsercomment() {
        return this.usercomment;
    }

    @Generated
    public Boolean getSsddFlag() {
        return this.ssddFlag;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Generated
    public String getTaskSource() {
        return this.taskSource;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public Boolean getExternFlag() {
        return this.externFlag;
    }

    @Generated
    public Date getTerminationTime() {
        return this.terminationTime;
    }

    @Generated
    public Date getEstimatedStopTime() {
        return this.estimatedStopTime;
    }

    @Generated
    public String getEstimatedDuration() {
        return this.estimatedDuration;
    }

    @Override
    @Generated
    public String getOriginServer() {
        return this.originServer;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    @Generated
    public void setSesamDate(Date sesamDate) {
        this.sesamDate = sesamDate;
    }

    @Generated
    public void setSaveset(String saveset) {
        this.saveset = saveset;
    }

    @Override
    @Generated
    public void setClient(String client) {
        this.client = client;
    }

    @Override
    @Generated
    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setDriveNum(Long driveNum) {
        this.driveNum = driveNum;
    }

    @Generated
    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    @Generated
    public void setDataSize(Double dataSize) {
        this.dataSize = dataSize;
    }

    @Generated
    public void setEstimatedSize(Double estimatedSize) {
        this.estimatedSize = estimatedSize;
    }

    @Generated
    public void setCurrentSize(Double currentSize) {
        this.currentSize = currentSize;
    }

    @Generated
    public void setProgress(Double progress) {
        this.progress = progress;
    }

    @Generated
    public void setActionStart(Date actionStart) {
        this.actionStart = actionStart;
    }

    @Generated
    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Generated
    public void setThroughput(Double throughput) {
        this.throughput = throughput;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setOriginalSaveset(String originalSaveset) {
        this.originalSaveset = originalSaveset;
    }

    @Generated
    public void setMediaPool(String mediaPool) {
        this.mediaPool = mediaPool;
    }

    @Generated
    public void setSepcomment(String sepcomment) {
        this.sepcomment = sepcomment;
    }

    @Generated
    public void setUsercomment(String usercomment) {
        this.usercomment = usercomment;
    }

    @Generated
    public void setSsddFlag(Boolean ssddFlag) {
        this.ssddFlag = ssddFlag;
    }

    @Generated
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setTaskSource(String taskSource) {
        this.taskSource = taskSource;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setExternFlag(Boolean externFlag) {
        this.externFlag = externFlag;
    }

    @Generated
    public void setTerminationTime(Date terminationTime) {
        this.terminationTime = terminationTime;
    }

    @Generated
    public void setEstimatedStopTime(Date estimatedStopTime) {
        this.estimatedStopTime = estimatedStopTime;
    }

    @Generated
    public void setEstimatedDuration(String estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public AllResults() {
    }
}

