/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.NotificationSeverity;
import de.sep.sesam.model.type.NotificationsAcknowledged;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Alerts
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
INamedEntity,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = -533309346553798320L;
    @JsonIgnore
    private static final Comparator<Alerts> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getId().compareToIgnoreCase(o2.getId()) : o1.getId().compareTo(o2.getId());
    };
    @Schema(description="The unique identifier of the alert.", example="Task-sinit-1720077461")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String id;
    @Schema(description="The type of the alert.", example="backup_size_alert")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String type;
    @Schema(description="The timestamp when the alert was created.", example="1720077461")
    private Date creationTime;
    @Schema(description="Flag to indicate if the alert is deprecated.", example="false")
    private Boolean deprecated;
    @Schema(description="Severity level of the alert", example="INFO", defaultValue="INFO")
    private NotificationSeverity severity = NotificationSeverity.INFO;
    @Schema(description="The name of the task associated with this alert.", example="sinit")
    @Length(max=50)
    private @Length(max=50) String task;
    @Schema(description="The UUID of the task.", example="a1b2c3d4-e5f6-7890-1234-567890abcdef")
    @Length(max=40)
    private @Length(max=40) String taskUuid;
    @Schema(description="The saveset ID related to the alert.", example="SF20250627100000")
    @Length(max=64)
    private @Length(max=64) String saveset;
    @Schema(description="The reference saveset ID, for comparison purposes.", example="SF20250626100000")
    @Length(max=64)
    private @Length(max=64) String referenceSaveset;
    @Schema(description="The backup ID.", example="B20250627100000")
    @Length(max=64)
    private @Length(max=64) String backupId;
    @Schema(description="The reference backup ID.", example="B20250626100000")
    @Length(max=64)
    private @Length(max=64) String referenceBackupId;
    @Schema(description="The start time of the related task or event.", example="1720077461")
    private Date startTime;
    @Schema(description="The start time of the reference task or event.", example="1719991061")
    private Date referenceStartTime;
    @Schema(description="The total size of the data involved in bytes.", example="1073741824")
    private Double totalSize;
    @Schema(description="The total size of the reference data in bytes.", example="1048576000")
    private Double referenceTotalSize;
    @Schema(description="The end-of-life timestamp for the related data.", example="1751613461")
    private Date eol;
    @Schema(description="The name of the datastore related to the alert.", example="DATASTORE_1")
    @Length(max=32)
    private @Length(max=32) String datastore;
    @Schema(description="The total capacity of the datastore in bytes.", example="1099511627776")
    private Double capacity;
    @Schema(description="The high water mark of the datastore in bytes.", example="989560465000")
    private Double highWaterMark;
    @Schema(description="The currently filled space of the datastore in bytes.", example="536870912000")
    private Double filled;
    @Schema(description="The actual stored data size after deduplication and compression in bytes.", example="268435456000")
    private Double stored;
    @Schema(description="The predicted time in seconds from now when the datastore will overflow.", example="864000")
    private Long overflowTime;
    @Schema(description="A comment or message providing more details about the notification.", example="Backup completed successfully.")
    @Length(max=1024)
    private @Length(max=1024) String comment;
    @Schema(description="Acknowledgment status", example="ACKNOWLEDGED")
    private NotificationsAcknowledged acknowledged;
    @Schema(description="User who acknowledged the alert", example="admin")
    @Length(max=64)
    private @Length(max=64) String ackBy;
    @Schema(description="Date when alert was acknowledged", example="2025-06-30T10:00:00Z")
    private Date ackDate;
    @Schema(description="Comment added during acknowledgment", example="Issue resolved")
    @Length(max=4096)
    private @Length(max=4096) String ackUsercomment;
    @Schema(description="Date when the alert was resolved", example="2025-06-30T11:00:00Z")
    private Date resolvedDate;
    @Schema(description="User who resolved the alert", example="admin")
    @Length(max=64)
    private @Length(max=64) String resolvedBy;
    @Schema(description="Date for notification resubmission", example="2025-07-01T10:00:00Z")
    private Date resubmissionDate;
    @Schema(description="The modification time of the notification record from the database.", example="1720077461")
    private Date mtime;
    @Schema(description="The unique identifier (UUID) for the notification.", example="d4e5f6a7-b8c9-0123-4567-890abcdef123")
    @Length(max=40)
    private @Length(max=40) String uuid;

    @JsonIgnore
    public static Comparator<Alerts> sorter() {
        return comparator;
    }

    public Alerts(String id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.id;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Generated
    public NotificationSeverity getSeverity() {
        return this.severity;
    }

    @Generated
    public String getTask() {
        return this.task;
    }

    @Generated
    public String getTaskUuid() {
        return this.taskUuid;
    }

    @Generated
    public String getSaveset() {
        return this.saveset;
    }

    @Generated
    public String getReferenceSaveset() {
        return this.referenceSaveset;
    }

    @Generated
    public String getBackupId() {
        return this.backupId;
    }

    @Generated
    public String getReferenceBackupId() {
        return this.referenceBackupId;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getReferenceStartTime() {
        return this.referenceStartTime;
    }

    @Generated
    public Double getTotalSize() {
        return this.totalSize;
    }

    @Generated
    public Double getReferenceTotalSize() {
        return this.referenceTotalSize;
    }

    @Generated
    public Date getEol() {
        return this.eol;
    }

    @Generated
    public String getDatastore() {
        return this.datastore;
    }

    @Generated
    public Double getCapacity() {
        return this.capacity;
    }

    @Generated
    public Double getHighWaterMark() {
        return this.highWaterMark;
    }

    @Generated
    public Double getFilled() {
        return this.filled;
    }

    @Generated
    public Double getStored() {
        return this.stored;
    }

    @Generated
    public Long getOverflowTime() {
        return this.overflowTime;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public NotificationsAcknowledged getAcknowledged() {
        return this.acknowledged;
    }

    @Generated
    public String getAckBy() {
        return this.ackBy;
    }

    @Generated
    public Date getAckDate() {
        return this.ackDate;
    }

    @Generated
    public String getAckUsercomment() {
        return this.ackUsercomment;
    }

    @Generated
    public Date getResolvedDate() {
        return this.resolvedDate;
    }

    @Generated
    public String getResolvedBy() {
        return this.resolvedBy;
    }

    @Generated
    public Date getResubmissionDate() {
        return this.resubmissionDate;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Generated
    public void setSeverity(NotificationSeverity severity) {
        this.severity = severity;
    }

    @Generated
    public void setTask(String task) {
        this.task = task;
    }

    @Generated
    public void setTaskUuid(String taskUuid) {
        this.taskUuid = taskUuid;
    }

    @Generated
    public void setSaveset(String saveset) {
        this.saveset = saveset;
    }

    @Generated
    public void setReferenceSaveset(String referenceSaveset) {
        this.referenceSaveset = referenceSaveset;
    }

    @Generated
    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    @Generated
    public void setReferenceBackupId(String referenceBackupId) {
        this.referenceBackupId = referenceBackupId;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setReferenceStartTime(Date referenceStartTime) {
        this.referenceStartTime = referenceStartTime;
    }

    @Generated
    public void setTotalSize(Double totalSize) {
        this.totalSize = totalSize;
    }

    @Generated
    public void setReferenceTotalSize(Double referenceTotalSize) {
        this.referenceTotalSize = referenceTotalSize;
    }

    @Generated
    public void setEol(Date eol) {
        this.eol = eol;
    }

    @Generated
    public void setDatastore(String datastore) {
        this.datastore = datastore;
    }

    @Generated
    public void setCapacity(Double capacity) {
        this.capacity = capacity;
    }

    @Generated
    public void setHighWaterMark(Double highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    @Generated
    public void setFilled(Double filled) {
        this.filled = filled;
    }

    @Generated
    public void setStored(Double stored) {
        this.stored = stored;
    }

    @Generated
    public void setOverflowTime(Long overflowTime) {
        this.overflowTime = overflowTime;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setAcknowledged(NotificationsAcknowledged acknowledged) {
        this.acknowledged = acknowledged;
    }

    @Generated
    public void setAckBy(String ackBy) {
        this.ackBy = ackBy;
    }

    @Generated
    public void setAckDate(Date ackDate) {
        this.ackDate = ackDate;
    }

    @Generated
    public void setAckUsercomment(String ackUsercomment) {
        this.ackUsercomment = ackUsercomment;
    }

    @Generated
    public void setResolvedDate(Date resolvedDate) {
        this.resolvedDate = resolvedDate;
    }

    @Generated
    public void setResolvedBy(String resolvedBy) {
        this.resolvedBy = resolvedBy;
    }

    @Generated
    public void setResubmissionDate(Date resubmissionDate) {
        this.resubmissionDate = resubmissionDate;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public Alerts() {
    }
}

