/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.StateType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class AlertTypes
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
INamedEntity,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = -3352559044361634506L;
    @JsonIgnore
    public static final String BACKUP_SIZE_ALERT = "backup_size_alert";
    @JsonIgnore
    public static final String BACKUP_STORAGE_OVERFLOW_ALERT = "backup_storage_overflow_alert";
    @JsonIgnore
    private static final Comparator<AlertTypes> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The unique name of the notification configuration.", example="Datastore-High-Watermark")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String name;
    @Schema(description="The severity level of the notification.", example="WARNING")
    @NotNull
    private StateType severity;
    @Schema(description="Indicates if the notification configuration is currently active.", example="true")
    private Boolean enabled;
    @Schema(description="Indicates if the user-specific notification settings are enabled.", example="true")
    private Boolean userEnabled;
    @Schema(description="Indicates if email notifications are enabled for this configuration.", example="true")
    private Boolean emailEnabled;
    @Schema(description="The first threshold value for triggering the notification.", example="85.5")
    private Double threshold1;
    @Schema(description="The second threshold value for triggering a higher severity notification.", example="95.0")
    private Double threshold2;
    @Schema(description="The modification time of the notification configuration record from the database.", example="1720077461")
    private Date mtime;
    @Schema(description="The unique identifier (UUID) for the notification configuration.", example="f6a7b8c9-d0e1-2345-6789-0abcdef12345")
    @Length(max=40)
    private @Length(max=40) String uuid;

    @JsonIgnore
    public static Comparator<AlertTypes> sorter() {
        return comparator;
    }

    public AlertTypes(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public StateType getSeverity() {
        return this.severity;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public Boolean getUserEnabled() {
        return this.userEnabled;
    }

    @Generated
    public Boolean getEmailEnabled() {
        return this.emailEnabled;
    }

    @Generated
    public Double getThreshold1() {
        return this.threshold1;
    }

    @Generated
    public Double getThreshold2() {
        return this.threshold2;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSeverity(StateType severity) {
        this.severity = severity;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setUserEnabled(Boolean userEnabled) {
        this.userEnabled = userEnabled;
    }

    @Generated
    public void setEmailEnabled(Boolean emailEnabled) {
        this.emailEnabled = emailEnabled;
    }

    @Generated
    public void setThreshold1(Double threshold1) {
        this.threshold1 = threshold1;
    }

    @Generated
    public void setThreshold2(Double threshold2) {
        this.threshold2 = threshold2;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public AlertTypes() {
    }
}

