/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.json.JsonUtil;
import de.sep.sesam.model.AclUser;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.ILongEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.runtime.interfaces.IAclUserNameResolver;
import de.sep.sesam.model.type.AclUserType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;
import org.apache.commons.lang3.StringUtils;

public class Acls
extends AbstractModelEntity<Long>
implements ILongEntity,
IDisplayLabelProvider,
MtimeEntity<Long> {
    @JsonIgnore
    private static final long serialVersionUID = 1723821871480945617L;
    @JsonIgnore
    private static final Comparator<Acls> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getId() == null && o2 != null && o2.getId() == null) {
            return 0;
        }
        if (o1 == null || o1.getId() == null) {
            return -1;
        }
        if (o2 == null || o2.getId() == null) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    @Schema(description="The unique identifier for the ACL entry.", example="10", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull
    private Long id;
    @Schema(description="The object to which the ACL applies (e.g., a specific UI component or data type).", example="clients", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String object;
    @Schema(description="The origin of the ACL, typically 'user' or 'group'.", example="user")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String origin;
    @Schema(description="The permission value, often a comma-separated list of allowed actions.", example="READ,WRITE,EXECUTE")
    @NotNull
    private String value;
    @Schema(description="A human-readable label for the object, returned by the list API.", example="Clients")
    private String label;
    @Schema(description="A human-readable label for the permission value, returned by the list API.", example="Read, Write, Execute")
    private String valueLabel;
    @Schema(description="The modification time of the ACL record from the database.", example="1720077461")
    private Date mtime;
    @Schema(description="The unique identifier (UUID) for the ACL entry.", example="d4e5f6a7-b8c9-0123-4567-890abcdef123")
    @Length(max=40)
    private @Length(max=40) String uuid;
    @JsonIgnore
    private List<AclUser> users;

    @JsonIgnore
    public static Comparator<Acls> sorter() {
        return comparator;
    }

    public Acls(Long id) {
        this.id = id;
    }

    public Acls(Acls other) {
        assert (other != null);
        this.id = other.id;
        this.object = other.object;
        this.origin = other.origin;
        this.value = other.value;
        this.label = other.label;
        this.mtime = other.mtime;
        this.uuid = other.uuid;
        if (other.users != null) {
            this.users = new ArrayList<AclUser>();
            for (AclUser candidate : other.users) {
                AclUser user = new AclUser(candidate);
                this.users.add(user);
            }
        }
    }

    @Override
    @JsonIgnore
    public Long getPK() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.id != null ? this.id.toString() : "";
    }

    @JsonIgnore
    public String toDebugString(String prefix, Object entity, IAclUserNameResolver resolver) {
        assert (prefix != null);
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append("Object ID: ");
        sb.append(StringUtils.isNotBlank(this.object) ? this.object : "N/A");
        sb.append("\n");
        sb.append(prefix);
        sb.append("Object Origin: ");
        sb.append(StringUtils.isNotBlank(this.origin) ? this.origin : "N/A");
        sb.append("\n");
        sb.append(prefix);
        sb.append("Object Display Label: ");
        if (Long.valueOf(-1L).equals(this.id)) {
            sb.append("Default ACL");
        } else if (StringUtils.isNotBlank(this.label)) {
            sb.append(this.label);
        } else if (entity instanceof IDisplayLabelProvider) {
            sb.append(((IDisplayLabelProvider)entity).getDisplayLabel());
        } else {
            sb.append("N/A");
        }
        sb.append("\n\n");
        sb.append(prefix);
        sb.append("Group or user names: ");
        List<AclUser> users = null;
        try {
            users = JsonUtil.readList(this.getValue(), AclUser.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (users != null && !users.isEmpty()) {
            boolean first = true;
            for (AclUser user : users) {
                if (user.getId() == null && AclUserType.GROUP.equals((Object)user.getType())) continue;
                if (resolver != null && StringUtils.isBlank(user.getName())) {
                    user.setName(resolver.getAclUserName(user));
                }
                sb.append(first ? "\n" : "\n\n");
                sb.append(user.toDebugString(prefix + "   "));
                first = false;
            }
        } else {
            sb.append("\n");
            sb.append(prefix);
            sb.append("   ");
            sb.append("N/A");
        }
        return sb.toString();
    }

    @Override
    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getValueLabel() {
        return this.valueLabel;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public List<AclUser> getUsers() {
        return this.users;
    }

    @Override
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setValueLabel(String valueLabel) {
        this.valueLabel = valueLabel;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JsonIgnore
    @Generated
    public void setUsers(List<AclUser> users) {
        this.users = users;
    }

    @Generated
    public Acls() {
    }
}

