/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.AclPermission;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.type.AclGrantType;
import de.sep.sesam.model.type.AclPermissionType;
import de.sep.sesam.model.type.AclUserType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.text.WordUtils;

public class AclUser
extends AbstractSerializableObject
implements IDisplayLabelProvider,
INamedEntity {
    private static final long serialVersionUID = -6516601123997849392L;
    @JsonIgnore
    private static final Comparator<AclUser> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getType() == null && o2 != null && o2.getType() == null) {
            return 0;
        }
        if (o1 == null || o1.getType() == null) {
            return -1;
        }
        if (o2 == null || o2.getType() == null) {
            return 1;
        }
        return Integer.compare(o1.getType().ordinal(), o2.getType().ordinal());
    };
    @Schema(description="The ID of the user, group, or external group.", example="admin")
    private String id;
    @Schema(description="The type of the ID, indicating whether it refers to a user, group, etc.", example="USER")
    private AclUserType type;
    @Schema(description="The name of the user, group, or external group.", example="Administrator")
    @JsonIgnore
    private String name;
    @Schema(description="A list of permissions associated with the user or group.")
    @JsonIgnore
    private List<AclPermission> permissionsList;
    @Schema(description="Flag to indicate if the user is marked as invalid.", example="false")
    @JsonIgnore
    private boolean invalid;
    @Schema(description="Flag to indicate whether the user can be deleted.", example="true", defaultValue="true")
    @JsonIgnore
    private boolean canDelete = true;
    @Schema(description="Flag to indicate whether the user's permissions can be edited.", example="true", defaultValue="true")
    @JsonIgnore
    private boolean canEdit = true;

    @JsonIgnore
    public static Comparator<AclUser> sorter() {
        return comparator;
    }

    public AclUser() {
    }

    public AclUser(AclUser other) {
        assert (other != null);
        this.id = other.id;
        this.type = other.type;
        this.name = other.name;
        this.invalid = other.invalid;
        this.canDelete = other.canDelete;
        this.canEdit = other.canEdit;
        if (other.permissionsList != null) {
            this.permissionsList = new ArrayList<AclPermission>();
            for (AclPermission candidate : other.permissionsList) {
                AclPermission permission = new AclPermission(candidate);
                this.permissionsList.add(permission);
            }
        }
    }

    public boolean canDelete() {
        return this.canDelete;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public Map<String, String> getPermissions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List<AclPermission> permissions = this.getPermissionsList();
        if (permissions != null) {
            StringBuilder allow = new StringBuilder("----");
            StringBuilder deny = new StringBuilder("----");
            permissions.sort((o1, o2) -> {
                assert (o1 != null);
                assert (o2 != null);
                return o1.getGrantType().compareTo(o2.getGrantType());
            });
            for (AclPermission permission : permissions) {
                char c = ' ';
                int i = -1;
                if (AclPermissionType.FULL_CONTROL.equals((Object)permission.getType())) {
                    c = 'f';
                    i = 0;
                } else if (AclPermissionType.WRITE.equals((Object)permission.getType())) {
                    c = 'w';
                    i = 1;
                } else if (AclPermissionType.READ_EXECUTE.equals((Object)permission.getType())) {
                    c = 'x';
                    i = 3;
                } else if (AclPermissionType.READ.equals((Object)permission.getType())) {
                    c = 'r';
                    i = 2;
                }
                if (AclGrantType.ALLOW.equals((Object)permission.getGrantType())) {
                    if (i == -1) continue;
                    allow.setCharAt(i, c);
                    continue;
                }
                if (!AclGrantType.DENY.equals((Object)permission.getGrantType()) || i == -1) continue;
                deny.setCharAt(i, c);
            }
            if (!"----".equals(allow.toString())) {
                result.put("allow", allow.toString());
            }
            if (!"----".equals(deny.toString())) {
                result.put("deny", deny.toString());
            }
        }
        return !result.isEmpty() ? result : null;
    }

    public void setPermissions(Map<String, String> value) {
        AclPermission p;
        char c;
        int i;
        String deny;
        if (value == null || value.isEmpty()) {
            this.setPermissionsList(null);
            return;
        }
        ArrayList<AclPermission> permissions = new ArrayList<AclPermission>();
        String allow = value.get("allow");
        if (allow == null) {
            allow = "----";
        }
        if ((deny = value.get("deny")) == null) {
            deny = "----";
        }
        for (i = 0; i < allow.length(); ++i) {
            c = allow.charAt(i);
            if (c != '-' && i == 0) {
                p = new AclPermission();
                p.setGrantType(AclGrantType.ALLOW);
                p.setType(AclPermissionType.FULL_CONTROL);
                permissions.add(p);
            }
            if (c != '-' && i == 1) {
                p = new AclPermission();
                p.setGrantType(AclGrantType.ALLOW);
                p.setType(AclPermissionType.WRITE);
                permissions.add(p);
            }
            if (c != '-' && i == 2) {
                p = new AclPermission();
                p.setGrantType(AclGrantType.ALLOW);
                p.setType(AclPermissionType.READ);
                permissions.add(p);
            }
            if (c == '-' || i != 3) continue;
            p = new AclPermission();
            p.setGrantType(AclGrantType.ALLOW);
            p.setType(AclPermissionType.READ_EXECUTE);
            permissions.add(p);
        }
        for (i = 0; i < deny.length(); ++i) {
            c = deny.charAt(i);
            if (c != '-' && i == 0) {
                p = new AclPermission();
                p.setGrantType(AclGrantType.DENY);
                p.setType(AclPermissionType.FULL_CONTROL);
                permissions.add(p);
            }
            if (c != '-' && i == 1) {
                p = new AclPermission();
                p.setGrantType(AclGrantType.DENY);
                p.setType(AclPermissionType.WRITE);
                permissions.add(p);
            }
            if (c != '-' && i == 2) {
                p = new AclPermission();
                p.setGrantType(AclGrantType.DENY);
                p.setType(AclPermissionType.READ);
                permissions.add(p);
            }
            if (c == '-' || i != 3) continue;
            p = new AclPermission();
            p.setGrantType(AclGrantType.DENY);
            p.setType(AclPermissionType.READ_EXECUTE);
            permissions.add(p);
        }
        this.setPermissionsList(!permissions.isEmpty() ? permissions : null);
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        String s;
        if (AclUserType.GROUP.equals((Object)this.type) && !StringUtils.startsWith(s = I18n.get("Label.Group" + WordUtils.capitalizeFully(this.name), new Object[0]), "!") && !StringUtils.startsWith(s, "!")) {
            return s;
        }
        return this.name;
    }

    @JsonIgnore
    public static String getLabelEverybodyUser() {
        return I18n.get("AclUser.Label.Everybody", new Object[0]);
    }

    @JsonIgnore
    public String toDebugString(String prefix) {
        List<AclPermission> permissions;
        assert (prefix != null);
        boolean singleLine = prefix.length() == 0;
        boolean isEverybodyUser = StringUtils.isBlank(this.id) && AclUserType.GROUP.equals((Object)this.type);
        StringBuilder sb = new StringBuilder();
        if (!isEverybodyUser) {
            sb.append(prefix);
            sb.append("ID: ");
            sb.append(this.id);
            sb.append(singleLine ? ", " : "\n");
            sb.append(prefix);
            sb.append("Type: ");
            sb.append((Object)this.type);
            sb.append(singleLine ? ", " : "\n");
        }
        sb.append(prefix);
        sb.append("Name: ");
        if (isEverybodyUser) {
            sb.append(AclUser.getLabelEverybodyUser());
        } else {
            sb.append(this.name);
        }
        sb.append(singleLine ? ", " : "\n");
        sb.append(prefix);
        sb.append("Permissions: ");
        if (!singleLine) {
            sb.append("\n");
            sb.append(prefix);
            sb.append("   ");
        }
        if ((permissions = this.getPermissionsList()) != null && !permissions.isEmpty()) {
            if (singleLine) {
                sb.append("[");
            }
            boolean first = true;
            for (AclPermission permission : permissions) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(permission.toDebugString());
                first = false;
            }
            if (singleLine) {
                sb.append("]");
            }
        } else {
            sb.append("N/A");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AclUser aclUser = (AclUser)o;
        return new EqualsBuilder().append(this.id, aclUser.id).append((Object)this.type, (Object)aclUser.type).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).append((Object)this.type).toHashCode();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public AclUserType getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<AclPermission> getPermissionsList() {
        return this.permissionsList;
    }

    @Generated
    public boolean isInvalid() {
        return this.invalid;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setType(AclUserType type) {
        this.type = type;
    }

    @JsonIgnore
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    @Generated
    public void setPermissionsList(List<AclPermission> permissionsList) {
        this.permissionsList = permissionsList;
    }

    @JsonIgnore
    @Generated
    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    @JsonIgnore
    @Generated
    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    @JsonIgnore
    @Generated
    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }
}

