/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.core.AbstractSerializableObject;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.type.AclGrantType;
import de.sep.sesam.model.type.AclPermissionType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

public class AclPermission
extends AbstractSerializableObject
implements IDisplayLabelProvider {
    private static final long serialVersionUID = 6343542295929970494L;
    @Schema(description="The grant type for the ACL (Access Control List).", example="ALLOW")
    @JsonIgnore
    private AclGrantType grantType;
    @Schema(description="The type of permission being granted.", example="READ")
    @JsonIgnore
    private AclPermissionType type;

    public AclPermission(AclPermission other) {
        assert (other != null);
        this.grantType = other.grantType;
        this.type = other.type;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return I18n.get("AclPermission.Label." + this.type.toString().toLowerCase(), new Object[0]);
    }

    @JsonIgnore
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDisplayLabel());
        sb.append(" : ");
        sb.append(AclGrantType.ALLOW.equals((Object)this.grantType) ? "Allow" : (AclGrantType.DENY.equals((Object)this.grantType) ? "Deny" : "N/A"));
        return sb.toString();
    }

    @Generated
    public AclGrantType getGrantType() {
        return this.grantType;
    }

    @Generated
    public AclPermissionType getType() {
        return this.type;
    }

    @JsonIgnore
    @Generated
    public void setGrantType(AclGrantType grantType) {
        this.grantType = grantType;
    }

    @JsonIgnore
    @Generated
    public void setType(AclPermissionType type) {
        this.type = type;
    }

    @Generated
    public AclPermission() {
    }
}

