/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.model.core.AbstractModelEntity;
import de.sep.sesam.model.core.interfaces.IDisplayLabelProvider;
import de.sep.sesam.model.core.interfaces.INamedEntity;
import de.sep.sesam.model.core.interfaces.MtimeEntity;
import de.sep.sesam.model.type.SslOption;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Comparator;
import java.util.Date;
import lombok.Generated;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.NotNull;

public class Accounts
extends AbstractModelEntity<String>
implements MtimeEntity<String>,
INamedEntity,
IDisplayLabelProvider {
    @JsonIgnore
    private static final long serialVersionUID = 1723821871480945617L;
    @JsonIgnore
    private static final Comparator<Accounts> comparator = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 != null && o1.getName() == null && o2 != null && o2.getName() == null) {
            return 0;
        }
        if (o1 == null || o1.getName() == null) {
            return -1;
        }
        if (o2 == null || o2.getName() == null) {
            return 1;
        }
        boolean sortCaseInsensitive = Boolean.getBoolean("Sesam.Gui.DefaultSortCaseInsensitive");
        return sortCaseInsensitive ? o1.getName().compareToIgnoreCase(o2.getName()) : o1.getName().compareTo(o2.getName());
    };
    @Schema(description="The name of the mail account.", example="Default Mail Account")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String name;
    @Schema(description="The name of the customer.", example="SEP AG")
    @Length(max=64)
    private @Length(max=64) String customer;
    @Schema(description="The sender's email address.", example="backup-reports@sep.de")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String smtpEmailAddress;
    @Schema(description="The hostname or IP address of the SMTP server.", example="smtp.sep.de")
    @NotNull
    @Length(max=64)
    private @NotNull @Length(max=64) String smtpServer;
    @Schema(description="The port of the SMTP server.", example="587")
    private Long smtpPort;
    @Schema(description="The SSL/TLS options for the SMTP connection.", example="SSL_TLS")
    private SslOption sslOptions;
    @Schema(description="The username for SMTP authentication.", example="smtp_user")
    @Length(max=64)
    private @Length(max=64) String mailUsername;
    @Schema(description="The password for SMTP authentication.", example="<password_placeholder>")
    @Length(max=512)
    private @Length(max=512) String mailPassword;
    @Schema(description="The primary recipient's email address.", example="admins@sep.de")
    @NotNull
    @Length(max=128)
    private @NotNull @Length(max=128) String mailTo;
    @Schema(description="The CC recipient's email address.", example="management@sep.de")
    @Length(max=128)
    private @Length(max=128) String mailCc;
    @Schema(description="The BCC recipient's email address.", example="archive@sep.de")
    @Length(max=128)
    private @Length(max=128) String mailBcc;
    @Schema(description="The service location associated with this account.", example="Hauptstandort")
    @Length(max=64)
    private @Length(max=64) String serviceLocation;
    @Schema(description="The modification time of the account record from the database.", example="1720077461")
    private Date mtime;

    @JsonIgnore
    public static Comparator<Accounts> sorter() {
        return comparator;
    }

    public Accounts(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public String getPK() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayLabel() {
        return this.name;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public String getSmtpEmailAddress() {
        return this.smtpEmailAddress;
    }

    @Generated
    public String getSmtpServer() {
        return this.smtpServer;
    }

    @Generated
    public Long getSmtpPort() {
        return this.smtpPort;
    }

    @Generated
    public SslOption getSslOptions() {
        return this.sslOptions;
    }

    @Generated
    public String getMailUsername() {
        return this.mailUsername;
    }

    @Generated
    public String getMailPassword() {
        return this.mailPassword;
    }

    @Generated
    public String getMailTo() {
        return this.mailTo;
    }

    @Generated
    public String getMailCc() {
        return this.mailCc;
    }

    @Generated
    public String getMailBcc() {
        return this.mailBcc;
    }

    @Generated
    public String getServiceLocation() {
        return this.serviceLocation;
    }

    @Override
    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setSmtpEmailAddress(String smtpEmailAddress) {
        this.smtpEmailAddress = smtpEmailAddress;
    }

    @Generated
    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    @Generated
    public void setSmtpPort(Long smtpPort) {
        this.smtpPort = smtpPort;
    }

    @Generated
    public void setSslOptions(SslOption sslOptions) {
        this.sslOptions = sslOptions;
    }

    @Generated
    public void setMailUsername(String mailUsername) {
        this.mailUsername = mailUsername;
    }

    @Generated
    public void setMailPassword(String mailPassword) {
        this.mailPassword = mailPassword;
    }

    @Generated
    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    @Generated
    public void setMailCc(String mailCc) {
        this.mailCc = mailCc;
    }

    @Generated
    public void setMailBcc(String mailBcc) {
        this.mailBcc = mailBcc;
    }

    @Generated
    public void setServiceLocation(String serviceLocation) {
        this.serviceLocation = serviceLocation;
    }

    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Accounts() {
    }
}

